/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.voltron.proxy.ClientId;
import org.terracotta.voltron.proxy.ExecutionStrategy;
import org.terracotta.voltron.proxy.MessageType;
import org.terracotta.voltron.proxy.MethodDescriptor;

public class ProxyEntityMessage
implements EntityMessage {
    private final MethodDescriptor method;
    private final Object[] args;
    private final MessageType type;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public ProxyEntityMessage(MethodDescriptor method, Object[] args, MessageType type) {
        this.method = method;
        this.args = args;
        this.type = type;
    }

    public MethodDescriptor getMethod() {
        return this.method;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Object[] getArguments() {
        return this.args;
    }

    public Object invoke(Object target, Object clientDescriptor) throws InvocationTargetException, IllegalAccessException {
        if (clientDescriptor != null) {
            Annotation[][] allAnnotations = this.method.getParameterAnnotations();
            block0: for (int i = 0; i < allAnnotations.length; ++i) {
                for (Annotation parameterAnnotation : allAnnotations[i]) {
                    if (parameterAnnotation.annotationType() != ClientId.class) continue;
                    this.args[i] = clientDescriptor;
                    continue block0;
                }
            }
        }
        return this.method.invoke(target, this.args);
    }

    public Object invoke(Object target) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(target, this.args);
    }

    public Class<?> messageType() {
        return this.method.getMessageType();
    }

    public int getConcurrencyKey() {
        return this.method.getConcurrencyKey();
    }

    public ExecutionStrategy.Location getExecutionLocation() {
        return this.method.getExecutionLocation();
    }

    public MessageType getType() {
        return this.type;
    }
}

