/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityUserException;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.exception.EntityException;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.MessageListener;
import org.terracotta.voltron.proxy.MessageType;
import org.terracotta.voltron.proxy.MethodDescriptor;
import org.terracotta.voltron.proxy.ProxyEntityMessage;
import org.terracotta.voltron.proxy.ProxyEntityResponse;
import org.terracotta.voltron.proxy.client.EndpointListener;
import org.terracotta.voltron.proxy.client.EndpointListenerAware;
import org.terracotta.voltron.proxy.client.ServerMessageAware;

class VoltronProxyInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltronProxyInvocationHandler.class);
    private static final Method close;
    private static final Method registerMessageListener;
    private static final Method setEndpointListener;
    private final EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> entityClientEndpoint;
    private final ExecutorService handler;
    private final ConcurrentMap<Class<?>, CopyOnWriteArrayList<MessageListener<?>>> listeners;
    private volatile EndpointListener endpointListener;

    VoltronProxyInvocationHandler(EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> entityClientEndpoint, Collection<Class<?>> events, final Codec codec) {
        this.entityClientEndpoint = entityClientEndpoint;
        this.handler = Executors.newSingleThreadExecutor(r -> new Thread(r, "Message Handler for " + entityClientEndpoint));
        this.listeners = new ConcurrentHashMap();
        if (events.size() > 0) {
            for (Class<?> aClass : events) {
                this.listeners.put(aClass, new CopyOnWriteArrayList());
            }
            entityClientEndpoint.setDelegate((EndpointDelegate)new EndpointDelegate<ProxyEntityResponse>(){

                public void handleMessage(ProxyEntityResponse response) {
                    try {
                        VoltronProxyInvocationHandler.this.handler.execute(() -> {
                            Class aClass = response.getResponseType();
                            try {
                                for (MessageListener messageListener : (CopyOnWriteArrayList)VoltronProxyInvocationHandler.this.listeners.get(aClass)) {
                                    messageListener.onMessage(response.getResponse());
                                }
                            }
                            catch (Exception e) {
                                LOGGER.warn("Error handling incoming server message {}: {}", new Object[]{aClass, e.getMessage(), e});
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }

                public byte[] createExtendedReconnectData() {
                    if (VoltronProxyInvocationHandler.this.endpointListener == null) {
                        return null;
                    }
                    Object state = VoltronProxyInvocationHandler.this.endpointListener.onReconnect();
                    if (state == null) {
                        return null;
                    }
                    return codec.encode(state.getClass(), state);
                }

                public void didDisconnectUnexpectedly() {
                    if (VoltronProxyInvocationHandler.this.endpointListener != null) {
                        VoltronProxyInvocationHandler.this.endpointListener.onDisconnectUnexpectedly();
                    }
                    VoltronProxyInvocationHandler.this.handler.shutdownNow();
                }
            });
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (close.equals(method)) {
            this.handler.shutdown();
            this.entityClientEndpoint.close();
            return null;
        }
        if (registerMessageListener.equals(method)) {
            Class eventType = (Class)args[0];
            MessageListener arg = (MessageListener)args[1];
            CopyOnWriteArrayList messageListeners = (CopyOnWriteArrayList)this.listeners.get(eventType);
            if (messageListeners == null) {
                throw new IllegalArgumentException("Event type '" + eventType + "' isn't supported");
            }
            messageListeners.add(arg);
            return null;
        }
        if (setEndpointListener.equals(method)) {
            this.endpointListener = (EndpointListener)args[0];
            return null;
        }
        MethodDescriptor methodDescriptor = MethodDescriptor.of((Method)method);
        InvocationBuilder builder = this.entityClientEndpoint.beginInvoke().message((EntityMessage)new ProxyEntityMessage(methodDescriptor, args, MessageType.MESSAGE)).withExecutor((Executor)this.handler);
        if (methodDescriptor.isAsync()) {
            switch (methodDescriptor.getAck()) {
                case NONE: {
                    break;
                }
                case RECEIVED: {
                    builder.ackReceived();
                    break;
                }
                default: {
                    throw new IllegalStateException(methodDescriptor.getAck().name());
                }
            }
            return new ProxiedInvokeFuture((InvokeFuture<ProxyEntityResponse>)builder.invoke());
        }
        return VoltronProxyInvocationHandler.getResponse((ProxyEntityResponse)builder.invoke().get());
    }

    private static Object getResponse(ProxyEntityResponse proxyEntityResponse) throws EntityUserException {
        if (proxyEntityResponse == null) {
            return null;
        }
        if (proxyEntityResponse.getMessageType() == MessageType.ERROR) {
            throw (EntityUserException)((Object)proxyEntityResponse.getResponse());
        }
        return proxyEntityResponse.getResponse();
    }

    static {
        try {
            close = Entity.class.getDeclaredMethod("close", new Class[0]);
            registerMessageListener = ServerMessageAware.class.getDeclaredMethod("registerMessageListener", Class.class, MessageListener.class);
            setEndpointListener = EndpointListenerAware.class.getDeclaredMethod("setEndpointListener", EndpointListener.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Someone changed some method signature here!!!");
        }
    }

    private static class ProxiedInvokeFuture<T>
    implements Future<T> {
        private final InvokeFuture<ProxyEntityResponse> future;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        public ProxiedInvokeFuture(InvokeFuture<ProxyEntityResponse> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.cancelled.compareAndSet(false, true)) {
                this.future.interrupt();
                return true;
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return (T)VoltronProxyInvocationHandler.getResponse((ProxyEntityResponse)this.future.get());
            }
            catch (EntityUserException | EntityException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return (T)VoltronProxyInvocationHandler.getResponse((ProxyEntityResponse)this.future.getWithTimeout(timeout, unit));
            }
            catch (EntityUserException | EntityException e) {
                throw new ExecutionException(e);
            }
        }
    }
}

