/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.search.expression;

import org.terracotta.toolkit.search.SearchException;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeType;
import org.terracotta.toolkit.search.expression.BaseClause;

public class Range
extends BaseClause {
    private final String attributeName;
    private final Comparable min;
    private final Comparable max;
    private final boolean minInclusive;
    private final boolean maxInclusive;

    public Range(String attributeName, Object min, Object max, boolean minInclusive, boolean maxInclusive) {
        this.verifyType(attributeName, min, max);
        this.attributeName = attributeName;
        this.min = (Comparable)min;
        this.max = (Comparable)max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    private void verifyType(String attrName, Object minValue, Object maxValue) {
        ToolkitAttributeType maxType;
        if (minValue == null || maxValue == null) {
            throw new NullPointerException();
        }
        ToolkitAttributeType minType = ToolkitAttributeType.typeFor(attrName, minValue);
        if (minType != (maxType = ToolkitAttributeType.typeFor(attrName, maxValue))) {
            throw new SearchException("Different types for min (" + (Object)((Object)minType) + ") and max (" + (Object)((Object)maxType) + ")");
        }
    }

    public Comparable getMin() {
        return this.min;
    }

    public Comparable getMax() {
        return this.max;
    }

    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.min).append(" ").append(this.minInclusive ? "<=" : "<");
        sb.append(" ").append(this.attributeName).append(" ");
        sb.append(this.maxInclusive ? "<=" : "<").append(" ").append(this.max);
        return sb.toString();
    }
}

