/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.search.expression;

import org.terracotta.toolkit.search.expression.BaseClause;
import org.terracotta.toolkit.search.expression.Clause;
import org.terracotta.toolkit.search.expression.CompositeClause;

public class BooleanClause
extends BaseClause
implements CompositeClause {
    private final Clause[] members;
    private final Operator op;

    public BooleanClause(Operator action, Clause ... clauses) {
        if (clauses == null) {
            throw new NullPointerException();
        }
        if (action == Operator.NOT) {
            if (clauses.length != 1) {
                throw new IllegalArgumentException("Expecting exactly one clause");
            }
        } else if (clauses.length < 2) {
            throw new IllegalArgumentException("Expecting at least two clauses");
        }
        this.members = clauses;
        this.op = action;
    }

    @Override
    public Clause[] getMembers() {
        return this.members;
    }

    public Operator type() {
        return this.op;
    }

    public String toString() {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        if (this.op == Operator.NOT) {
            sb.append((Object)this.op).append(" ");
        }
        boolean go = true;
        while (go) {
            sb.append("(").append(this.members[i]).append(")");
            if (++i < this.members.length) {
                sb.append(" ").append((Object)this.op).append(" ");
                continue;
            }
            go = false;
        }
        return sb.toString();
    }

    public static enum Operator {
        AND,
        OR,
        NOT;

    }
}

