/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.config;

import java.io.Serializable;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.config.SupportedConfigurationType;

public abstract class AbstractConfiguration
implements Configuration {
    public Configuration setObject(String name, Serializable newValue) {
        this.setMappingChecked(name, newValue);
        return this;
    }

    public Configuration setInt(String name, int newValue) {
        this.setMappingChecked(name, Integer.valueOf(newValue));
        return this;
    }

    public Configuration setLong(String name, long newValue) {
        this.setMappingChecked(name, Long.valueOf(newValue));
        return this;
    }

    public Configuration setBoolean(String name, boolean newValue) {
        this.setMappingChecked(name, Boolean.valueOf(newValue));
        return this;
    }

    public Configuration setString(String name, String newValue) {
        this.setMappingChecked(name, (Serializable)((Object)newValue));
        return this;
    }

    @Override
    public boolean hasField(String name) {
        return this.getObjectOrNull(name) != null;
    }

    protected Object getMappingChecked(String name) {
        Serializable obj = this.getObjectOrNull(name);
        if (obj == null) {
            throw new IllegalArgumentException("Configuration does not contain any mappings with name '" + name + "'");
        }
        if (SupportedConfigurationType.isTypeSupported(obj)) {
            return obj;
        }
        throw new IllegalArgumentException("Configuration mapping for name '" + name + "' exists, but is of type: " + obj.getClass().getName() + " which is not supported, with value: " + obj);
    }

    private void setMappingChecked(String name, Serializable value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (!SupportedConfigurationType.isTypeSupported(value)) {
            throw new IllegalArgumentException("Configuration doesn't support type: " + value.getClass().getName() + ", value: " + value);
        }
        this.internalSetConfigMapping(name, value);
    }

    @Override
    public int getInt(String name) {
        return this.getNumber(name).intValue();
    }

    @Override
    public long getLong(String name) {
        return this.getNumber(name).longValue();
    }

    private Number getNumber(String name) {
        return (Number)this.getMappingChecked(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return (Boolean)this.getMappingChecked(name);
    }

    @Override
    public String getString(String name) {
        return (String)this.getMappingChecked(name);
    }

    protected abstract void internalSetConfigMapping(String var1, Serializable var2);
}

