/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebClient {
    private Map cookies = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseAsString(URL url) throws IOException {
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setRequestProperty("Cookie", this.getCookiesAsString());
        http.connect();
        if (http.getResponseCode() != 200) {
            throw new IOException("Response code is not OK: " + http.getResponseMessage() + "\nRequest: " + url);
        }
        this.extractCookies(http);
        BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
        StringBuffer buffer = new StringBuffer(100);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignored) {}
        }
        return buffer.toString().trim();
    }

    public int getResponseAsInt(URL url) throws IOException {
        String response = this.getResponseAsString(url);
        return Integer.parseInt(response);
    }

    public void setCookies(Map cookies) {
        this.cookies = cookies;
        System.out.println(cookies);
    }

    public Map getCookies() {
        return this.cookies;
    }

    private String getCookiesAsString() {
        StringBuffer cookiesString = new StringBuffer(100);
        Iterator it = this.cookies.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            cookiesString.append(e.getKey().toString()).append("=").append(e.getValue().toString());
            if (!it.hasNext()) continue;
            cookiesString.append("; ");
        }
        return cookiesString.toString();
    }

    private void extractCookies(URLConnection urlConnect) {
        Map<String, List<String>> headerFields = urlConnect.getHeaderFields();
        List<String> cookieList = headerFields.get("Set-Cookie");
        if (cookieList != null) {
            for (String cookie : cookieList) {
                cookie = cookie.substring(0, cookie.indexOf(";"));
                String[] pair = cookie.split("=", 2);
                this.cookies.put(pair[0], pair[1]);
            }
        }
    }
}

