/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.util;

import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class VmStat {
    private static Process process;
    private static File scriptFile;
    private static final String scriptName = "capture-vmstat.sh";
    private static final String scriptContents = "#!/bin/sh\nexec vmstat 1 > vmstat.txt\n";

    public static synchronized void start(File workingDir) throws IOException {
        if (process != null) {
            VmStat.stop();
            throw new IllegalStateException("VmStat is already running. Stopping VmStat...");
        }
        if (Os.isWindows() || Os.isMac()) {
            return;
        }
        String[] commandLine = new String[]{"/bin/bash", VmStat.createScriptFile(workingDir).toString()};
        Runtime runtime = Runtime.getRuntime();
        process = runtime.exec(commandLine, null, workingDir);
        String msg = "\n";
        msg = msg + "*****************************\n";
        msg = msg + "* Running vmstat in [" + workingDir + "]\n";
        msg = msg + "*****************************\n";
        System.out.println(msg);
    }

    public static synchronized void stop() {
        if (process != null) {
            process.destroy();
            process = null;
            VmStat.deleteScriptFile();
        }
    }

    private static synchronized File createScriptFile(File baseDir) throws IOException {
        if (scriptFile != null) {
            return scriptFile;
        }
        File script = new File(baseDir + File.separator + scriptName);
        script.createNewFile();
        FileOutputStream out = new FileOutputStream(script);
        out.write(scriptContents.getBytes());
        out.flush();
        out.close();
        scriptFile = script;
        return scriptFile;
    }

    private static synchronized void deleteScriptFile() {
        if (scriptFile != null) {
            scriptFile.delete();
            scriptFile = null;
        }
    }
}

