/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URL;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public final class HttpUtil {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int DEFAULT_MAX_CONN = 1000;
    private static final boolean DEBUG = false;

    private HttpUtil() {
    }

    public static HttpClient createHttpClient() {
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        client.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        client.getHttpConnectionManager().getParams().setMaxTotalConnections(1000);
        return client;
    }

    public static boolean getBoolean(URL url, HttpClient client) throws ConnectException, IOException {
        return Boolean.valueOf(HttpUtil.getResponseBody(url, client));
    }

    public static boolean[] getBooleanValues(URL url, HttpClient client) throws ConnectException, IOException {
        String responseBody = HttpUtil.getResponseBody(url, client);
        String[] lines = responseBody.split("\n");
        boolean[] values = new boolean[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            values[i] = Boolean.valueOf(lines[i].trim());
        }
        return values;
    }

    public static String getResponseBody(URL url, HttpClient client) throws HttpException, IOException {
        return HttpUtil.getResponseBody(url, client, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseBody(URL url, HttpClient client, boolean retryIfFail) throws HttpException, IOException {
        StringBuffer response = new StringBuffer(100);
        Cookie[] cookies = client.getState().getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            HttpUtil.debugPrint("localClient... cookie " + i + ": " + cookies[i].toString());
        }
        GetMethod get = new GetMethod(url.toString());
        if (retryIfFail) {
            get.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        } else {
            get.getParams().setParameter("http.method.retry-handler", (Object)NoRetryHandler.INSTANCE);
        }
        BufferedReader reader = null;
        try {
            String line;
            int status = client.executeMethod((HttpMethod)get);
            if (status != 200) {
                throw new HttpException("The http client has encountered a status code other than ok for the url: " + url + " status: " + HttpStatus.getStatusText((int)status));
            }
            reader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream()));
            while ((line = reader.readLine()) != null) {
                response.append(line).append("\n");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            get.releaseConnection();
        }
        return response.toString().trim();
    }

    public static int getInt(URL url, HttpClient client) throws ConnectException, IOException {
        return Integer.valueOf(HttpUtil.getResponseBody(url, client));
    }

    public static int[] getIntValues(URL url, HttpClient client) throws ConnectException, IOException {
        String responseBody = HttpUtil.getResponseBody(url, client);
        String[] lines = responseBody.split("\n");
        int[] values = new int[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            values[i] = Integer.valueOf(lines[i].trim());
        }
        return values;
    }

    private static void debugPrint(String s) {
    }

    private static class NoRetryHandler
    implements HttpMethodRetryHandler {
        static final NoRetryHandler INSTANCE = new NoRetryHandler();

        private NoRetryHandler() {
        }

        public boolean retryMethod(HttpMethod httpmethod, IOException ioexception, int i) {
            return false;
        }
    }
}

