/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.util;

import com.tc.lcp.HeartBeatService;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.AppServerFactory;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.text.Banner;
import com.tc.util.PortChooser;
import com.tc.util.concurrent.ThreadUtil;
import com.tc.util.io.TCFileUtils;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class AppServerUtil {
    private static final PortChooser pc = new PortChooser();
    private static final TestConfigObject config = TestConfigObject.getInstance();

    public static int getPort() {
        return pc.chooseRandomPort();
    }

    public static void waitForPort(int port, long waitTime) {
        long timeout = System.currentTimeMillis() + waitTime;
        while (System.currentTimeMillis() < timeout) {
            if (AppServerUtil.pingPort(port)) {
                return;
            }
            ThreadUtil.reallySleep((long)1000L);
        }
        throw new RuntimeException("Port " + port + " cannot be reached, timeout = " + waitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingPort(int port) {
        Socket s = null;
        try {
            s = new Socket("127.0.0.1", port);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static String getFullName(String serverName, String majorVersion, String minorVersion) {
        return serverName.toLowerCase() + "-" + majorVersion.toLowerCase() + "." + minorVersion.toLowerCase();
    }

    public static boolean awaitShutdown(int timewait) {
        long start = System.currentTimeMillis();
        long timeout = (long)timewait + start;
        boolean foundAlive = false;
        do {
            ThreadUtil.reallySleep((long)5000L);
        } while ((foundAlive = HeartBeatService.anyAppServerAlive()) && System.currentTimeMillis() < timeout);
        return foundAlive;
    }

    public static void shutdownAndArchive(File from, File to) {
        AppServerUtil.shutdown();
        AppServerUtil.archive(from, to);
    }

    public static void forceShutdownAndArchive(File from, File to) {
        System.out.println("Send kill signal to app servers...");
        HeartBeatService.sendKillSignalToChildren();
        ThreadUtil.reallySleep((long)1000L);
        AppServerUtil.archive(from, to);
    }

    public static void shutdown() {
        AppServerUtil.awaitShutdown(120000);
        System.out.println("Send kill signal to app servers...");
        HeartBeatService.sendKillSignalToChildren();
    }

    public static File createSandbox(File tempDir) {
        File sandbox;
        block4: {
            sandbox = null;
            sandbox = Os.isWindows() ? new File(config.cacheDir(), "sandbox") : new File(tempDir, "sandbox");
            try {
                if (!sandbox.exists()) break block4;
                if (sandbox.isDirectory()) {
                    FileUtils.cleanDirectory((File)sandbox);
                    break block4;
                }
                throw new RuntimeException(sandbox + " exists, but is not a directory");
            }
            catch (IOException e) {
                File prev = sandbox;
                sandbox = new File(sandbox.getAbsolutePath() + "-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()));
                Banner.warnBanner((String)("Caught IOException setting up workDir as " + prev + ", using " + sandbox + " instead"));
            }
        }
        if (!sandbox.exists() && !sandbox.mkdirs()) {
            throw new RuntimeException("Failed to create sandbox: " + sandbox);
        }
        return sandbox;
    }

    public static AppServerInstallation createAppServerInstallation(AppServerFactory appServerFactory, File installDir, File sandbox) throws Exception {
        AppServerInstallation installation = null;
        String appserverHome = config.appserverHome();
        if (appserverHome == null || appserverHome.trim().equals("")) {
            throw new AssertionError((Object)"No appserver found! You must define: tc.tests.configuration.appserver.home");
        }
        installation = appServerFactory.createInstallation(new File(appserverHome), sandbox, config.appServerInfo());
        return installation;
    }

    public static void archive(File from, File to) {
        if (!from.equals(to)) {
            System.out.println("Copying files from " + from + " to " + to);
            try {
                TCFileUtils.copyFile((File)from, (File)to);
            }
            catch (IOException ioe) {
                Banner.warnBanner((String)"IOException caught while copying workingDir files");
                ioe.printStackTrace();
            }
            System.out.println("Delete files in: " + from);
            try {
                FileUtils.forceDelete((File)from);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

