/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.websphere;

import com.tc.process.Exec;
import com.tc.test.TestConfigObject;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.util.AppServerUtil;
import com.tc.text.Banner;
import com.tc.util.PortChooser;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class WebsphereAppServer
extends AbstractAppServer {
    private static final String TERRACOTTA_PY = "terracotta.py";
    private static final String DEPLOY_APPS_PY = "deployApps.py";
    private static final String ENABLE_DSO_PY = "enable-dso.py";
    private static final String DSO_JVMARGS = "__DSO_JVMARGS__";
    private static final String PORTS_DEF = "ports.def";
    private static final int START_STOP_TIMEOUT_SECONDS = 300;
    private final String[] scripts = new String[]{"deployApps.py", "terracotta.py", "enable-dso.py"};
    private final String policy = "grant codeBase \"file:FILENAME\" {" + IOUtils.LINE_SEPARATOR + "  permission java.security.AllPermission;" + IOUtils.LINE_SEPARATOR + "};" + IOUtils.LINE_SEPARATOR;
    private String instanceName;
    private String dsoJvmArgs;
    private int webspherePort;
    private File sandbox;
    private File instanceDir;
    private File pyScriptsDir;
    private File dataDir;
    private File warDir;
    private File portDefFile;
    private File serverInstallDir;
    private File extraScript;
    private Thread serverThread;

    public WebsphereAppServer(AppServerInstallation installation) {
        super(installation);
    }

    @Override
    public ServerResult start(ServerParameters parameters) throws Exception {
        this.init(parameters);
        this.createPortFile();
        this.copyPythonScripts();
        this.patchTerracottaPy();
        this.deleteProfileIfExists();
        this.createProfile();
        this.verifyProfile();
        this.deployWebapps();
        this.addTerracottaToServerPolicy();
        this.enableDSO();
        if (this.extraScript != null) {
            this.executeJythonScript(this.extraScript);
        }
        this.serverThread = new Thread(){

            @Override
            public void run() {
                try {
                    WebsphereAppServer.this.startWebsphere();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.serverThread.setDaemon(true);
        this.serverThread.start();
        AppServerUtil.waitForPort(this.webspherePort, 300000L);
        System.out.println("Websphere instance " + this.instanceName + " started on port " + this.webspherePort);
        return new AppServerResult(this.webspherePort, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(ServerParameters parameters) throws Exception {
        try {
            this.stopWebsphere();
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.copyClientLogs();
            try {
                this.deleteProfile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void copyClientLogs() {
        File srcDir = new File(this.instanceDir, "terracotta");
        if (srcDir.isDirectory()) {
            File dstDir = new File(this.instanceDir, "logs");
            if (dstDir.isDirectory()) {
                try {
                    FileUtils.copyDirectoryToDirectory((File)srcDir, (File)dstDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Banner.warnBanner((String)(dstDir + " is not a directory?"));
            }
        } else {
            Banner.warnBanner((String)(srcDir + " is not a directory?"));
        }
    }

    private void createPortFile() throws Exception {
        PortChooser portChooser = new PortChooser();
        this.webspherePort = portChooser.chooseRandomPort();
        List lines = IOUtils.readLines((InputStream)WebsphereAppServer.class.getResourceAsStream(PORTS_DEF));
        lines.set(0, (String)lines.get(0) + this.webspherePort);
        for (int i = 1; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            lines.set(i, line + portChooser.chooseRandomPort());
        }
        this.writeLines(lines, this.portDefFile, false);
    }

    private void copyPythonScripts() throws Exception {
        for (String script : this.scripts) {
            System.out.println("copyPythonScripts(): copying file[" + script + "] to directory [" + this.pyScriptsDir + "]");
            this.copyResourceTo(script, new File(this.pyScriptsDir, script));
        }
    }

    private void enableDSO() throws Exception {
        String[] args = new String[]{"-lang", "jython", "-connType", "NONE", "-profileName", this.instanceName, "-f", new File(this.pyScriptsDir, ENABLE_DSO_PY).getAbsolutePath()};
        this.executeCommand(this.serverInstallDir, "wsadmin", args, this.pyScriptsDir, "Error in enabling DSO for " + this.instanceName);
    }

    private void patchTerracottaPy() throws FileNotFoundException, IOException, Exception {
        File terracotta_py = new File(this.pyScriptsDir, TERRACOTTA_PY);
        FileInputStream fin = new FileInputStream(terracotta_py);
        List lines = IOUtils.readLines((InputStream)fin);
        fin.close();
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.indexOf(DSO_JVMARGS) < 0) continue;
            line = line.replaceFirst(DSO_JVMARGS, this.dsoJvmArgs);
            lines.set(i, line);
        }
        this.writeLines(lines, terracotta_py, false);
    }

    private void executeJythonScript(File script) throws Exception {
        String[] args = new String[]{"-lang", "jython", "-connType", "NONE", "-profileName", this.instanceName, "-f", script.getAbsolutePath()};
        this.executeCommand(this.serverInstallDir, "wsadmin", args, this.pyScriptsDir, "Error executing " + script);
    }

    private void deleteProfile() throws Exception {
        String[] args = new String[]{"-delete", "-profileName", this.instanceName};
        this.executeCommand(this.serverInstallDir, "manageprofiles", args, this.serverInstallDir, "Error in deleting profile for " + this.instanceName);
    }

    private void createProfile() throws Exception {
        String defaultTemplate = new File(this.serverInstallDir.getAbsolutePath(), "profileTemplates/default").getAbsolutePath();
        String[] args = new String[]{"-create", "-templatePath", defaultTemplate, "-profileName", this.instanceName, "-profilePath", this.instanceDir.getAbsolutePath(), "-portsFile", this.portDefFile.getAbsolutePath(), "-enableAdminSecurity", "false"};
        System.out.println("Creating profile for instance " + this.instanceName + "...");
        long start = System.currentTimeMillis();
        String output = this.executeCommand(this.serverInstallDir, "manageprofiles", args, this.serverInstallDir, "Error in creating profile for " + this.instanceName);
        if (output.contains("is already in use. Specify another name")) {
            this.deleteProfile();
            this.executeCommand(this.serverInstallDir, "manageprofiles", args, this.serverInstallDir, "Error in creating profile for " + this.instanceName);
        }
        long elapsedMillis = System.currentTimeMillis() - start;
        long elapsedSeconds = elapsedMillis / 1000L;
        Long elapsedMinutes = new Long(elapsedSeconds / 60L);
        System.out.println("Profile creation time: " + MessageFormat.format("{0,number,##}:{1}.{2}", elapsedMinutes, new Long(elapsedSeconds % 60L), new Long(elapsedMillis % 1000L)));
    }

    private void verifyProfile() throws Exception {
        if (!this.instanceDir.exists() || !this.instanceDir.isDirectory()) {
            Exception e = new Exception("Unable to verify profile for instance '" + this.instanceName + "'");
            System.err.println("WebSphere profile '" + this.instanceName + "' does not exist at " + this.instanceDir.getAbsolutePath());
            throw e;
        }
        System.out.println("WebSphere profile '" + this.instanceName + "' is verified at " + this.instanceDir.getAbsolutePath());
    }

    private void deleteProfileIfExists() throws Exception {
        String[] args = new String[]{"-validateAndUpdateRegistry"};
        this.executeCommand(this.serverInstallDir, "manageprofiles", args, this.serverInstallDir, "");
        args = new String[]{"-listProfiles"};
        String output = this.executeCommand(this.serverInstallDir, "manageprofiles", args, this.serverInstallDir, "");
        if (output.indexOf(this.instanceName) >= 0) {
            args = new String[]{"-delete", "-profileName", this.instanceName};
            this.executeCommand(this.serverInstallDir, "manageprofiles", args, this.serverInstallDir, "Trying to clean up existing profile");
        }
    }

    private void addTerracottaToServerPolicy() throws Exception {
        String[] entries;
        String classpath = System.getProperty("java.class.path");
        HashSet<File> set = new HashSet<File>();
        for (String entrie : entries = classpath.split(File.pathSeparator)) {
            File filename = new File(entrie);
            if (filename.isDirectory()) {
                set.add(filename);
                continue;
            }
            set.add(filename.getParentFile());
        }
        ArrayList<String> lines = new ArrayList<String>(set.size() + 1);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            lines.add(this.getPolicyFor((File)it.next()));
        }
        lines.add(this.getPolicyFor(new File(TestConfigObject.getInstance().normalBootJar())));
        this.writeLines(lines, new File(new File(this.instanceDir, "properties"), "server.policy"), true);
    }

    private String getPolicyFor(File filename) {
        String entry = filename.getAbsolutePath().replace('\\', '/');
        if (filename.isDirectory()) {
            return this.policy.replaceFirst("FILENAME", entry + "/-");
        }
        return this.policy.replaceFirst("FILENAME", entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceTo(String filename, File dest) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest);
            IOUtils.copy((InputStream)WebsphereAppServer.class.getResourceAsStream(filename), (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private void deployWebapps() throws Exception {
        String[] args = new String[]{"-lang", "jython", "-connType", "NONE", "-profileName", this.instanceName, "-f", new File(this.pyScriptsDir, DEPLOY_APPS_PY).getAbsolutePath(), this.warDir.getAbsolutePath().replace('\\', '/')};
        System.out.println("Deploying war file in: " + this.warDir);
        this.executeCommand(this.serverInstallDir, "wsadmin", args, this.pyScriptsDir, "Error in deploying warfile for " + this.instanceName);
        System.out.println("Done deploying war file in: " + this.warDir);
    }

    private void startWebsphere() throws Exception {
        String[] args = new String[]{"server1", "-profileName", this.instanceName, "-trace", "-timeout", String.valueOf(300)};
        this.executeCommand(this.serverInstallDir, "startServer", args, this.instanceDir, "Error in starting " + this.instanceName);
    }

    private void stopWebsphere() throws Exception {
        String[] args = new String[]{"server1", "-profileName", this.instanceName};
        this.executeCommand(this.serverInstallDir, "stopServer", args, this.instanceDir, "Error in stopping " + this.instanceName);
        if (this.serverThread != null) {
            this.serverThread.join(300000L);
        }
    }

    private void init(ServerParameters parameters) {
        AppServerParameters params = (AppServerParameters)parameters;
        this.sandbox = this.sandboxDirectory();
        this.instanceName = params.instanceName();
        this.instanceDir = new File(this.sandbox, this.instanceName);
        this.dataDir = new File(this.sandbox, "data");
        this.warDir = new File(this.sandbox, "war");
        this.pyScriptsDir = new File(this.dataDir, this.instanceName);
        this.pyScriptsDir.mkdirs();
        this.portDefFile = new File(this.pyScriptsDir, PORTS_DEF);
        this.serverInstallDir = this.serverInstallDirectory();
        String[] jvm_args = params.jvmArgs().replaceAll("'", "").replace('\\', '/').split("\\s+");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < jvm_args.length; ++i) {
            sb.append("\"" + jvm_args[i] + "\"");
            if (i >= jvm_args.length - 1) continue;
            sb.append(", ");
        }
        this.dsoJvmArgs = sb.toString();
        System.out.println("init{sandbox}          ==> " + this.sandbox.getAbsolutePath());
        System.out.println("init{instanceName}     ==> " + this.instanceName);
        System.out.println("init{instanceDir}      ==> " + this.instanceDir.getAbsolutePath());
        System.out.println("init{webappDir}        ==> " + this.dataDir.getAbsolutePath());
        System.out.println("init{pyScriptsDir}     ==> " + this.pyScriptsDir.getAbsolutePath());
        System.out.println("init{portDefFile}      ==> " + this.portDefFile.getAbsolutePath());
        System.out.println("init{serverInstallDir} ==> " + this.serverInstallDir.getAbsolutePath());
        System.out.println("init{dsoJvmArgs}       ==> " + this.dsoJvmArgs);
    }

    private String getScriptPath(File root, String scriptName) {
        File bindir = new File(root, "bin");
        return new File(bindir, Os.isWindows() ? scriptName + ".bat" : scriptName + ".sh").getAbsolutePath();
    }

    private String executeCommand(File rootDir, String scriptName, String[] args, File workingDir, String errorMessage) throws Exception {
        String script = this.getScriptPath(rootDir, scriptName);
        String[] cmd = new String[args.length + 1];
        cmd[0] = script;
        System.arraycopy(args, 0, cmd, 1, args.length);
        System.out.println("Executing cmd: " + Arrays.asList(cmd));
        Exec.Result result = Exec.execute((String[])cmd, null, null, (File)(workingDir == null ? this.instanceDir : workingDir));
        StringBuffer stdout = new StringBuffer(result.getStdout());
        StringBuffer stderr = new StringBuffer(result.getStderr());
        if (result.getExitCode() != 0) {
            System.out.println("Command did not return 0; message is: " + errorMessage);
        }
        String output = stdout.append(IOUtils.LINE_SEPARATOR).append(stderr).toString();
        System.out.println("output: " + output);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLines(List lines, File filename, boolean append) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename, append);
            IOUtils.writeLines((Collection)lines, (String)IOUtils.LINE_SEPARATOR, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public void setExtraScript(File extraScript) {
        this.extraScript = extraScript;
    }
}

