/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.weblogic9x;

import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.weblogic.WeblogicAppServerBase;
import com.tc.test.server.appserver.weblogic9x.Weblogic9xAppServerInstallation;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogic9xInstalledLocalContainer;

public final class Weblogic9xAppServer
extends WeblogicAppServerBase {
    public Weblogic9xAppServer(Weblogic9xAppServerInstallation installation) {
        super(installation);
    }

    @Override
    protected String cargoServerKey() {
        return "weblogic9x";
    }

    @Override
    protected InstalledLocalContainer container(LocalConfiguration config, AppServerParameters params) {
        return new TCWebLogic9xInstalledLocalContainer(config);
    }

    @Override
    protected void setConfigProperties(LocalConfiguration config) throws Exception {
    }

    private static class TCWebLogic9xInstalledLocalContainer
    extends WebLogic9xInstalledLocalContainer {
        public TCWebLogic9xInstalledLocalContainer(LocalConfiguration configuration) {
            super(configuration);
        }

        public void doStop(Java java) throws Exception {
            WeblogicAppServerBase.doStop(this.getConfiguration());
        }

        protected void setState(State state) {
            if (state.equals(State.STARTING)) {
                this.setBeaHomeIfNeeded();
                this.prepareSecurityFile();
            }
        }

        private void setBeaHomeIfNeeded() {
            File license = new File(this.getHome(), "license.bea");
            if (license.exists()) {
                this.setBeaHome(this.getHome());
            }
        }

        private void prepareSecurityFile() {
            if (Os.isLinux() || Os.isSolaris()) {
                try {
                    String[] resources;
                    for (String resource : resources = new String[]{"security/SerializedSystemIni.dat"}) {
                        File dest = new File(this.getConfiguration().getHome(), resource);
                        this.copyResource("linux/" + resource, dest);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyResource(String name, File dest) throws IOException {
            dest.getParentFile().mkdirs();
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }
}

