/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.weblogic10x;

import com.tc.test.AppServerInfo;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.weblogic.WeblogicAppServerBase;
import com.tc.test.server.appserver.weblogic10x.Weblogic10xAppServerInstallation;
import com.tc.util.ReplaceLine;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogic10xInstalledLocalContainer;

public final class Weblogic10xAppServer
extends WeblogicAppServerBase {
    public Weblogic10xAppServer(Weblogic10xAppServerInstallation installation) {
        super(installation);
    }

    @Override
    protected String cargoServerKey() {
        return "weblogic10x";
    }

    @Override
    protected InstalledLocalContainer container(LocalConfiguration config, AppServerParameters params) {
        return new TCWebLogic10xInstalledLocalContainer(config, params);
    }

    @Override
    protected void setConfigProperties(LocalConfiguration config) throws Exception {
    }

    private static class TCWebLogic10xInstalledLocalContainer
    extends WebLogic10xInstalledLocalContainer {
        private final AppServerParameters params;

        public TCWebLogic10xInstalledLocalContainer(LocalConfiguration configuration, AppServerParameters params) {
            super(configuration);
            this.params = params;
        }

        public void doStop(Java java) throws Exception {
            WeblogicAppServerBase.doStop(this.getConfiguration());
        }

        protected void setState(State state) {
            if (state.equals(State.STARTING)) {
                this.adjustConfig();
                this.setBeaHomeIfNeeded();
                this.prepareSecurityFile();
            }
        }

        private void adjustConfig() {
            String insert = "";
            insert = insert + "    <native-io-enabled>false</native-io-enabled>\n";
            insert = insert + "    <socket-reader-timeout-min-millis>1000</socket-reader-timeout-min-millis>\n";
            insert = insert + "    <socket-reader-timeout-max-millis>1000</socket-reader-timeout-max-millis>\n";
            ReplaceLine.Token[] tokens = new ReplaceLine.Token[]{new ReplaceLine.Token(28, "    <listen-port>", insert + "    <listen-port>")};
            try {
                ReplaceLine.parseFile((ReplaceLine.Token[])tokens, (File)new File(this.getConfiguration().getHome(), "/config/config.xml"));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private void setBeaHomeIfNeeded() {
            File license = new File(this.getHome(), "license.bea");
            if (license.exists()) {
                this.setBeaHome(this.getHome());
            }
        }

        private void prepareSecurityFile() {
            if (Os.isLinux() || Os.isSolaris()) {
                try {
                    String[] resources;
                    for (String resource2 : resources = new String[]{"security/SerializedSystemIni.dat"}) {
                        String resource = "linux/" + resource2;
                        File dest = new File(this.getConfiguration().getHome(), resource2);
                        this.copyResource(resource, dest);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyResource(String name, File dest) throws IOException {
            dest.getParentFile().mkdirs();
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }

        protected void addToClassPath(Path classpath) {
            AppServerInfo appServerInfo = TestConfigObject.getInstance().appServerInfo();
            File modulesDir = new File(this.getHome(), "modules");
            if (appServerInfo.toString().equals("weblogic-10.0.mp1")) {
                classpath.createPathElement().setLocation(new File(modulesDir, "features/weblogic.server.modules_10.0.1.0.jar"));
                classpath.createPathElement().setLocation(new File(modulesDir, "features/com.bea.cie.common-plugin.launch_2.1.2.0.jar"));
                classpath.createPathElement().setLocation(new File(modulesDir, "org.apache.ant_1.6.5/lib/ant-all.jar"));
                classpath.createPathElement().setLocation(new File(modulesDir, "net.sf.antcontrib_1.0b2.0/lib/ant-contrib.jar"));
            } else if (appServerInfo.toString().equals("weblogic-10.3.0")) {
                classpath.createPathElement().setLocation(new File(modulesDir, "features/weblogic.server.modules_10.3.0.0.jar"));
                classpath.createPathElement().setLocation(new File(modulesDir, "org.apache.ant_1.6.5/lib/ant-all.jar"));
                classpath.createPathElement().setLocation(new File(modulesDir, "net.sf.antcontrib_1.0.0.0_1-0b2/lib/ant-contrib.jar"));
            } else if (appServerInfo.toString().equals("weblogic-10.3.1")) {
                classpath.createPathElement().setLocation(new File(modulesDir, "features/weblogic.server.modules_10.3.1.0.jar"));
                classpath.createPathElement().setLocation(new File(modulesDir, "org.apache.ant_1.7.0/lib/ant-all.jar"));
                classpath.createPathElement().setLocation(new File(modulesDir, "net.sf.antcontrib_1.0.0.0_1-0b2/lib/ant-contrib.jar"));
            }
            this.params.properties().setProperty("classpath", classpath.toString());
        }
    }
}

