/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.weblogic;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.cargo.CargoAppServer;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.test.server.appserver.deployment.WARBuilder;
import com.tc.test.server.appserver.weblogic.WeblogicShutdownServlet;
import java.io.File;
import java.util.HashMap;
import junit.framework.Assert;
import org.codehaus.cargo.container.configuration.LocalConfiguration;

public abstract class WeblogicAppServerBase
extends CargoAppServer {
    private static final String CONTEXT = "WLS_SHUTDOWN_HACK";

    public WeblogicAppServerBase(AppServerInstallation installation) {
        super(installation);
    }

    @Override
    protected void adjustParams(StandardAppServerParameters params) throws Exception {
        WARBuilder builder = new WARBuilder("WLS_SHUTDOWN_HACK.war", new File(this.sandboxDirectory(), "war"));
        builder.addServlet("shutdown", "/*", WeblogicShutdownServlet.class, new HashMap(), true);
        Deployment deployment = builder.makeDeployment();
        params.addDeployment(CONTEXT, deployment);
    }

    public static void doStop(LocalConfiguration configuration) throws Exception {
        String port = configuration.getPropertyValue("cargo.servlet.port");
        WebConversation wc = new WebConversation();
        String fullURL = "http://localhost:" + port + "/WLS_SHUTDOWN_HACK/Go";
        wc.setExceptionsThrownOnErrorStatus(true);
        WebResponse response = wc.getResponse(fullURL);
        Assert.assertEquals((String)("Server error:\n" + response.getText()), (int)200, (int)response.getResponseCode());
        Assert.assertEquals((String)("Server error:\n" + response.getText()), (int)0, (int)response.getContentLength());
    }
}

