/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.wasce1x;

import com.tc.lcp.CargoLinkedChildProcess;
import com.tc.lcp.HeartBeatService;
import com.tc.process.StreamAppender;
import com.tc.test.TestConfigObject;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.wasce1x.Wasce1xAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import com.tc.util.Assert;
import com.tc.util.concurrent.ThreadUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.cargo.container.geronimo.internal.GeronimoUtils;
import org.codehaus.cargo.util.log.Logger;

public final class Wasce1xAppServer
extends AbstractAppServer {
    private static final String JAVA_CMD = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private static final String CONFIG_STORE = "config-store";
    private static final String REPOSITORY = "repository";
    private static final String VAR = "var";
    private static final String BIN = "bin" + File.separator;
    private static final String SERVER_JAR = BIN + "server.jar";
    private static final String SHUTDOWN_JAR = BIN + "shutdown.jar";
    private static final String DEPLOYER_JAR = BIN + "deployer.jar";
    private static final String CONFIG_DIR = "var" + File.separator + "config";
    private static final String CONFIG = "config.xml";
    private static final String PORT_ATTRIB = ".*<attribute name=\"port\">\\d{4,6}</attribute>.*";
    private static final String REDIRECT_PORT_ATTRIB = ".*<attribute name=\"redirectPort\">\\d{4,6}</attribute>.*";
    private static final String PORT_PREFIX = "ort\">";
    private static final String WEB_PORT_ATTRIB = ".*<gbean name=\"TomcatWebConnector\">.*";
    private static final String RMI_PORT_ATTRIB = ".*<gbean name=\"RMIRegistry\">.*";
    private static final String RMI_PORT_URL = ".*<attribute name=\"namingProviderUrl\">rmi://0.0.0.0:\\d{4,6}</attribute>.*";
    private static final String RMI_PREFIX = "rmi://0.0.0.0:";
    private static final String JMX_RMI = ".*<gbean name=\"JMXService\">.*";
    private static final String JMX_RMI_PREFIX = "service:jmx:rmi://0.0.0.0:";
    private static final String NAME_TEXT = ".*name=Geronimo.*";
    private static final String BASE_DIR_PROP = "org.apache.geronimo.base.dir";
    private static final String TMP_DIR_PROP = "java.io.tmpdir";
    private static final String ENDORSED_DIR_PROP = "java.endorsed.dirs";
    private static final String USERNAME = "system";
    private static final String PASSWORD = "manager";
    private static final long STARTUP_TIMEOUT = 240000L;
    private String className;
    private String classpath;
    private String endorsedPath;
    private String installPath;
    private int rmiPort;
    private AbstractAppServer.ConsoleLogger consoleLogger;
    private static final String LOG_CAT = "WASCE 1.0 STARTUP";
    private String instanceName;

    public Wasce1xAppServer(Wasce1xAppServerInstallation installation) {
        super(installation);
    }

    private File getHome() {
        return this.serverInstallDirectory();
    }

    @Override
    public synchronized ServerResult start(ServerParameters rawParams) throws Exception {
        TestConfigObject config = TestConfigObject.getInstance();
        AppServerParameters params = (AppServerParameters)rawParams;
        int port = AppServerUtil.getPort();
        this.instanceName = params.instanceName();
        final File instance = this.createInstance(params);
        File home = this.getHome();
        this.installPath = home.getCanonicalPath();
        this.setProperties(params, port, instance);
        this.interpretJarManifest(new File(home + File.separator + SERVER_JAR));
        this.copyInstanceDirectories(home, instance);
        this.parseConfig(new File(instance + File.separator + CONFIG_DIR), port);
        final LinkedList<String> cl = new LinkedList<String>();
        cl.add(JAVA_CMD);
        String[] jvmArgs = params.jvmArgs().replaceAll("'", "").split("\\s");
        for (int i = 0; i < jvmArgs.length; ++i) {
            if (("" + jvmArgs[i]).trim().equals("")) continue;
            cl.add(jvmArgs[i]);
        }
        cl.add("-Djava.endorsed.dirs=" + this.endorsedPath);
        cl.add("-Djava.io.tmpdir=" + instance.getCanonicalPath() + File.separator + VAR + File.separator + "temp");
        cl.add("-Dorg.apache.geronimo.base.dir=" + instance.getCanonicalPath());
        cl.add("-classpath");
        cl.add(this.classpath + File.pathSeparatorChar + config.extraClassPathForAppServer());
        cl.add(CargoLinkedChildProcess.class.getName());
        cl.add(this.className);
        cl.add(String.valueOf(HeartBeatService.listenPort()));
        cl.add(instance.toString());
        cl.add("--long");
        this.consoleLogger = new AbstractAppServer.ConsoleLogger(params.instanceName());
        this.consoleLogger.info(Arrays.asList(cl.toArray(new String[0])).toString(), LOG_CAT);
        AbstractAppServer.ConsoleLogger logger = this.consoleLogger;
        final String logFileName = new File(instance.getParent(), instance.getName() + ".log").getAbsolutePath();
        Thread t = new Thread((Logger)logger){
            final /* synthetic */ Logger val$logger;
            {
                this.val$logger = logger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileOutputStream logFile = null;
                try {
                    logFile = new FileOutputStream(logFileName);
                    Process process = Runtime.getRuntime().exec(cl.toArray(new String[0]), null, instance);
                    StreamAppender appender = new StreamAppender((OutputStream)logFile);
                    appender.writeInput(process.getErrorStream(), process.getInputStream());
                    if (process.waitFor() != 0) {
                        this.val$logger.warn("Server exited with exit code other than 0", Wasce1xAppServer.LOG_CAT);
                    }
                    appender.finish();
                }
                catch (Exception e) {
                    this.val$logger.warn("Server process failed", Wasce1xAppServer.LOG_CAT);
                    e.printStackTrace();
                }
                finally {
                    if (logFile != null) {
                        try {
                            logFile.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        t.start();
        this.waitForStartup(port);
        this.deployWars(params.deployables());
        return new AppServerResult(port, this);
    }

    private void waitForStartup(int port) throws Exception {
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        long timeout = System.currentTimeMillis() + 240000L;
        GeronimoUtils utils = new GeronimoUtils();
        ClassLoader geronimoLoader = utils.createGeronimoURLClassloader(this.getHome());
        Thread.currentThread().setContextClassLoader(geronimoLoader);
        try {
            while (System.currentTimeMillis() < timeout) {
                boolean started = utils.isGeronimoStarted("localhost", String.valueOf(this.rmiPort), USERNAME, PASSWORD);
                if (started) {
                    return;
                }
                ThreadUtil.reallySleep((long)6000L);
            }
            throw new Exception("WASCE server failed to start in 240000 millis");
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    private void deployWars(Map wars) throws Exception {
        Assert.assertNotNull((Object)wars);
        Iterator iter = wars.values().iterator();
        while (iter.hasNext()) {
            LinkedList<String> cl = new LinkedList<String>();
            cl.add(JAVA_CMD);
            cl.add("-jar");
            cl.add(this.installPath + File.separator + DEPLOYER_JAR);
            cl.add("--user");
            cl.add(USERNAME);
            cl.add("--password");
            cl.add(PASSWORD);
            cl.add("--port");
            cl.add(String.valueOf(this.rmiPort));
            cl.add("deploy");
            cl.add(((File)iter.next()).toString());
            this.consoleLogger.info("Deploying War: " + Arrays.asList(cl.toArray(new String[0])), LOG_CAT);
            Process process = Runtime.getRuntime().exec(cl.toArray(new String[0]));
            StreamAppender appender = new StreamAppender((OutputStream)System.err);
            appender.writeInput(process.getErrorStream(), process.getInputStream());
            if (process.waitFor() != 0) {
                throw new Exception("Failed to Deploy WAR: " + this.rmiPort);
            }
            appender.finish();
        }
    }

    @Override
    public synchronized void stop(ServerParameters rawParams) throws Exception {
        Assert.assertTrue((this.rmiPort > 0 ? 1 : 0) != 0);
        StringBuffer cl = new StringBuffer(JAVA_CMD + " -jar ");
        cl.append(this.installPath + File.separator + SHUTDOWN_JAR);
        cl.append(" --user system --password manager --port " + this.rmiPort);
        Process process = Runtime.getRuntime().exec(cl.toString());
        StreamAppender appender = new StreamAppender((OutputStream)System.err);
        appender.writeInput(process.getErrorStream(), process.getInputStream());
        if (process.waitFor() != 0) {
            throw new Exception("Server Shutdown Failed: " + this.rmiPort);
        }
        appender.finish();
        this.consoleLogger.info("Server shutdown: " + this.rmiPort, LOG_CAT);
    }

    private void copyInstanceDirectories(File home, File instance) throws IOException {
        String sep = File.separator;
        FileUtils.copyDirectory((File)new File(home + sep + CONFIG_STORE), (File)new File(instance + sep + CONFIG_STORE), (boolean)false);
        FileUtils.copyDirectory((File)new File(home + sep + REPOSITORY), (File)new File(instance + sep + REPOSITORY), (boolean)false);
        FileUtils.copyDirectory((File)new File(home + sep + VAR), (File)new File(instance + sep + VAR), (boolean)false);
    }

    private void parseConfig(File configDir, int port) throws Exception {
        File tmpConfig = new File(configDir + File.separator + "tmp_config.xml");
        File config = new File(configDir + File.separator + CONFIG);
        BufferedReader reader = new BufferedReader(new FileReader(config));
        PrintWriter writer = new PrintWriter(new FileWriter(tmpConfig));
        String line = null;
        boolean useServerPort = false;
        boolean useRMIPort = false;
        while ((line = reader.readLine()) != null) {
            if (Pattern.matches(RMI_PORT_ATTRIB, line)) {
                this.rmiPort = AppServerUtil.getPort();
                useRMIPort = true;
            }
            if (Pattern.matches(NAME_TEXT, line)) {
                line = "name=Geronimo" + IOUtils.LINE_SEPARATOR + "jvmRoute=" + this.instanceName;
            }
            if (Pattern.matches(WEB_PORT_ATTRIB, line)) {
                useServerPort = true;
            }
            if (Pattern.matches(RMI_PORT_URL, line)) {
                line = line.replaceAll("rmi://0.0.0.0:\\d{4,6}", RMI_PREFIX + this.rmiPort);
            }
            if (Pattern.matches(JMX_RMI, line)) {
                writer.println(line);
                line = reader.readLine();
                String s = "/jndi/rmi://0.0.0.0:";
                line = line.replaceAll("service:jmx:rmi://0.0.0.0:\\d{4,6}" + s + "\\d{4,6}", JMX_RMI_PREFIX + AppServerUtil.getPort() + s + this.rmiPort);
            }
            if (Pattern.matches(PORT_ATTRIB, line)) {
                int newPort;
                int n = newPort = useServerPort ? port : AppServerUtil.getPort();
                if (useRMIPort) {
                    newPort = this.rmiPort;
                    useRMIPort = false;
                }
                if (useServerPort) {
                    useServerPort = false;
                }
                line = line.replaceAll("ort\">\\d{4,6}", PORT_PREFIX + newPort);
            } else if (Pattern.matches(REDIRECT_PORT_ATTRIB, line)) {
                line = line.replaceAll("ort\">\\d{4,6}", PORT_PREFIX + AppServerUtil.getPort());
            }
            writer.println(line);
        }
        reader.close();
        writer.flush();
        writer.close();
        config.delete();
        tmpConfig.renameTo(config);
    }

    private void interpretJarManifest(File jar) throws IOException {
        String absPath = jar.getCanonicalFile().getParentFile().getParent().replace('\\', '/');
        Manifest manifest = new JarFile(jar).getManifest();
        Attributes attrib = manifest.getMainAttributes();
        String classPathAttrib = attrib.getValue("Class-Path");
        this.classpath = jar + File.pathSeparator;
        this.classpath = this.classpath + classPathAttrib.replaceAll("^\\.\\.", absPath).replaceAll("\\s\\.\\.", File.pathSeparatorChar + absPath);
        this.endorsedPath = absPath + File.separator + attrib.getValue("Endorsed-Dirs");
        this.className = attrib.getValue("Main-Class");
    }
}

