/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.tomcat5x;

import com.tc.test.AppServerInfo;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.cargo.CargoAppServer;
import com.tc.test.server.appserver.tomcat.TomcatStartupActions;
import com.tc.test.server.appserver.tomcat5x.Tomcat5xAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.tomcat.Tomcat5xInstalledLocalContainer;

public final class Tomcat5xAppServer
extends CargoAppServer {
    private final AppServerInfo appServerInfo;

    public Tomcat5xAppServer(Tomcat5xAppServerInstallation installation) {
        super(installation);
        this.appServerInfo = installation.appServerInfo();
    }

    @Override
    protected String cargoServerKey() {
        return "tomcat5x";
    }

    @Override
    protected InstalledLocalContainer container(LocalConfiguration config, AppServerParameters params) {
        return new TCTomcat5xInstalledLocalContainer(config, params, this.appServerInfo);
    }

    private static class TCTomcat5xInstalledLocalContainer
    extends Tomcat5xInstalledLocalContainer {
        private final AppServerParameters params;
        private final AppServerInfo appServerInfo;

        public TCTomcat5xInstalledLocalContainer(LocalConfiguration config, AppServerParameters params, AppServerInfo appServerInfo) {
            super(config);
            this.params = params;
            this.appServerInfo = appServerInfo;
            config.setProperty("cargo.rmi.port", Integer.toString(AppServerUtil.getPort()));
        }

        protected void setState(State state) {
            if (state.isStarting()) {
                int line = this.appServerInfo.getMinor().startsWith("0.") ? 45 : 60;
                TomcatStartupActions.modifyConfig(this.params, (InstalledLocalContainer)this, line);
                TomcatStartupActions.configureManagerApp(this.params, (InstalledLocalContainer)this);
            }
            super.setState(state);
        }
    }
}

