/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.tomcat;

import com.tc.test.AppServerInfo;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.ValveDefinition;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.test.server.util.Assert;
import com.tc.util.ReplaceLine;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TomcatStartupActions {
    public static final String USE_NIO_PROTOCOL_KEY = "useNioProtocol";

    private TomcatStartupActions() {
    }

    public static void modifyConfig(AppServerParameters params, InstalledLocalContainer container, int catalinaPropsLine) {
        try {
            TomcatStartupActions.modifyConfig0(params, container, catalinaPropsLine);
            if (Boolean.valueOf(params.properties().getProperty(USE_NIO_PROTOCOL_KEY)).booleanValue()) {
                TomcatStartupActions.switchToNioProtocol(params, container);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void modifyConfig0(AppServerParameters params, InstalledLocalContainer container, int catalinaPropsLine) throws Exception {
        try {
            Collection<ValveDefinition> valves = params.valves();
            File serverXml = new File(container.getConfiguration().getHome(), "conf/server.xml");
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(serverXml);
            Map<String, Deployment> deployments = params.deployments();
            NodeList contexts = doc.getElementsByTagName("Context");
            File webApps = new File(container.getConfiguration().getHome(), "webapps");
            int n = contexts.getLength();
            for (int i = 0; i < n; ++i) {
                Node context = contexts.item(i);
                String contextPath = context.getAttributes().getNamedItem("path").getNodeValue();
                String appContext = contextPath.substring(1);
                Deployment deployment = deployments.get(appContext);
                Assert.assertNotNull(deployment);
                AppServerInfo appServerInfo = TestConfigObject.getInstance().appServerInfo();
                if (Integer.valueOf(appServerInfo.getMajor()) == 7) {
                    String useHttpOnly = deployment.properties().getProperty("useHttpOnly", "false");
                    ((Element)context).setAttribute("useHttpOnly", useHttpOnly);
                    File docBase = new File(context.getAttributes().getNamedItem("docBase").getNodeValue());
                    FileUtils.copyFileToDirectory((File)docBase, (File)webApps);
                    ((Element)context).setAttribute("docBase", docBase.getName());
                }
                for (ValveDefinition def : valves) {
                    if (def.isExpressVal() && !deployment.isClustered()) continue;
                    Element valve = doc.createElement("Valve");
                    for (Map.Entry<String, String> attr : def.getAttributes().entrySet()) {
                        valve.setAttribute(attr.getKey(), attr.getValue());
                    }
                    context.appendChild(valve);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(serverXml));
            Collection<String> tomcatServerJars = params.tomcatServerJars();
            if (!tomcatServerJars.isEmpty()) {
                String jarsCsv = "";
                String[] jars = tomcatServerJars.toArray(new String[0]);
                for (int i = 0; i < jars.length; ++i) {
                    jarsCsv = jarsCsv + "file:" + (Os.isWindows() ? "/" : "") + jars[i].replace('\\', '/');
                    if (i >= jars.length - 1) continue;
                    jarsCsv = jarsCsv + ",";
                }
                File catalinaProps = new File(container.getConfiguration().getHome(), "conf/catalina.properties");
                FileUtils.copyFile((File)new File(container.getHome(), "conf/catalina.properties"), (File)catalinaProps);
                ArrayList<ReplaceLine.Token> tokens = new ArrayList<ReplaceLine.Token>();
                tokens.add(new ReplaceLine.Token(catalinaPropsLine, ".jar$", ".jar," + jarsCsv));
                ReplaceLine.parseFile((ReplaceLine.Token[])tokens.toArray(new ReplaceLine.Token[0]), (File)catalinaProps);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void configureManagerApp(AppServerParameters params, InstalledLocalContainer container) {
        AppServerInfo appServerInfo = TestConfigObject.getInstance().appServerInfo();
        String managerPath = "server/webapps/manager";
        if (Integer.valueOf(appServerInfo.getMajor()) >= 6) {
            managerPath = "webapps/manager";
        }
        File managerApp = new File(container.getHome(), managerPath);
        String managerXml = "<Context path='/manager' debug='0' privileged='true' docBase='" + managerApp.getAbsolutePath() + "'></Context>";
        File managerContextFile = new File(container.getConfiguration().getHome(), "/conf/Catalina/localhost/manager.xml");
        managerContextFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(managerContextFile);
            IOUtils.write((String)managerXml, (OutputStream)out);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static void switchToNioProtocol(AppServerParameters params, InstalledLocalContainer container) throws Exception {
        File serverXml = new File(container.getConfiguration().getHome(), "conf/server.xml");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(serverXml);
        Element connector = (Element)doc.getElementsByTagName("Connector").item(0);
        connector.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(serverXml));
    }
}

