/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.resin31x;

import com.tc.process.Exec;
import com.tc.test.TestConfigObject;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.resin31x.Resin31xAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import com.tc.test.server.util.ParamsWithRetry;
import com.tc.test.server.util.RetryException;
import com.tc.text.Banner;
import com.tc.util.Grep;
import com.tc.util.PortChooser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Replace;

public final class Resin31xAppServer
extends AbstractAppServer {
    private static final String JAVA_CMD = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private static final long START_STOP_TIMEOUT = 240000L;
    public static final int STARTUP_RETRIES = 3;
    private String configFile;
    private String instanceName;
    private File instanceDir;
    private int resin_port = 0;
    private int watchdog_port = 0;
    private int cluster_port = 0;
    private Thread runner = null;
    private Process process;

    public Resin31xAppServer(Resin31xAppServerInstallation installation) {
        super(installation);
    }

    @Override
    public ServerResult start(ServerParameters parameters) throws Exception {
        AppServerParameters params = (AppServerParameters)parameters;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.startResin(new ParamsWithRetry(params, i));
            }
            catch (RetryException re) {
                Banner.warnBanner((String)("Re-trying server startup (" + i + ") " + re.getMessage()));
                if (this.process == null) continue;
                try {
                    this.process.destroy();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
        }
        throw new RuntimeException("Failed to start server in 3 attempts");
    }

    @Override
    public void stop(ServerParameters rawParams) throws Exception {
        String[] cmd = new String[]{JAVA_CMD, "-jar", this.serverInstallDirectory() + File.separator + "lib" + File.separator + "resin.jar", "stop", "-conf", this.configFile};
        System.err.println("Stopping instance " + this.instanceName + "...");
        Exec.Result result = Exec.execute((String[])cmd, null, null, (File)this.serverInstallDirectory());
        if (result.getExitCode() != 0) {
            System.err.println(result);
        }
        if (this.runner != null) {
            this.runner.join(240000L);
            if (this.runner.isAlive()) {
                System.err.println("Instance " + this.instanceName + " on port " + this.resin_port + " still alive.");
            } else {
                System.err.println("Resin instance " + this.instanceName + " stopped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerResult startResin(AppServerParameters params) throws Exception {
        this.prepareDeployment(params);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(0, JAVA_CMD);
        cmd.add("-cp");
        cmd.add(TestConfigObject.getInstance().extraClassPathForAppServer());
        cmd.add("-jar");
        cmd.add(this.serverInstallDirectory() + File.separator + "lib" + File.separator + "resin.jar");
        cmd.add("start");
        cmd.add("-conf");
        cmd.add(this.configFile);
        cmd.add("-resin-home");
        cmd.add(this.serverInstallDirectory().getAbsolutePath());
        cmd.add("-root-directory");
        cmd.add(this.instanceDir.getAbsolutePath());
        cmd.add("-verbose");
        final String[] cmdArray = cmd.toArray(new String[0]);
        File watchdogLog = new File(this.instanceDir, "log" + File.separator + "watchdog-manager.log");
        final String nodeLogFile = new File(this.instanceDir + ".log").getAbsolutePath();
        System.err.println("Starting resin with cmd: " + cmd);
        this.process = Runtime.getRuntime().exec(cmdArray, null, this.instanceDir);
        this.runner = new Thread("runner for " + this.instanceName){

            @Override
            public void run() {
                try {
                    Exec.Result result = Exec.execute((Process)Resin31xAppServer.this.process, (String[])cmdArray, (String)nodeLogFile, null, (File)Resin31xAppServer.this.instanceDir);
                    if (result.getExitCode() != 0) {
                        System.err.println("Command failed: " + result);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.runner.start();
        System.err.println("Starting resin " + this.instanceName + " on port " + this.resin_port + "...");
        boolean started = false;
        long timeout = System.currentTimeMillis() + 240000L;
        try {
            while (System.currentTimeMillis() < timeout) {
                if (AppServerUtil.pingPort(this.watchdog_port)) {
                    started = true;
                    break;
                }
                if (!watchdogLog.exists() || !Resin31xAppServer.configExceptionCheck(watchdogLog)) continue;
                throw new RetryException("thread-idle-max config exception");
            }
            if (!started) {
                if (!watchdogLog.exists()) {
                    throw new RetryException("watchdog log doesn't exist");
                }
                if (Resin31xAppServer.configExceptionCheck(watchdogLog)) {
                    throw new RetryException("thread-idle-max config exception");
                }
                throw new RuntimeException("Failed to start server in 240000ms");
            }
        }
        finally {
            if (!started) {
                this.process.destroy();
                this.runner.join(5000L);
            }
        }
        AppServerUtil.waitForPort(this.resin_port, 240000L);
        System.err.println("Started " + this.instanceName + " on port " + this.resin_port);
        return new AppServerResult(this.resin_port, this);
    }

    protected static boolean configExceptionCheck(File watchdogLog) throws IOException {
        List hit1 = Grep.grep((String)"at com.caucho.util.ThreadPool.setThreadIdleMin", (File)watchdogLog);
        List hit2 = Grep.grep((String)"at com.caucho.util.ThreadPool.setThreadIdleMax", (File)watchdogLog);
        return !hit1.isEmpty() || !hit2.isEmpty();
    }

    private void prepareDeployment(AppServerParameters params) throws Exception {
        this.instanceName = params.instanceName();
        this.instanceDir = new File(this.sandboxDirectory(), this.instanceName);
        Resin31xAppServer.ensureDirectory(this.instanceDir);
        Resin31xAppServer.ensureDirectory(this.getConfDirectory());
        File webapps_dir = this.getWebappsDirectory();
        File deploy_dir = this.getDeployDirectory();
        Resin31xAppServer.ensureDirectory(webapps_dir);
        Map<String, File> deployables = params.deployables();
        if (deployables != null && deployables.size() > 0) {
            Set<Map.Entry<String, File>> entries = deployables.entrySet();
            for (Map.Entry<String, File> war_entry : entries) {
                File deployableFile = war_entry.getValue();
                if (deployableFile.getName().endsWith("war")) {
                    FileUtils.copyFileToDirectory((File)deployableFile, (File)webapps_dir);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)deployableFile, (File)deploy_dir);
            }
        }
        PortChooser portChooser = new PortChooser();
        this.resin_port = portChooser.chooseRandomPort();
        this.watchdog_port = portChooser.chooseRandomPort();
        this.cluster_port = portChooser.chooseRandomPort();
        this.setProperties(params, this.resin_port, this.instanceDir);
        this.createConfigFile(params.jvmArgs().replaceAll("'", "").split("\\s+"));
    }

    private static void ensureDirectory(File dir) throws Exception {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception("Can't create directory (" + dir.getAbsolutePath());
        }
    }

    private File getWebappsDirectory() {
        return new File(this.instanceDir, "webapps");
    }

    private File getDeployDirectory() {
        return new File(this.instanceDir, "deploy");
    }

    private File getConfDirectory() {
        return new File(this.instanceDir, "conf");
    }

    private void createConfigFile(String[] jvmargs) throws IOException {
        File confFile = new File(this.getConfDirectory(), "resin.conf");
        this.configFile = confFile.getAbsolutePath();
        this.copyResource("resin.conf", confFile);
        this.replaceToken("@resin.servlet.port@", String.valueOf(this.resin_port), confFile);
        this.replaceToken("@resin.watchdog.port@", String.valueOf(this.watchdog_port), confFile);
        this.replaceToken("@resin.cluster.port@", String.valueOf(this.cluster_port), confFile);
        StringBuilder resinExtraJvmArgs = new StringBuilder();
        for (String ja : jvmargs) {
            resinExtraJvmArgs.append("<jvm-arg>").append(ja).append("</jvm-arg>").append("\n");
        }
        this.replaceToken("@resin.extra.jvmargs@", resinExtraJvmArgs.toString(), confFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String name, File dest) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(name);
        FileOutputStream out = new FileOutputStream(dest);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private void replaceToken(String token, String value, File file) {
        Replace replaceTask = new Replace();
        replaceTask.setProject(new Project());
        replaceTask.setFile(file);
        replaceTask.setToken(token);
        replaceTask.setValue(value);
        replaceTask.execute();
    }
}

