/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.load;

import com.tc.statistics.retrieval.SigarUtil;
import com.tc.test.AppServerInfo;
import com.tc.text.Banner;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class LowMemWorkaround {
    private static final long TWO_GIGABYTES = 2000000000L;

    public static int computeNumberOfNodes(int defaultNum, int lowMemNum, AppServerInfo appServerInfo) {
        long memTotal = LowMemWorkaround.getMem();
        if (memTotal < 2000000000L || appServerInfo.getId() == 1) {
            Banner.warnBanner((String)("Using " + lowMemNum + " nodes (instead of " + defaultNum + ") since this machine has limited memory (" + memTotal + ") or this is a JBoss test"));
            return lowMemNum;
        }
        return defaultNum;
    }

    public static boolean lessThan2Gb() {
        return LowMemWorkaround.getMem() < 2000000000L;
    }

    private static long getMem() {
        try {
            SigarUtil.sigarInit();
            Sigar sigar = new Sigar();
            Mem mem = sigar.getMem();
            return mem.getTotal();
        }
        catch (SigarException se) {
            throw new RuntimeException(se);
        }
    }
}

