/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.load;

import com.tc.test.server.appserver.load.Request;
import com.tc.util.Assert;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;

public class DataKeeperRequest
implements Request {
    private static final int UNDEFINED = -1;
    private long enterQueueTime;
    private long exitQueueTime;
    private long processCompletionTime;
    private final HttpClient client;
    private final int appserverID;
    private final URL url;

    public DataKeeperRequest(HttpClient client, int appserverID, URL url) {
        this.client = client;
        this.appserverID = appserverID;
        this.url = url;
        this.enterQueueTime = -1L;
        this.exitQueueTime = -1L;
        this.processCompletionTime = -1L;
    }

    @Override
    public void setEnterQueueTime() {
        Assert.assertEquals((long)-1L, (long)this.enterQueueTime);
        this.enterQueueTime = System.currentTimeMillis();
    }

    @Override
    public void setExitQueueTime() {
        Assert.assertEquals((long)-1L, (long)this.exitQueueTime);
        this.exitQueueTime = System.currentTimeMillis();
    }

    @Override
    public void setProcessCompletionTime() {
        Assert.assertEquals((long)-1L, (long)this.processCompletionTime);
        this.processCompletionTime = System.currentTimeMillis();
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long getEnterQueueTime() {
        return this.enterQueueTime;
    }

    @Override
    public long getExitQueueTime() {
        return this.exitQueueTime;
    }

    @Override
    public long getProcessCompletionTime() {
        return this.processCompletionTime;
    }

    @Override
    public HttpClient getClient() {
        return this.client;
    }

    @Override
    public int getAppserverID() {
        return this.appserverID;
    }

    public String toString() {
        return "client=" + this.client + " AppserverID=" + this.appserverID;
    }

    @Override
    public String printData() {
        return this.enterQueueTime + "," + this.exitQueueTime + "," + this.processCompletionTime + this.appserverID + "," + this.client + "," + this.client.getState().getCookies()[0].toString();
    }
}

