/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.jetty7x;

import com.tc.lcp.CargoLinkedChildProcess;
import com.tc.lcp.HeartBeatService;
import com.tc.process.Exec;
import com.tc.test.TestConfigObject;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.deployment.GenericServer;
import com.tc.test.server.appserver.jetty7x.Jetty7xAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import com.tc.util.PortChooser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class Jetty7xAppServer
extends AbstractAppServer {
    private static final boolean NEW_INTEGRATION = false;
    private static final String JAVA_CMD = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private static final String STOP_KEY = "secret";
    private static final String JETTY_MAIN_CLASS = "org.eclipse.jetty.start.Main";
    private static final long START_STOP_TIMEOUT = 240000L;
    private String jettyConfigFile;
    private String instanceName;
    private File instanceDir;
    private File workDir;
    private int jetty_port = 0;
    private int stop_port = 0;
    private Thread runner = null;

    public Jetty7xAppServer(Jetty7xAppServerInstallation installation) {
        super(installation);
    }

    @Override
    public ServerResult start(ServerParameters parameters) throws Exception {
        AppServerParameters params = (AppServerParameters)parameters;
        return this.startJetty(params);
    }

    @Override
    public void stop(ServerParameters rawParams) throws Exception {
        String[] cmd = new String[]{JAVA_CMD, "-DSTOP.PORT=" + this.stop_port, "-DSTOP.KEY=secret", "-jar", "start.jar", "--stop"};
        System.err.println("Stopping instance " + this.instanceName + "...");
        Exec.Result result = Exec.execute((String[])cmd, null, null, (File)this.serverInstallDirectory());
        if (result.getExitCode() != 0) {
            System.err.println(result);
        }
        if (this.runner != null) {
            this.runner.join(240000L);
            if (this.runner.isAlive()) {
                System.err.println("Instance " + this.instanceName + " on port " + this.jetty_port + " still alive.");
            } else {
                System.err.println("jetty instance " + this.instanceName + " stopped");
            }
        }
    }

    private AppServerResult startJetty(AppServerParameters params) throws Exception {
        this.prepareDeployment(params);
        Object tcModuleJar = null;
        String[] jvmargs = params.jvmArgs().replaceAll("'", "").split("\\s+");
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(jvmargs));
        cmd.add(0, JAVA_CMD);
        cmd.add("-cp");
        cmd.add(this.serverInstallDirectory() + File.separator + "start.jar" + File.pathSeparator + TestConfigObject.getInstance().extraClassPathForAppServer());
        cmd.add("-Djetty.home=" + this.serverInstallDirectory());
        cmd.add("-Djetty.port=" + this.jetty_port);
        cmd.add("-Djava.io.tmpdir=" + this.workDir.getAbsolutePath());
        cmd.add(CargoLinkedChildProcess.class.getName());
        cmd.add(JETTY_MAIN_CLASS);
        cmd.add(String.valueOf(HeartBeatService.listenPort()));
        cmd.add(this.instanceDir.getAbsolutePath());
        if (GenericServer.dsoEnabled()) {
            // empty if block
        }
        cmd.add("STOP.PORT=" + this.stop_port);
        cmd.add("STOP.KEY=secret");
        cmd.add("OPTIONS=All");
        cmd.add(this.jettyConfigFile);
        final String[] cmdArray = cmd.toArray(new String[0]);
        final String nodeLogFile = new File(this.instanceDir + ".log").getAbsolutePath();
        this.runner = new Thread("runner for " + this.instanceName){

            @Override
            public void run() {
                try {
                    Exec.Result result = Exec.execute((String[])cmdArray, (String)nodeLogFile, null, (File)Jetty7xAppServer.this.instanceDir);
                    if (result.getExitCode() != 0) {
                        System.err.println(result);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.runner.start();
        System.err.println("Starting jetty " + this.instanceName + " on port " + this.jetty_port + "...");
        System.err.println("Cmd: " + Arrays.asList(cmdArray));
        AppServerUtil.waitForPort(this.jetty_port, 240000L);
        System.err.println("Started " + this.instanceName + " on port " + this.jetty_port);
        return new AppServerResult(this.jetty_port, this);
    }

    private void prepareDeployment(AppServerParameters params) throws Exception {
        this.instanceName = params.instanceName();
        this.instanceDir = new File(this.sandboxDirectory(), this.instanceName);
        Jetty7xAppServer.ensureDirectory(this.instanceDir);
        Jetty7xAppServer.ensureDirectory(this.getContextsDirectory());
        File wars_dir = this.getWarsDirectory();
        Jetty7xAppServer.ensureDirectory(wars_dir);
        Map<String, File> wars = params.deployables();
        if (wars != null && wars.size() > 0) {
            Set<Map.Entry<String, File>> war_entries = wars.entrySet();
            for (Map.Entry<String, File> war_entry : war_entries) {
                File war_file = war_entry.getValue();
                String context = war_entry.getKey();
                this.writeContextFile(war_file, context);
            }
        }
        PortChooser portChooser = new PortChooser();
        this.jetty_port = portChooser.chooseRandomPort();
        this.stop_port = portChooser.chooseRandomPort();
        this.workDir = new File(this.sandboxDirectory(), "work");
        this.workDir.mkdirs();
        File logsDir = new File(this.instanceDir, "logs");
        Jetty7xAppServer.ensureDirectory(logsDir);
        this.setProperties(params, this.jetty_port, this.instanceDir);
        this.createConfigFile();
        if (!new File(this.jettyConfigFile).exists()) {
            throw new Exception("Jetty config file wasn't created properly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContextFile(File war, String context) throws IOException {
        String warShortName = war.getName().toLowerCase().replace(".war", "");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.getContextsDirectory(), warShortName + ".xml"));
            fos.write(Jetty7xAppServer.contextFile(war.getAbsolutePath(), context).getBytes());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static void ensureDirectory(File dir) throws Exception {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception("Can't create directory (" + dir.getAbsolutePath());
        }
    }

    private File getWarsDirectory() {
        return new File(this.instanceDir, "war");
    }

    private File getContextsDirectory() {
        return new File(this.instanceDir, "contexts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConfigFile() throws Exception {
        PrintWriter out = null;
        try {
            String jettyXmlContent = this.getJettyXml();
            jettyXmlContent = jettyXmlContent.replace("TC_CONTEXT_DIR", this.getContextsDirectory().getAbsolutePath());
            jettyXmlContent = jettyXmlContent.replace("TC_WORKER_NAME", this.instanceName);
            this.jettyConfigFile = new File(this.instanceDir, "jetty.xml").getAbsolutePath();
            System.out.println("XXX: jetty config file: " + this.jettyConfigFile);
            out = new PrintWriter(new FileWriter(this.jettyConfigFile));
            out.println(jettyXmlContent);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    private static String contextFile(String warFile, String contextPath) {
        String s = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n";
        s = s + "<Configure class=\"org.eclipse.jetty.webapp.WebAppContext\">\n";
        s = s + "  <Set name=\"contextPath\">/" + contextPath + "</Set>\n";
        s = s + "  <Set name=\"war\">" + warFile + "</Set>\n";
        s = s + "\n";
        s = s + "</Configure>\n";
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJettyXml() throws IOException {
        InputStream in = null;
        try {
            in = Jetty7xAppServer.class.getResourceAsStream("jetty.xml");
            List lines = IOUtils.readLines((InputStream)in);
            StringBuilder content = new StringBuilder();
            for (String line : lines) {
                content.append(line).append("\n");
            }
            String string = content.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

