/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.jetty6x;

import com.tc.lcp.CargoLinkedChildProcess;
import com.tc.lcp.HeartBeatService;
import com.tc.process.Exec;
import com.tc.test.TestConfigObject;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.deployment.GenericServer;
import com.tc.test.server.appserver.jetty6x.Jetty6xAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import com.tc.util.PortChooser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class Jetty6xAppServer
extends AbstractAppServer {
    private static final boolean NEW_INTEGRATION = false;
    private static final String JAVA_CMD = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private static final String STOP_KEY = "secret";
    private static final String JETTY_MAIN_CLASS = "org.mortbay.start.Main";
    private static final long START_STOP_TIMEOUT = 240000L;
    private static final String webAppTarget = "<SystemProperty name=\"jetty.home\" default=\".\"/>/webapps";
    private static final String contextsTarget = "<SystemProperty name=\"jetty.home\" default=\".\"/>/contexts";
    private static final String eofTarget = "</Configure>";
    private String configFile;
    private String instanceName;
    private File instanceDir;
    private File workDir;
    private int jetty_port = 0;
    private int stop_port = 0;
    private Thread runner = null;

    public Jetty6xAppServer(Jetty6xAppServerInstallation installation) {
        super(installation);
    }

    @Override
    public ServerResult start(ServerParameters parameters) throws Exception {
        AppServerParameters params = (AppServerParameters)parameters;
        return this.startJetty(params);
    }

    @Override
    public void stop(ServerParameters rawParams) throws Exception {
        String[] cmd = new String[]{JAVA_CMD, "-DSTOP.PORT=" + this.stop_port, "-DSTOP.KEY=secret", "-jar", "start.jar", "--stop"};
        System.err.println("Stopping instance " + this.instanceName + "...");
        Exec.Result result = Exec.execute((String[])cmd, null, null, (File)this.serverInstallDirectory());
        if (result.getExitCode() != 0) {
            System.err.println(result);
        }
        if (this.runner != null) {
            this.runner.join(240000L);
            if (this.runner.isAlive()) {
                System.err.println("Instance " + this.instanceName + " on port " + this.jetty_port + " still alive.");
            } else {
                System.err.println("jetty instance " + this.instanceName + " stopped");
            }
        }
    }

    private AppServerResult startJetty(AppServerParameters params) throws Exception {
        this.prepareDeployment(params);
        Object tcModuleJar = null;
        String[] jvmargs = params.jvmArgs().replaceAll("'", "").split("\\s+");
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(jvmargs));
        cmd.add(0, JAVA_CMD);
        cmd.add("-cp");
        cmd.add(this.serverInstallDirectory() + File.separator + "start.jar" + File.pathSeparator + TestConfigObject.getInstance().extraClassPathForAppServer());
        if (GenericServer.dsoEnabled()) {
            // empty if block
        }
        cmd.add("-Djetty.home=" + this.serverInstallDirectory());
        cmd.add("-Djetty.port=" + this.jetty_port);
        cmd.add("-DSTOP.PORT=" + this.stop_port);
        cmd.add("-DSTOP.KEY=secret");
        cmd.add("-Djava.io.tmpdir=" + this.workDir.getAbsolutePath());
        cmd.add(CargoLinkedChildProcess.class.getName());
        cmd.add(JETTY_MAIN_CLASS);
        cmd.add(String.valueOf(HeartBeatService.listenPort()));
        cmd.add(this.instanceDir.getAbsolutePath());
        cmd.add(this.configFile);
        final String[] cmdArray = cmd.toArray(new String[0]);
        final String nodeLogFile = new File(this.instanceDir + ".log").getAbsolutePath();
        this.runner = new Thread("runner for " + this.instanceName){

            @Override
            public void run() {
                try {
                    Exec.Result result = Exec.execute((String[])cmdArray, (String)nodeLogFile, null, (File)Jetty6xAppServer.this.instanceDir);
                    if (result.getExitCode() != 0) {
                        System.err.println(result);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.runner.start();
        System.err.println("Starting jetty " + this.instanceName + " on port " + this.jetty_port + "...");
        AppServerUtil.waitForPort(this.jetty_port, 240000L);
        System.err.println("Started " + this.instanceName + " on port " + this.jetty_port);
        return new AppServerResult(this.jetty_port, this);
    }

    private void prepareDeployment(AppServerParameters params) throws Exception {
        this.instanceName = params.instanceName();
        this.instanceDir = new File(this.sandboxDirectory(), this.instanceName);
        Jetty6xAppServer.ensureDirectory(this.instanceDir);
        Jetty6xAppServer.ensureDirectory(this.getContextsDirectory());
        File wars_dir = this.getWarsDirectory();
        Jetty6xAppServer.ensureDirectory(wars_dir);
        Map<String, File> wars = params.deployables();
        if (wars != null && wars.size() > 0) {
            Set<Map.Entry<String, File>> war_entries = wars.entrySet();
            for (Map.Entry<String, File> war_entry : war_entries) {
                File war_file = war_entry.getValue();
                String context = war_entry.getKey();
                this.writeContextFile(war_file, context);
            }
        }
        PortChooser portChooser = new PortChooser();
        this.jetty_port = portChooser.chooseRandomPort();
        this.stop_port = portChooser.chooseRandomPort();
        this.workDir = new File(this.sandboxDirectory(), "work");
        this.workDir.mkdirs();
        File logsDir = new File(this.instanceDir, "logs");
        Jetty6xAppServer.ensureDirectory(logsDir);
        this.setProperties(params, this.jetty_port, this.instanceDir);
        this.createConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContextFile(File war, String context) throws IOException {
        String warShortName = war.getName().toLowerCase().replace(".war", "");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.getContextsDirectory(), warShortName + ".xml"));
            fos.write(Jetty6xAppServer.contextFile(war.getAbsolutePath(), context).getBytes());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static void ensureDirectory(File dir) throws Exception {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception("Can't create directory (" + dir.getAbsolutePath());
        }
    }

    private File getWarsDirectory() {
        return new File(this.instanceDir, "war");
    }

    private File getContextsDirectory() {
        return new File(this.instanceDir, "contexts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConfigFile() throws Exception {
        String origialConfig = this.serverInstallDirectory().getAbsolutePath() + File.separator + "etc" + File.separator + "jetty.xml";
        if (!new File(origialConfig).exists()) {
            throw new Exception(origialConfig + " doesn't exist.");
        }
        StringBuffer buffer = new StringBuffer(1024);
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(origialConfig));
            while ((line = in.readLine()) != null) {
                buffer.append(line).append("\n");
            }
            int startIndex = buffer.indexOf(webAppTarget);
            if (startIndex <= 0) {
                throw new RuntimeException("Can't find target: <SystemProperty name=\"jetty.home\" default=\".\"/>/webapps");
            }
            int endIndex = startIndex + webAppTarget.length();
            buffer.replace(startIndex, endIndex, this.getWarsDirectory().getAbsolutePath());
            startIndex = buffer.indexOf(eofTarget);
            if (startIndex <= 0) {
                throw new RuntimeException("Can't find target: </Configure>");
            }
            buffer.insert(startIndex, this.jettyXmlAddition(this.instanceName));
            startIndex = buffer.indexOf(contextsTarget);
            if (startIndex <= 0) {
                throw new RuntimeException("Can't find target: <SystemProperty name=\"jetty.home\" default=\".\"/>/contexts");
            }
            endIndex = startIndex + contextsTarget.length();
            buffer.replace(startIndex, endIndex, this.getContextsDirectory().getAbsolutePath());
            this.configFile = new File(this.instanceDir, "jetty.xml").getAbsolutePath();
            out = new PrintWriter(new FileWriter(this.configFile));
            out.println(buffer.toString());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }

    private String jettyXmlAddition(String workerName) {
        if (GenericServer.dsoEnabled()) {
            // empty if block
        }
        String s = "";
        s = s + "  <Set name=\"sessionIdManager\">\n";
        s = s + "    <New id=\"idMgr\" class=\"org.mortbay.jetty.servlet.HashSessionIdManager\">\n";
        s = s + "      <Set name=\"workerName\">" + workerName + "</Set>\n";
        s = s + "    </New>\n";
        s = s + "  </Set>\n";
        s = s + "  \n";
        return s;
    }

    private static String contextFile(String warFile, String contextPath) {
        String s = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n";
        s = s + "<Configure class=\"org.mortbay.jetty.webapp.WebAppContext\">\n";
        s = s + "  <Set name=\"contextPath\">/" + contextPath + "</Set>\n";
        s = s + "  <Set name=\"war\">" + warFile + "</Set>\n";
        s = s + "\n";
        if (GenericServer.dsoEnabled()) {
            // empty if block
        }
        s = s + "</Configure>\n";
        return s;
    }
}

