/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.jboss7x;

import com.tc.process.Exec;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.jboss7x.JBoss7xAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import com.tc.text.Banner;
import com.tc.util.PortChooser;
import com.tc.util.ReplaceLine;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public final class JBoss7xAppServer
extends AbstractAppServer {
    private static final long START_STOP_TIMEOUT = 240000L;
    private static final String JAVA_CMD = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private final File serverInstallDir;
    private String instanceName;
    private File instanceDir;
    private Thread runner = null;
    private final HashMap<String, PortLine> portMap = new HashMap();
    private int start_port = 0;
    private int admin_port = 0;

    public JBoss7xAppServer(JBoss7xAppServerInstallation installation) {
        super(installation);
        this.serverInstallDir = this.serverInstallDirectory();
    }

    @Override
    public ServerResult start(ServerParameters parameters) throws Exception {
        StandardAppServerParameters params = (StandardAppServerParameters)parameters;
        this.instanceName = params.instanceName();
        this.instanceDir = this.createInstance(params);
        this.createInstanceDir();
        this.setJVMRoute();
        this.configurePorts();
        this.start_port = this.portMap.get("http").getPortNumber();
        this.admin_port = this.portMap.get("management-native").getPortNumber();
        this.disableJAXRS();
        this.deployWars(params.deployables());
        System.err.println("Starting jboss7 " + this.instanceName + " on port " + this.start_port + "...");
        File logDir = new File(this.instanceDir, "log");
        String[] jvmargs = params.jvmArgs().replaceAll("'", "").split("\\s+");
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(jvmargs));
        cmd.add(0, JAVA_CMD);
        cmd.add("-Dorg.jboss.boot.log.file=" + new File(logDir, "boot.log").getAbsolutePath());
        cmd.add("-Dlogging.configuration=file:" + new File(this.instanceDir, "configuration/logging.properties").getAbsolutePath());
        cmd.add("-jar");
        cmd.add(new File(this.serverInstallDir, "jboss-modules.jar").getAbsolutePath());
        cmd.add("-mp");
        cmd.add(new File(this.serverInstallDir, "modules").getAbsolutePath());
        cmd.add("-jaxpmodule");
        cmd.add("javax.xml.jaxp-provider");
        cmd.add("org.jboss.as.standalone");
        cmd.add("-Djboss.home.dir=" + this.serverInstallDir.getAbsolutePath());
        cmd.add("-Djboss.server.base.dir=" + this.instanceDir.getAbsolutePath());
        System.err.println("Start cmd: " + cmd);
        final String[] cmdArray = cmd.toArray(new String[0]);
        final String nodeLogFile = new File(this.instanceDir + ".log").getAbsolutePath();
        this.runner = new Thread("runner for " + this.instanceName){

            @Override
            public void run() {
                try {
                    Exec.Result result = Exec.execute((String[])cmdArray, (String)nodeLogFile, null, (File)JBoss7xAppServer.this.instanceDir);
                    if (result.getExitCode() != 0) {
                        System.err.println(result);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.runner.start();
        AppServerUtil.waitForPort(this.start_port, 240000L);
        this.waitUntilWarsDeployed(240000L);
        System.err.println("Started " + this.instanceName + " on port " + this.start_port);
        return new AppServerResult(this.start_port, this);
    }

    @Override
    public void stop(ServerParameters parameters) throws Exception {
        File stopScript = new File(new File(this.serverInstallDirectory(), "bin"), JBoss7xAppServer.getPlatformScript("jboss-cli"));
        String[] cmd = new String[]{stopScript.getAbsolutePath(), "--connect", "--controller=localhost:" + this.admin_port, ":shutdown"};
        File stopResult = new File(this.instanceDir, "stop.log");
        System.err.println("Stop cmd: " + Arrays.asList(cmd));
        Exec.Result result = Exec.execute((String[])cmd, (String)stopResult.getAbsolutePath(), null, (File)stopScript.getParentFile());
        if (result.getExitCode() != 0) {
            System.err.println(result);
        }
        if (this.runner != null) {
            this.runner.join(240000L);
            if (this.runner.isAlive()) {
                Banner.errorBanner((String)("instance still running on port " + this.start_port));
            } else {
                System.err.println("Stopped instance on port " + this.start_port);
            }
        }
    }

    private void setJVMRoute() throws IOException {
        ArrayList<ReplaceLine.Token> tokens = new ArrayList<ReplaceLine.Token>();
        tokens.add(new ReplaceLine.Token(256, "(>)", " instance-id=\"" + this.instanceName + "\">"));
        File dest = new File(this.instanceDir, "configuration/standalone.xml");
        ReplaceLine.parseFile((ReplaceLine.Token[])tokens.toArray(new ReplaceLine.Token[0]), (File)dest);
    }

    public void disableJAXRS() throws IOException {
        ArrayList<ReplaceLine.Token> tokens = new ArrayList<ReplaceLine.Token>();
        tokens.add(new ReplaceLine.Token(163, ".*jaxrs.*", ""));
        File dest = new File(this.instanceDir, "configuration/standalone.xml");
        ReplaceLine.parseFile((ReplaceLine.Token[])tokens.toArray(new ReplaceLine.Token[0]), (File)dest);
    }

    private void configurePorts() throws FileNotFoundException, IOException {
        PortChooser portChooser = new PortChooser();
        ArrayList<ReplaceLine.Token> tokens = new ArrayList<ReplaceLine.Token>();
        PortLine p0 = new PortLine("management-native", 292, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p0.getLineNumber(), "(port:[0-9]+)", "port:" + p0.getPortNumber()));
        this.portMap.put("management-native", p0);
        PortLine p1 = new PortLine("management-http", 293, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p1.getLineNumber(), "(port:[0-9]+)", "port:" + p1.getPortNumber()));
        this.portMap.put("management-http", p1);
        PortLine p2 = new PortLine("management-https", 294, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p2.getLineNumber(), "(port:[0-9]+)", "port:" + p2.getPortNumber()));
        this.portMap.put("management-https", p2);
        PortLine p3 = new PortLine("ajp", 295, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p3.getLineNumber(), "(port=\"[0-9]+)", "port=\"" + p3.getPortNumber()));
        this.portMap.put("ajp", p3);
        PortLine p4 = new PortLine("http", 296, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p4.getLineNumber(), "(port=\"[0-9]+)", "port=\"" + p4.getPortNumber()));
        this.portMap.put("http", p4);
        PortLine p5 = new PortLine("https", 297, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p5.getLineNumber(), "(port=\"[0-9]+)", "port=\"" + p5.getPortNumber()));
        this.portMap.put("https", p5);
        PortLine p6 = new PortLine("osgi-http", 298, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p6.getLineNumber(), "(port=\"[0-9]+)", "port=\"" + p6.getPortNumber()));
        this.portMap.put("osgi-http", p6);
        PortLine p7 = new PortLine("remoting", 299, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p7.getLineNumber(), "(port=\"[0-9]+)", "port=\"" + p7.getPortNumber()));
        this.portMap.put("remoting", p7);
        PortLine p8 = new PortLine("txn-recovery-environment", 300, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p8.getLineNumber(), "(port=\"[0-9]+)", "port=\"" + p8.getPortNumber()));
        this.portMap.put("txn-recovery-environment", p8);
        PortLine p9 = new PortLine("txn-status-manager", 301, portChooser.chooseRandomPort());
        tokens.add(new ReplaceLine.Token(p9.getLineNumber(), "(port=\"[0-9]+)", "port=\"" + p9.getPortNumber()));
        this.portMap.put("txn-status-manager", p9);
        tokens.add(new ReplaceLine.Token(109, "deployment-scanner", "deployment-scanner deployment-timeout=\"120\""));
        File dest = new File(this.instanceDir, "configuration/standalone.xml");
        ReplaceLine.parseFile((ReplaceLine.Token[])tokens.toArray(new ReplaceLine.Token[0]), (File)dest);
    }

    private void createInstanceDir() throws IOException {
        File defaultDir = new File(this.serverInstallDir, "standalone");
        FileUtils.copyDirectory((File)defaultDir, (File)this.instanceDir);
        System.err.println("Created instance dir: " + this.instanceDir.getAbsolutePath());
    }

    private void deployWars(Map wars) throws IOException {
        if (wars != null && wars.size() > 0) {
            Set war_entries = wars.entrySet();
            for (Map.Entry war_entry : war_entries) {
                File war_file = (File)war_entry.getValue();
                FileUtils.copyFileToDirectory((File)war_file, (File)new File(this.instanceDir, "deployments"));
            }
        }
    }

    private void waitUntilWarsDeployed(long waitTime) throws Exception {
        long timeToQuit = System.currentTimeMillis() + waitTime;
        File deploymentsFolder = new File(this.instanceDir, "deployments");
        while (System.currentTimeMillis() < timeToQuit) {
            File[] isdeployingFiles = deploymentsFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".isdeploying");
                }
            });
            File[] deployedFiles = deploymentsFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".deployed");
                }
            });
            File[] failedDeployFiles = deploymentsFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".failed");
                }
            });
            if (isdeployingFiles == null) {
                throw new Exception("Deployment folder " + deploymentsFolder + " isn't a directory");
            }
            if (isdeployingFiles.length == 0) {
                if (deployedFiles.length > 0) {
                    System.out.println("Successfully deployed " + deployedFiles.length + " files");
                    return;
                }
                if (failedDeployFiles.length > 0) {
                    System.err.println("At least one file failed to deploy, test will proceed but expect problems");
                    return;
                }
            }
            Thread.sleep(1000L);
        }
    }

    protected static String getPlatformScript(String name) {
        if (Os.isWindows()) {
            return name + ".bat";
        }
        return name + ".sh";
    }

    private static class PortLine {
        private final int lineNumber;
        private final int portNumber;
        private final String portID;

        public PortLine(String portID, int lineNumber, int portNumber) {
            this.portID = portID;
            this.lineNumber = lineNumber;
            this.portNumber = portNumber;
        }

        public String getPortID() {
            return this.portID;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getPortNumber() {
            return this.portNumber;
        }
    }
}

