/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.jboss3x;

import com.tc.test.AppServerInfo;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.cargo.CargoAppServer;
import com.tc.test.server.appserver.jboss3x.JBoss3xAppServerInstallation;
import com.tc.test.server.appserver.jboss_common.JBossHelper;
import com.tc.test.server.util.AppServerUtil;
import java.io.File;
import java.util.Collection;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jboss.JBoss3xInstalledLocalContainer;

public final class JBoss3xAppServer
extends CargoAppServer {
    public JBoss3xAppServer(JBoss3xAppServerInstallation installation) {
        super(installation);
    }

    @Override
    protected String cargoServerKey() {
        return "jboss3x";
    }

    @Override
    protected InstalledLocalContainer container(LocalConfiguration config, AppServerParameters params) {
        return new TCJBoss3xInstalledLocalContainer(config, params.sars(), this.appServerInfo(), params.tomcatServerJars());
    }

    @Override
    protected void setConfigProperties(LocalConfiguration config) throws Exception {
        config.setProperty("cargo.rmi.port", Integer.toString(AppServerUtil.getPort()));
    }

    private static class TCJBoss3xInstalledLocalContainer
    extends JBoss3xInstalledLocalContainer {
        private final Collection sars;
        private final AppServerInfo appServerInfo;
        private final Collection<String> tomcatServerJars;

        public TCJBoss3xInstalledLocalContainer(LocalConfiguration configuration, Collection sars, AppServerInfo appServerInfo, Collection<String> tomcatServerJars) {
            super(configuration);
            this.sars = sars;
            this.appServerInfo = appServerInfo;
            this.tomcatServerJars = tomcatServerJars;
        }

        protected void doStart(Java java) throws Exception {
            JBossHelper.startupActions(new File(this.getConfiguration().getHome()), this.sars, this.appServerInfo, this.tomcatServerJars);
            super.doStart(java);
        }
    }
}

