/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.glassfishv3;

import com.tc.process.Exec;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.glassfish.AbstractGlassfishAppServer;
import com.tc.test.server.appserver.glassfish.GlassfishAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import com.tc.test.server.util.RetryException;
import com.tc.text.Banner;
import java.io.File;
import java.util.ArrayList;

public class GlassfishV3AppServer
extends AbstractGlassfishAppServer {
    public GlassfishV3AppServer(GlassfishAppServerInstallation installation) {
        super(installation);
    }

    @Override
    protected File getStartScript(AppServerParameters params) {
        return new File(new File(new File(this.serverInstallDirectory(), "glassfish"), "bin"), GlassfishV3AppServer.getPlatformScript("startserv"));
    }

    @Override
    protected File getStopScript(AppServerParameters params) {
        return new File(new File(new File(this.serverInstallDirectory(), "glassfish"), "bin"), GlassfishV3AppServer.getPlatformScript("stopserv"));
    }

    @Override
    protected ServerResult start0(AppServerParameters params) throws Exception {
        this.instanceDir = this.createInstance(params);
        this.instanceDir.delete();
        if (this.instanceDir.exists()) {
            throw new RuntimeException("Instance dir must not exist: " + this.instanceDir.getAbsolutePath());
        }
        this.createDomain(params);
        this.modifyDomainConfig(params);
        this.setProperties(params, this.httpPort, this.instanceDir);
        File startScript = this.getStartScript(params);
        final String[] cmd = new String[]{startScript.getAbsolutePath(), "--domaindir", this.instanceDir.getParentFile().getAbsolutePath(), params.instanceName()};
        final File nodeLogFile = new File(this.instanceDir.getParent(), this.instanceDir.getName() + ".log");
        final Process process = Runtime.getRuntime().exec(cmd, null, this.instanceDir);
        this.runner = new Thread("runner for " + params.instanceName()){

            @Override
            public void run() {
                try {
                    Exec.Result result = Exec.execute((Process)process, (String[])cmd, (String)nodeLogFile.getAbsolutePath(), null, (File)GlassfishV3AppServer.this.instanceDir);
                    if (result.getExitCode() != 0) {
                        System.err.println(result);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.runner.start();
        System.err.println("Starting " + params.instanceName() + " on port " + this.httpPort + "...");
        boolean started = false;
        long timeout = System.currentTimeMillis() + 300000L;
        while (System.currentTimeMillis() < timeout) {
            if (AppServerUtil.pingPort(this.adminPort)) {
                started = true;
                break;
            }
            if (this.runner.isAlive()) continue;
            if (GlassfishV3AppServer.amxDebugCheck(nodeLogFile)) {
                throw new RetryException("NPE in AMXDebug");
            }
            throw new RuntimeException("Runner thread finished before timeout");
        }
        if (!started) {
            throw new RuntimeException("Failed to start server in 300000ms");
        }
        System.err.println("Started " + params.instanceName() + " on port " + this.httpPort);
        this.waitForAppInstanceRunning(params);
        this.deployWars(nodeLogFile, params.deployables());
        this.waitForPing(nodeLogFile);
        return new AppServerResult(this.httpPort, this);
    }

    @Override
    public void stop(ServerParameters rawParams) throws Exception {
        AppServerParameters params = (AppServerParameters)rawParams;
        System.err.println("Stopping instance on port " + this.httpPort + "...");
        File stopScript = this.getStopScript(params);
        String[] cmd = new String[]{stopScript.getAbsolutePath(), "--domaindir", this.instanceDir.getParentFile().getAbsolutePath(), params.instanceName()};
        Exec.Result result = Exec.execute((String[])cmd, null, null, (File)stopScript.getParentFile());
        if (result.getExitCode() != 0) {
            System.err.println(result);
        }
        if (this.runner != null) {
            this.runner.join(300000L);
            if (this.runner.isAlive()) {
                Banner.errorBanner((String)("instance still running on port " + this.httpPort));
            } else {
                System.err.println("Stopped instance on port " + this.httpPort);
            }
        }
    }

    @Override
    protected void createDomain(AppServerParameters params) throws Exception {
        File asAdminScript = this.getAsadminScript();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(asAdminScript.getAbsolutePath());
        cmd.add("--interactive=false");
        cmd.add("--user");
        cmd.add("admin");
        cmd.add("create-domain");
        cmd.add("--adminport");
        cmd.add(String.valueOf(this.adminPort));
        cmd.add("--instanceport");
        cmd.add(String.valueOf(this.httpPort));
        cmd.add("--savemasterpassword=true");
        cmd.add("--domaindir=" + this.sandboxDirectory());
        cmd.add("--domainproperties");
        cmd.add("jms.port=" + this.pc.chooseRandomPort() + ":" + "orb.listener.port=" + this.pc.chooseRandomPort() + ":" + "http.ssl.port=" + this.pc.chooseRandomPort() + ":" + "orb.ssl.port=" + this.pc.chooseRandomPort() + ":" + "orb.mutualauth.port=" + this.pc.chooseRandomPort() + ":" + "domain.jmxPort=" + this.pc.chooseRandomPort());
        cmd.add("--savelogin=true");
        cmd.add("--nopassword=true");
        cmd.add(params.instanceName());
        Exec.Result result = Exec.execute((String[])cmd.toArray(new String[0]), null, null, (File)asAdminScript.getParentFile());
        if (result.getExitCode() != 0) {
            throw new RuntimeException(result.toString());
        }
    }

    @Override
    protected String[] getDisplayCommand(String script, AppServerParameters params) {
        return null;
    }
}

