/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.glassfish;

import com.tc.test.AppServerInfo;
import com.tc.test.server.appserver.AppServer;
import com.tc.test.server.appserver.AppServerFactory;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.glassfish.GlassfishAppServerInstallation;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.xalan.xsltc.trax.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractGlassfishAppServerFactory
extends AppServerFactory {
    public AbstractGlassfishAppServerFactory(AppServerFactory.ProtectedKey protectedKey) {
        super(protectedKey);
    }

    @Override
    public AppServerParameters createParameters(String instanceName, Properties props) {
        return new StandardAppServerParameters(instanceName, props);
    }

    @Override
    public abstract AppServer createAppServer(AppServerInstallation var1);

    private void doSetup(GlassfishAppServerInstallation install) throws IOException, Exception {
        File installDir = install.serverInstallDirectory();
        File configDir = new File(installDir, "config");
        File domainsDir = new File(installDir, "domains");
        FileUtils.deleteDirectory((File)configDir);
        FileUtils.deleteDirectory((File)domainsDir);
        File antScript = new File(installDir, "setup.xml");
        if (!antScript.isFile() || !antScript.canRead()) {
            throw new RuntimeException("missing ant script " + antScript.getAbsolutePath());
        }
        this.modifySetupXml(antScript);
        Project p = new Project();
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)consoleLogger);
        p.setUserProperty("ant.file", antScript.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        p.setBaseDir(installDir);
        p.setProperty("basedir", null);
        helper.parse(p, (Object)antScript);
        p.executeTarget(p.getDefaultTarget());
    }

    private void modifySetupXml(File antScript) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(antScript);
        NodeList list = document.getElementsByTagName("target");
        int numTargets = list.getLength();
        Node createDomainTarget = null;
        for (int i = 0; i < numTargets; ++i) {
            Node inspect = list.item(i);
            Node nameAttr = inspect.getAttributes().getNamedItem("name");
            if (nameAttr == null || !"create.domain".equals(nameAttr.getNodeValue())) continue;
            createDomainTarget = inspect;
            break;
        }
        if (createDomainTarget == null) {
            throw new RuntimeException("Cannot find target in " + antScript.getAbsolutePath());
        }
        while (createDomainTarget.getChildNodes().getLength() > 0) {
            createDomainTarget.removeChild(createDomainTarget.getChildNodes().item(0));
        }
        NodeList chmodTasks = document.getElementsByTagName("chmod");
        for (int i = 0; i < chmodTasks.getLength(); ++i) {
            Element chmod = (Element)chmodTasks.item(i);
            chmod.setAttribute("parallel", "false");
        }
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter sw = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(sw));
        FileUtils.writeStringToFile((File)antScript, (String)sw.toString(), (String)"UTF-8");
    }

    @Override
    public AppServerInstallation createInstallation(File home, File workingDir, AppServerInfo appServerInfo) throws Exception {
        GlassfishAppServerInstallation install = new GlassfishAppServerInstallation(home, workingDir, appServerInfo);
        this.doSetup(install);
        return install;
    }
}

