/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.glassfish;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import com.tc.lcp.CargoLinkedChildProcess;
import com.tc.lcp.HeartBeatService;
import com.tc.process.Exec;
import com.tc.test.TestConfigObject;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.deployment.WARBuilder;
import com.tc.test.server.appserver.glassfish.GlassfishAppServerInstallation;
import com.tc.test.server.util.AppServerUtil;
import com.tc.test.server.util.ParamsWithRetry;
import com.tc.test.server.util.RetryException;
import com.tc.text.Banner;
import com.tc.util.Assert;
import com.tc.util.Grep;
import com.tc.util.PortChooser;
import com.tc.util.concurrent.ThreadUtil;
import com.tc.util.runtime.Os;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.xalan.xsltc.trax.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractGlassfishAppServer
extends AbstractAppServer {
    public static final int STARTUP_RETRIES = 3;
    public static final String JAVA_CMD;
    public static final String ADMIN_USER = "admin";
    public static final String PASSWD = "password";
    public static final String PINGWAR = "ping";
    public static final long START_STOP_TIMEOUT = 300000L;
    protected final PortChooser pc = new PortChooser();
    protected File passwdFile;
    protected Thread runner;
    protected File instanceDir;
    protected int httpPort;
    protected int adminPort;
    private Process process;

    public AbstractGlassfishAppServer(GlassfishAppServerInstallation installation) {
        super(installation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File getPasswdFile() throws IOException {
        if (this.passwdFile == null) {
            this.passwdFile = new File(this.instanceDir.getParentFile(), "passwd" + System.currentTimeMillis() + ".txt");
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileOutputStream(this.passwdFile));
                out.println("AS_ADMIN_PASSWORD=password");
                out.println("AS_ADMIN_ADMINPASSWORD=password");
                out.println("AS_ADMIN_MASTERPASSWORD=password");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        return this.passwdFile;
    }

    protected static String getPlatformScript(String name) {
        if (Os.isWindows()) {
            return name + ".bat";
        }
        return name;
    }

    protected void createDomain(AppServerParameters params) throws Exception {
        File asAdminScript = this.getAsadminScript();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(asAdminScript.getAbsolutePath());
        cmd.add("create-domain");
        cmd.add("--interactive=false");
        cmd.add("--domaindir=" + this.sandboxDirectory());
        cmd.add("--adminport");
        cmd.add(String.valueOf(this.adminPort));
        cmd.add("--adminuser");
        cmd.add(ADMIN_USER);
        cmd.add("--passwordfile");
        cmd.add(this.getPasswdFile().getAbsolutePath());
        cmd.add("--instanceport");
        cmd.add(String.valueOf(this.httpPort));
        cmd.add("--savemasterpassword=true");
        cmd.add("--domainproperties");
        cmd.add("jms.port=" + this.pc.chooseRandomPort() + ":" + "orb.listener.port=" + this.pc.chooseRandomPort() + ":" + "http.ssl.port=" + this.pc.chooseRandomPort() + ":" + "orb.ssl.port=" + this.pc.chooseRandomPort() + ":" + "orb.mutualauth.port=" + this.pc.chooseRandomPort() + ":" + "domain.jmxPort=" + this.pc.chooseRandomPort());
        cmd.add("--savelogin=true");
        cmd.add(params.instanceName());
        Exec.Result result = Exec.execute((String[])cmd.toArray(new String[0]), null, null, (File)asAdminScript.getParentFile());
        if (result.getExitCode() != 0) {
            throw new RuntimeException(result.toString());
        }
    }

    protected static void checkFile(File file) {
        if (!file.isFile()) {
            throw new RuntimeException(file.getAbsolutePath() + " is not a file or does not exist");
        }
        if (!file.canRead()) {
            throw new RuntimeException(file.getAbsolutePath() + " cannot be read");
        }
    }

    protected File getInstanceFile(String path) {
        Assert.assertNotNull((Object)this.instanceDir);
        File f = new File(this.instanceDir, path);
        AbstractGlassfishAppServer.checkFile(f);
        return f;
    }

    protected File getAsadminScript() {
        File glassfishInstall = this.serverInstallDirectory();
        File asAdminScript = new File(new File(glassfishInstall, "bin"), AbstractGlassfishAppServer.getPlatformScript("asadmin"));
        AbstractGlassfishAppServer.checkFile(asAdminScript);
        return asAdminScript;
    }

    @Override
    public ServerResult start(ServerParameters rawParams) throws Exception {
        AppServerParameters params = (AppServerParameters)rawParams;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.start0(new ParamsWithRetry(params, i));
            }
            catch (RetryException re) {
                Banner.warnBanner((String)("Re-trying server startup (" + i + ") " + re.getMessage()));
                if (this.process == null) continue;
                try {
                    this.process.destroy();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
        }
        throw new RuntimeException("Failed to start server in 3 attempts");
    }

    protected ServerResult start0(AppServerParameters params) throws Exception {
        this.httpPort = this.pc.chooseRandomPort();
        this.adminPort = this.pc.chooseRandomPort();
        this.instanceDir = this.createInstance(params);
        this.instanceDir.delete();
        if (this.instanceDir.exists()) {
            throw new RuntimeException("Instance dir must not exist: " + this.instanceDir.getAbsolutePath());
        }
        this.createDomain(params);
        this.modifyDomainConfig(params);
        this.setProperties(params, this.httpPort, this.instanceDir);
        final String[] cmd = this.getStartupCommand(params);
        final File nodeLogFile = new File(this.instanceDir.getParent(), this.instanceDir.getName() + ".log");
        this.process = Runtime.getRuntime().exec(cmd, null, this.instanceDir);
        this.runner = new Thread("runner for " + params.instanceName()){

            @Override
            public void run() {
                try {
                    Exec.Result result = Exec.execute((Process)AbstractGlassfishAppServer.this.process, (String[])cmd, (String)nodeLogFile.getAbsolutePath(), (byte[])AbstractGlassfishAppServer.startupInput(), (File)AbstractGlassfishAppServer.this.instanceDir);
                    if (result.getExitCode() != 0) {
                        System.err.println(result);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.runner.start();
        System.err.println("Starting " + params.instanceName() + " on port " + this.httpPort + "...");
        boolean started = false;
        long timeout = System.currentTimeMillis() + 300000L;
        while (System.currentTimeMillis() < timeout) {
            if (AppServerUtil.pingPort(this.adminPort)) {
                started = true;
                break;
            }
            if (this.runner.isAlive()) continue;
            if (AbstractGlassfishAppServer.amxDebugCheck(nodeLogFile)) {
                throw new RetryException("NPE in AMXDebug");
            }
            throw new RuntimeException("Runner thread finished before timeout");
        }
        if (!started) {
            throw new RuntimeException("Failed to start server in 300000ms");
        }
        System.err.println("Started " + params.instanceName() + " on port " + this.httpPort);
        this.waitForAppInstanceRunning(params);
        this.deployWars(nodeLogFile, params.deployables());
        this.waitForPing(nodeLogFile);
        return new AppServerResult(this.httpPort, this);
    }

    private static void clearAsAdminFiles() {
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            File home = new File(userHome);
            if (home.isDirectory()) {
                for (File file : home.listFiles()) {
                    if ((file.getName().equals(".asadminpass") || file.getName().equals(".asadmintruststore")) && !file.delete()) {
                        throw new AssertionError((Object)("cannot delete: " + file.getAbsolutePath()));
                    }
                }
            } else {
                throw new AssertionError((Object)(home.getAbsolutePath() + " is not a directory?"));
            }
        }
    }

    protected static boolean amxDebugCheck(File nodeLogFile) throws IOException {
        List hits = Grep.grep((String)"^Caused by: java.lang.NullPointerException$", (File)nodeLogFile);
        List hits2 = Grep.grep((String)"^\tat com.sun.appserv.management.base.AMXDebug.getDebug", (File)nodeLogFile);
        return !hits.isEmpty() && !hits2.isEmpty();
    }

    protected void waitForPing(File nodeLogFile) throws Exception {
        String pingUrl = "http://localhost:" + this.httpPort + "/ping/index.html";
        WebConversation wc = new WebConversation();
        wc.setExceptionsThrownOnErrorStatus(false);
        int tries = 10;
        for (int i = 0; i < tries; ++i) {
            try {
                System.err.println("Pinging " + pingUrl + " - try #" + i);
                WebResponse response = wc.getResponse(pingUrl);
                if (response.getResponseCode() == 200) {
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ThreadUtil.reallySleep((long)2000L);
        }
        List hits = Grep.grep((String)"^SEVERE: WEB0610: WebModule \\[/web1\\] failed to deploy and has been disabled$", (File)nodeLogFile);
        if (!hits.isEmpty()) {
            throw new RetryException("web1");
        }
        throw new RetryException("ping app failed to deploy");
    }

    protected void waitForAppInstanceRunning(AppServerParameters params) throws Exception {
        while (true) {
            String status = this.getAppInstanceStatus(params);
            System.err.println(params.instanceName() + " is " + status);
            if ("running".equals(status) || status.contains("Running")) break;
            System.err.println("Sleeping for 2 sec before checking again...");
            ThreadUtil.reallySleep((long)2000L);
        }
    }

    private String getAppInstanceStatus(AppServerParameters params) throws Exception {
        File asAdminScript = this.getAsadminScript();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(asAdminScript.getAbsolutePath());
        cmd.add("list-domains");
        cmd.add("--domaindir=" + this.sandboxDirectory());
        Exec.Result result = Exec.execute((String[])cmd.toArray(new String[0]), null, null, (File)asAdminScript.getParentFile());
        if (result.getStderr().trim().length() > 0) {
            System.err.println("Error Stream: " + result.getStderr());
        }
        System.err.flush();
        if (result.getExitCode() != 0) {
            throw new RuntimeException(result.toString());
        }
        return this.getStatus(params.instanceName(), result.getStdout());
    }

    private String getStatus(String instanceName, String output) {
        int start = output.indexOf(instanceName);
        if (start < 0) {
            return "";
        }
        String line = output.substring(start);
        int end = line.indexOf("\n");
        if (end < 0) {
            throw new RuntimeException("no end: " + line);
        }
        line = line.substring(0, end).trim();
        int delim = line.indexOf(" ");
        String appName = line.substring(0, delim);
        String status = line.substring(delim + 1);
        Assert.assertEquals((Object)appName, (Object)instanceName);
        return status.trim();
    }

    private static byte[] startupInput() {
        try {
            String eol = System.getProperty("line.separator");
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write((ADMIN_USER + eol + PASSWD + eol + PASSWD + eol).getBytes());
            if (Os.isWindows()) {
                bytes.write(26);
            } else {
                bytes.write(4);
            }
            return bytes.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void deployWars(File nodeLogFile, Map wars) throws Exception {
        for (Map.Entry entry : wars.entrySet()) {
            String warName = (String)entry.getKey();
            File warFile = (File)entry.getValue();
            this.deployWar(warName, warFile, nodeLogFile);
        }
        this.deployWar(PINGWAR, this.createPingWarFile("ping.war"), nodeLogFile);
    }

    private File createPingWarFile(String warName) throws Exception {
        WARBuilder builder = new WARBuilder(warName, new File(this.sandboxDirectory(), "war"));
        builder.addResourceFullpath("/com/tc/test/server/appserver/glassfish", "index.html", "index.html");
        return builder.makeDeployment().getFileSystemPath().getFile();
    }

    private void deployWar(String warName, File warFile, File nodeLogFile) throws IOException, Exception {
        System.err.println("Deploying war [" + warName + "] on " + this.instanceDir.getName());
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getAsadminScript().getAbsolutePath());
        cmd.add("deploy");
        cmd.add("--interactive=false");
        cmd.add("--user");
        cmd.add(ADMIN_USER);
        cmd.add("--passwordfile");
        cmd.add(this.getPasswdFile().getAbsolutePath());
        cmd.add("--contextroot=" + warName);
        cmd.add("--port=" + this.adminPort);
        cmd.add(warFile.getAbsolutePath());
        Exec.Result result = Exec.execute((String[])cmd.toArray(new String[0]));
        if (result.getExitCode() == 0) {
            System.err.println("Deployed war file successfully (supposedly).");
            System.err.println(result);
            return;
        }
        this.process.destroy();
        this.process = null;
        ThreadUtil.reallySleep((long)3000L);
        List hits = Grep.grep((String)"^SEVERE: WEB0610: WebModule \\[/web1\\] failed to deploy and has been disabled$", (File)nodeLogFile);
        if (!hits.isEmpty()) {
            throw new RetryException(result.toString());
        }
        throw new RuntimeException("Deploy failed for " + warName + ": " + result);
    }

    protected abstract File getStartScript(AppServerParameters var1);

    protected abstract File getStopScript(AppServerParameters var1);

    protected abstract String[] getDisplayCommand(String var1, AppServerParameters var2);

    protected String[] getStartupCommand(AppServerParameters params) throws Exception {
        Exec.Result result;
        File startScript = this.getStartScript(params);
        String[] displayCommand = this.getDisplayCommand(startScript.getAbsolutePath(), params);
        if (Os.isUnix()) {
            String[] tmp = new String[displayCommand.length + 1];
            tmp[0] = "/bin/sh";
            System.arraycopy(displayCommand, 0, tmp, 1, displayCommand.length);
            displayCommand = tmp;
        }
        if ((result = Exec.execute((String[])displayCommand, null, null, (File)startScript.getParentFile())).getExitCode() != 0) {
            throw new RuntimeException("error executing startserv script: " + result);
        }
        String output = result.getStdout().trim();
        System.err.println(output);
        if (!output.startsWith("STARTOFCOMMAND|") || !output.endsWith("|ENDOFCOMMAND|")) {
            throw new RuntimeException("cannot parse output: " + output);
        }
        output = output.substring("STARTOFCOMMAND|".length());
        output = output.substring(0, output.length() - "|ENDOFCOMMAND|".length());
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(output.split("\\|")));
        this.modifyStartupCommand(cmd);
        for (int i = 0; i < cmd.size(); ++i) {
            String s = (String)cmd.get(i);
            if (s.toLowerCase().trim().equals("-classpath") || s.toLowerCase().trim().equals("-cp")) {
                throw new RuntimeException("unexpected classpath arguments in startup command " + cmd);
            }
            if (!s.startsWith("-Djava.class.path=")) continue;
            cmd.set(i, s + File.pathSeparator + TestConfigObject.getInstance().extraClassPathForAppServer());
            break;
        }
        String mainArg = (String)cmd.remove(cmd.size() - 1);
        String mainClass = (String)cmd.remove(cmd.size() - 1);
        if (!"com.sun.enterprise.server.PELaunch".equals(mainClass)) {
            throw new RuntimeException("Unexpected main class: " + mainClass);
        }
        if (!"start".equals(mainArg)) {
            throw new RuntimeException("unexpected main argument: " + mainArg);
        }
        cmd.add(CargoLinkedChildProcess.class.getName());
        cmd.add(mainClass);
        cmd.add(String.valueOf(HeartBeatService.listenPort()));
        cmd.add(this.instanceDir.toString());
        cmd.add(mainArg);
        cmd.add(0, JAVA_CMD);
        System.err.println("XXX startup command: " + cmd);
        return cmd.toArray(new String[0]);
    }

    protected void modifyStartupCommand(List cmd) {
    }

    protected void modifyDomainConfig(AppServerParameters params) throws Exception {
        File domainXML = this.getInstanceFile("config/domain.xml");
        System.err.println("Modifying domain configuration at " + domainXML.getAbsolutePath());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(domainXML);
        NodeList list = document.getElementsByTagName("java-config");
        if (list.getLength() != 1) {
            throw new RuntimeException("wrong number of elements " + list.getLength());
        }
        Node javaConfig = list.item(0);
        this.appendDSOParams(document, javaConfig, params);
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        Transformer transformer = transformerFactory.newTransformer();
        if (document.getDoctype() != null) {
            transformer.setOutputProperty("doctype-public", document.getDoctype().getPublicId());
            transformer.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
        }
        StringWriter sw = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(sw));
        FileUtils.writeStringToFile((File)domainXML, (String)sw.toString(), (String)"UTF-8");
    }

    private void appendDSOParams(Document doc, Node node, AppServerParameters params) {
        String[] jvmArgs;
        for (String arg : jvmArgs = params.jvmArgs().replaceAll("'", "").split("\\s")) {
            Element element = doc.createElement("jvm-options");
            element.appendChild(doc.createTextNode(arg));
            node.appendChild(element);
        }
        Element element = doc.createElement("jvm-options");
        element.appendChild(doc.createTextNode("-Dcom.sun.enterprise.server.ss.ASQuickStartup=false"));
        node.appendChild(element);
    }

    @Override
    public void stop(ServerParameters rawParams) throws Exception {
        AppServerParameters params = (AppServerParameters)rawParams;
        System.err.println("Stopping instance on port " + this.httpPort + "...");
        File stopScript = this.getStopScript(params);
        Exec.Result result = Exec.execute((String[])new String[]{stopScript.getAbsolutePath()}, null, null, (File)stopScript.getParentFile());
        if (result.getExitCode() != 0) {
            System.err.println(result);
        }
        if (this.runner != null) {
            this.runner.join(300000L);
            if (this.runner.isAlive()) {
                Banner.errorBanner((String)("instance still running on port " + this.httpPort));
            } else {
                System.err.println("Stopped instance on port " + this.httpPort);
            }
        }
    }

    static {
        AbstractGlassfishAppServer.clearAsAdminFiles();
        JAVA_CMD = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }
}

