/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.util.runtime.ThreadDump;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WatchDog {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final Thread threadToWatch;
    private final Timer timer;
    private TimerTask timerTask;
    private TimerTask dumpTask;
    private final int timeoutInSecs;

    public WatchDog(int timeOutInSecs) {
        this.timeoutInSecs = timeOutInSecs;
        this.threadToWatch = Thread.currentThread();
        this.timer = new Timer();
    }

    public void startWatching() {
        this.logger.debug((Object)"Watching thread");
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                WatchDog.this.logger.error((Object)"Thread timeout..interrupting");
                WatchDog.this.threadToWatch.interrupt();
            }
        };
        this.dumpTask = new TimerTask(){

            @Override
            public void run() {
                ThreadDump.dumpAllJavaProcesses();
            }
        };
        this.timer.schedule(this.timerTask, this.timeoutInSecs * 1000);
        this.timer.schedule(this.dumpTask, (this.timeoutInSecs - 45) * 1000);
    }

    public void stopWatching() {
        this.logger.debug((Object)"watching cancelled..");
        this.timerTask.cancel();
        this.dumpTask.cancel();
        this.timer.cancel();
    }
}

