/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.test.server.appserver.deployment.DeploymentBuilder;
import com.tc.test.server.appserver.deployment.FileSystemPath;
import com.tc.test.server.appserver.deployment.RemoteContextListener;
import com.tc.test.server.appserver.deployment.RemoteService;
import com.tc.test.server.appserver.deployment.WARDeployment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.codehaus.cargo.util.AntUtils;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;

public class WARBuilder
implements DeploymentBuilder {
    private static final TCLogger logger = TCLogging.getLogger(WARBuilder.class);
    private FileSystemPath warDirectoryPath;
    private final String warFileName;
    private final Set classDirectories = new HashSet();
    private final Set libs = new HashSet();
    private final List resources = new ArrayList();
    private final List remoteServices = new ArrayList();
    private final Set beanDefinitionFiles = new HashSet();
    private final Map contextParams = new HashMap();
    private final Map sessionConfig = new HashMap();
    private final List listeners = new ArrayList();
    private final List servlets = new ArrayList();
    private final List filters = new ArrayList();
    private final Map taglibs = new HashMap();
    private final StringBuffer remoteSvcDefBlock = new StringBuffer();
    private final FileSystemPath tempDirPath;
    private final Map errorPages = new HashMap();
    private String dispatcherServletName = null;
    private final TestConfigObject testConfig;
    private final FileSystemPath tmpResourcePath;
    private final boolean clustered;
    private boolean neededWebXml = true;

    public WARBuilder(File tempDir, TestConfigObject config) throws IOException {
        this(File.createTempFile("test", ".war", tempDir).getAbsolutePath(), tempDir, config, true);
    }

    public WARBuilder(String warFileName, File tempDir) {
        this(warFileName, tempDir, TestConfigObject.getInstance(), true);
    }

    public WARBuilder(String warFileName, File tempDir, TestConfigObject config, boolean clustered) {
        this.warFileName = warFileName;
        this.tempDirPath = new FileSystemPath(tempDir);
        this.testConfig = config;
        this.tmpResourcePath = this.tempDirPath.mkdir("tempres");
        this.clustered = clustered;
        this.addDirectoryOrJARContainingClass(WARBuilder.class);
    }

    public DeploymentBuilder addClassesDirectory(FileSystemPath path) {
        this.classDirectories.add(path);
        return this;
    }

    @Override
    public Deployment makeDeployment() throws Exception {
        this.createWARDirectory();
        FileSystemPath warFile = this.makeWARFileName();
        logger.debug((Object)("Creating war file: " + warFile));
        warFile.delete();
        War warTask = this.makeWarTask();
        warTask.setUpdate(false);
        Zip.Duplicate df = new Zip.Duplicate();
        df.setValue("preserve");
        warTask.setDuplicate(df);
        warTask.setDestFile(warFile.getFile());
        if (this.neededWebXml) {
            warTask.setWebxml(this.warDirectoryPath.existingFile("WEB-INF/web.xml").getFile());
        } else {
            warTask.setNeedxmlfile(false);
        }
        this.addWEBINFDirectory(warTask);
        this.addClassesDirectories(warTask);
        this.addLibs(warTask);
        this.addResources(warTask);
        warTask.execute();
        return new WARDeployment(warFile, this.clustered);
    }

    @Override
    public boolean isClustered() {
        return this.clustered;
    }

    private FileSystemPath makeWARFileName() {
        File f = new File(this.warFileName);
        if (f.isAbsolute()) {
            return FileSystemPath.makeNewFile(this.warFileName);
        }
        return this.tempDirPath.file(this.warFileName);
    }

    private void addLibs(War warTask) {
        for (FileSystemPath lib : this.libs) {
            ZipFileSet zipFileSet = new ZipFileSet();
            zipFileSet.setFile(lib.getFile());
            warTask.addLib(zipFileSet);
        }
    }

    private War makeWarTask() {
        return (War)new AntUtils().createAntTask("war");
    }

    private void addClassesDirectories(War warTask) {
        for (FileSystemPath path : this.classDirectories) {
            ZipFileSet zipFileSet = new ZipFileSet();
            zipFileSet.setDir(path.getFile());
            warTask.addClasses(zipFileSet);
        }
    }

    private void addResources(War warTask) {
        for (ResourceDefinition definition : this.resources) {
            ZipFileSet zipfileset = new ZipFileSet();
            zipfileset.setDir(definition.location);
            zipfileset.setIncludes(definition.includes);
            if (definition.prefix != null) {
                zipfileset.setPrefix(definition.prefix);
            }
            if (definition.fullpath != null) {
                zipfileset.setFullpath(definition.fullpath);
            }
            warTask.addZipfileset(zipfileset);
        }
    }

    private void addWEBINFDirectory(War warTask) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(this.warDirectoryPath.getFile());
        warTask.addFileset((FileSet)zipFileSet);
    }

    public DeploymentBuilder addClassesDirectory(String directory) {
        return this.addClassesDirectory(FileSystemPath.existingDir(directory));
    }

    void createWARDirectory() throws IOException {
        this.warDirectoryPath = this.tempDirPath.mkdir("tempwar");
        FileSystemPath webInfDir = this.warDirectoryPath.mkdir("WEB-INF");
        if (this.neededWebXml) {
            this.createWebXML(webInfDir);
        }
        if (this.dispatcherServletName != null) {
            this.createDispatcherServletContext(webInfDir);
        } else if (this.testConfig.isSpringTest()) {
            this.createRemotingContext(webInfDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDispatcherServletContext(FileSystemPath webInfDir) throws IOException {
        FileSystemPath springRemotingAppCtx = webInfDir.file(this.dispatcherServletName + "-servlet.xml");
        FileOutputStream fos = new FileOutputStream(springRemotingAppCtx.getFile());
        try {
            this.appendFile(fos, "/dispatcherServletContextHeader.txt");
            PrintWriter pw = new PrintWriter(fos);
            pw.println(this.remoteSvcDefBlock.toString());
            this.writeHandlerMappingBean(pw);
            for (RemoteService remoteService : this.remoteServices) {
                this.writeRemoteService(pw, remoteService);
            }
            pw.flush();
            this.writeFooter(fos);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRemotingContext(FileSystemPath webInfDir) throws IOException {
        FileSystemPath springRemotingAppCtx = webInfDir.mkdir("classes/com/tctest/spring").file("spring-remoting.xml");
        FileOutputStream fos = new FileOutputStream(springRemotingAppCtx.getFile());
        try {
            this.appendFile(fos, "/remoteContextHeader.txt");
            PrintWriter pw = new PrintWriter(fos);
            pw.println(this.remoteSvcDefBlock.toString());
            this.writeRegistryFactoryBean(pw);
            for (RemoteService remoteService : this.remoteServices) {
                this.writeRemoteService(pw, remoteService);
            }
            pw.flush();
            this.writeFooter(fos);
        }
        finally {
            fos.close();
        }
    }

    private void writeHandlerMappingBean(PrintWriter pw) {
        pw.println("<bean id=\"defaultHandlerMapping\" class=\"" + BeanNameUrlHandlerMapping.class.getName() + "\"/>");
    }

    private void writeRegistryFactoryBean(PrintWriter pw) {
        pw.println("<bean class=\"" + RmiRegistryFactoryBean.class.getName() + "\"  name=\"registry\" >");
        pw.println("<property name=\"port\" value=\"${rmi.registry.port}\" />");
        pw.println("</bean>");
    }

    private void writeRemoteService(PrintWriter pw, RemoteService remoteService) {
        if (this.dispatcherServletName == null) {
            pw.println("<bean class=\"" + remoteService.getExporterType().getName() + "\">");
            this.printProperty(pw, "serviceName", remoteService.getRemoteName());
            this.printPropertyRef(pw, "service", remoteService.getBeanName());
            this.printProperty(pw, "serviceInterface", remoteService.getInterfaceType().getName());
            this.printPropertyRef(pw, "registry", "registry");
            pw.println("</bean>");
        } else {
            pw.println("<bean name=\"/" + remoteService.getRemoteName() + "\" class=\"" + remoteService.getExporterType().getName() + "\">");
            this.printPropertyRef(pw, "service", remoteService.getBeanName());
            this.printProperty(pw, "serviceInterface", remoteService.getInterfaceType().getName());
            pw.println("</bean>");
        }
    }

    private void printProperty(PrintWriter pw, String propertyName, String propertyValue) {
        pw.println("<property name=\"" + propertyName + "\" value=\"" + propertyValue + "\" />");
    }

    private void printPropertyRef(PrintWriter pw, String propertyName, String propertyValue) {
        pw.println("<property name=\"" + propertyName + "\" ref=\"" + propertyValue + "\" />");
    }

    private void writeFooter(FileOutputStream fos) throws IOException {
        this.appendFile(fos, "/remoteContextFooter.txt");
    }

    private void appendFile(FileOutputStream fos, String fragmentName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(fragmentName);
        IOUtils.copy((InputStream)is, (OutputStream)fos);
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWebXML(FileSystemPath webInfDir) throws IOException {
        FileSystemPath webXML = webInfDir.file("web.xml");
        FileOutputStream fos = new FileOutputStream(webXML.getFile());
        try {
            logger.debug((Object)("Creating " + webXML.getFile().getAbsolutePath()));
            PrintWriter pw = new PrintWriter(fos);
            pw.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            pw.println("<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\"\nversion=\"2.4\">\n");
            if (!this.beanDefinitionFiles.isEmpty()) {
                this.writeContextParam(pw, "contextConfigLocation", this.generateContextConfigLocationValue());
            }
            for (Map.Entry param : this.contextParams.entrySet()) {
                this.writeContextParam(pw, (String)param.getKey(), (String)param.getValue());
            }
            for (Object definition : this.filters) {
                this.writeFilter(pw, (FilterDefinition)definition);
            }
            for (Object definition : this.filters) {
                logger.debug((Object)("Writing filter mapping[" + ((FilterDefinition)definition).name + " -> " + ((FilterDefinition)definition).mapping + "]"));
                pw.println("  <filter-mapping>");
                pw.println("    <filter-name>" + ((FilterDefinition)definition).name + "</filter-name>");
                pw.println("    <url-pattern>" + ((FilterDefinition)definition).mapping + "</url-pattern>");
                if (!((FilterDefinition)definition).dispatchers.isEmpty()) {
                    for (Dispatcher dispatcher : ((FilterDefinition)definition).dispatchers) {
                        pw.println("    <dispatcher>" + (Object)((Object)dispatcher) + "</dispatcher>");
                    }
                }
                pw.println("  </filter-mapping>");
            }
            if (!this.beanDefinitionFiles.isEmpty()) {
                this.writeListener(pw, ContextLoaderListener.class.getName());
                if (this.dispatcherServletName == null) {
                    this.writeListener(pw, RemoteContextListener.class.getName());
                }
            }
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                this.writeListener(pw, ((Class)((Object)it.next())).getName());
            }
            for (Object definition : this.servlets) {
                this.writeServlet(pw, (ServletDefinition)definition);
            }
            for (Object definition : this.servlets) {
                logger.debug((Object)("Writing servlet mapping[" + ((ServletDefinition)definition).name + " -> " + ((ServletDefinition)definition).mapping + "]"));
                pw.println("  <servlet-mapping>");
                pw.println("    <servlet-name>" + ((ServletDefinition)definition).name + "</servlet-name>");
                pw.println("    <url-pattern>" + ((ServletDefinition)definition).mapping + "</url-pattern>");
                pw.println("  </servlet-mapping>");
            }
            for (Map.Entry entry : this.sessionConfig.entrySet()) {
                this.writeSessionConfig(pw, (String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry e : this.errorPages.entrySet()) {
                Integer status = (Integer)e.getKey();
                String location = (String)e.getValue();
                pw.println("  <error-page>");
                pw.println("    <error-code>" + status + "</error-code>");
                pw.println("    <location>" + location + "</location>");
                pw.println("  </error-page>");
            }
            if (!this.taglibs.isEmpty()) {
                pw.println("  <jsp-config>");
                for (Map.Entry taglib : this.taglibs.entrySet()) {
                    logger.debug((Object)("Writing taglib[" + taglib.getKey() + "/" + taglib.getValue() + "]"));
                    pw.println("    <taglib>");
                    pw.println("      <taglib-uri>" + taglib.getKey() + "</taglib-uri>");
                    pw.println("      <taglib-location>" + taglib.getValue() + "</taglib-location>");
                    pw.println("    </taglib>");
                }
                pw.println("  </jsp-config>");
            }
            pw.println("</web-app>");
            pw.flush();
            logger.debug((Object)("Finished creating " + webXML.getFile().getAbsolutePath()));
        }
        finally {
            fos.close();
        }
    }

    private void writeContextParam(PrintWriter pw, String name, String value) {
        logger.debug((Object)("Writing context param[" + name + "/" + value + "]"));
        pw.println("  <context-param>");
        pw.println("    <param-name>" + name + "</param-name>");
        pw.println("    <param-value>" + value + "</param-value>");
        pw.println("  </context-param>");
    }

    private void writeSessionConfig(PrintWriter pw, String name, String value) {
        logger.debug((Object)("Writing session config[" + name + "/" + value + "]"));
        pw.println("  <session-config>");
        pw.println("    <" + name + ">" + value + "</" + name + ">");
        pw.println("  </session-config>");
    }

    private void writeListener(PrintWriter pw, String className) {
        logger.debug((Object)("Writing listener[" + className + "]"));
        pw.println("  <listener>");
        pw.println("    <listener-class>" + className + "</listener-class>");
        pw.println("  </listener>");
    }

    private void writeServlet(PrintWriter pw, ServletDefinition definition) {
        logger.debug((Object)("Writing servlet[" + definition.name + " of type " + definition.servletClass.getName() + "]"));
        pw.println("  <servlet>");
        pw.println("    <servlet-name>" + definition.name + "</servlet-name>");
        pw.println("    <servlet-class>" + definition.servletClass.getName() + "</servlet-class>");
        if (definition.initParameters != null) {
            for (Map.Entry param : definition.initParameters.entrySet()) {
                logger.debug((Object)("Writing servlet init parameter[" + param.getKey() + "/" + param.getValue() + "]"));
                pw.println("    <init-param>");
                pw.println("      <param-name>" + param.getKey() + "</param-name>");
                pw.println("      <param-value>" + param.getValue() + "</param-value>");
                pw.println("    </init-param>");
            }
        }
        if (definition.loadOnStartup) {
            pw.println("    <load-on-startup>1</load-on-startup>");
        }
        pw.println("  </servlet>");
    }

    private void writeFilter(PrintWriter pw, FilterDefinition definition) {
        logger.debug((Object)("Writing filter[" + definition.name + " of type " + definition.filterClass.getName() + "]"));
        pw.println("  <filter>");
        pw.println("    <filter-name>" + definition.name + "</filter-name>");
        pw.println("    <filter-class>" + definition.filterClass.getName() + "</filter-class>");
        if (definition.initParameters != null) {
            for (Map.Entry param : definition.initParameters.entrySet()) {
                logger.debug((Object)("Writing filter init param[" + param.getKey() + "/" + param.getValue() + "]"));
                pw.println("    <init-param>");
                pw.println("      <param-name>" + param.getKey() + "</param-name>");
                pw.println("      <param-value>" + param.getValue() + "</param-value>");
                pw.println("    </init-param>");
            }
        }
        pw.println("  </filter>");
    }

    private String generateContextConfigLocationValue() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (String beanDefinitionFile : this.beanDefinitionFiles) {
            pw.println(beanDefinitionFile);
        }
        pw.flush();
        return sw.toString();
    }

    @Override
    public DeploymentBuilder addBeanDefinitionFile(String beanDefinition) {
        this.beanDefinitionFiles.add(beanDefinition);
        return this;
    }

    @Override
    public DeploymentBuilder addRemoteService(String remoteName, String beanName, Class interfaceType) {
        this.remoteServices.add(new RemoteService(remoteName, beanName, interfaceType));
        return this;
    }

    @Override
    public DeploymentBuilder addRemoteService(Class exporterType, String remoteName, String beanName, Class interfaceType) {
        this.remoteServices.add(new RemoteService(exporterType, remoteName, beanName, interfaceType));
        return this;
    }

    @Override
    public DeploymentBuilder addRemoteService(String beanName, Class interfaceType) {
        this.addRemoteService(WARBuilder.capitalise(beanName), beanName, interfaceType);
        return this;
    }

    private static String capitalise(String s) {
        if (s == null) {
            return null;
        }
        int size = s.length();
        StringBuffer buffer = new StringBuffer(size);
        boolean space = true;
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                buffer.append(c);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(c));
                space = false;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @Override
    public DeploymentBuilder addRemoteServiceBlock(String block) {
        this.remoteSvcDefBlock.append(block + "\n");
        return this;
    }

    @Override
    public void setParentApplicationContextRef(String locatorFactorySelector, String parentContextKey) {
        this.contextParams.put("locatorFactorySelector", locatorFactorySelector);
        this.contextParams.put("parentContextKey", parentContextKey);
    }

    @Override
    public DeploymentBuilder addDirectoryOrJARContainingClass(Class type) {
        return this.addDirectoryOrJar(WARBuilder.calculatePathToClass(type));
    }

    @Override
    public DeploymentBuilder addDirectoryOrJARContainingClassOfSelectedVersion(Class type, String[] variantNames) {
        String pathSeparator = System.getProperty("path.separator");
        for (String variantName : variantNames) {
            String[] paths;
            String selectedVariant = this.testConfig.selectedVariantFor(variantName);
            String path = this.testConfig.variantLibraryClasspathFor(variantName, selectedVariant);
            for (String path2 : paths = path.split(pathSeparator)) {
                File filePath = new File(path2);
                if (!filePath.exists()) {
                    throw new RuntimeException("Variant path doesn't exist: " + filePath);
                }
                this.addDirectoryOrJar(new FileSystemPath(filePath));
            }
        }
        return this;
    }

    @Override
    public DeploymentBuilder addDirectoryContainingResource(String resource) {
        return this.addDirectoryOrJar(this.calculatePathToResource(resource));
    }

    @Override
    public DeploymentBuilder addResource(String location, String includes, String prefix) {
        FileSystemPath path = WARBuilder.getResourceDirPath(location, includes);
        File srcDir = this.extractResourceIfNeeded(path, location, includes);
        this.resources.add(new ResourceDefinition(srcDir, includes, prefix, null));
        return this;
    }

    @Override
    public DeploymentBuilder addFileAsResource(File file, String prefix) {
        File srcDir = file.getParentFile();
        this.resources.add(new ResourceDefinition(srcDir, file.getName(), prefix, null));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractResourceIfNeeded(FileSystemPath path, String location, String includes) {
        File rv;
        block13: {
            if (path.isDirectory() || !path.getFile().getName().endsWith(".jar")) break block13;
            JarFile jarFile = null;
            try {
                String dir;
                jarFile = new JarFile(path.getFile());
                String string = dir = location.startsWith("/") ? location.substring(1) : location;
                dir = dir != null ? (dir.trim().equals("") ? "" : dir + "/") : "";
                ZipEntry entry = jarFile.getEntry(dir + includes);
                File tmpParent = new File(this.tmpResourcePath.getFile(), dir);
                tmpParent.mkdirs();
                InputStream in = null;
                FileOutputStream fos = null;
                try {
                    in = jarFile.getInputStream(entry);
                    fos = new FileOutputStream(new File(tmpParent, includes));
                    IOUtils.copy((InputStream)in, (OutputStream)fos);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)fos);
                rv = tmpParent;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        rv = path.getFile();
        return rv;
    }

    @Override
    public DeploymentBuilder addResourceFullpath(String location, String includes, String fullpath) {
        FileSystemPath path = WARBuilder.getResourceDirPath(location, includes);
        File srcDir = this.extractResourceIfNeeded(path, location, includes);
        this.resources.add(new ResourceDefinition(srcDir, includes, null, fullpath));
        return this;
    }

    public static FileSystemPath getResourceDirPath(String location, String includes) {
        String resource = location + "/" + includes;
        URL url = WARBuilder.class.getResource(resource);
        Assert.assertNotNull((String)("Not found: " + resource), (Object)url);
        FileSystemPath path = WARBuilder.calculateDirectory(url, includes);
        return path;
    }

    @Override
    public DeploymentBuilder addContextParameter(String name, String value) {
        this.contextParams.put(name, value);
        return this;
    }

    @Override
    public DeploymentBuilder addSessionConfig(String name, String value) {
        this.sessionConfig.put(name, value);
        return this;
    }

    @Override
    public DeploymentBuilder addListener(Class listenerClass) {
        this.listeners.add(listenerClass);
        return this;
    }

    @Override
    public DeploymentBuilder setDispatcherServlet(String name, String mapping, Class servletClass, Map params, boolean loadOnStartup) {
        Assert.assertNull((Object)this.dispatcherServletName);
        this.dispatcherServletName = name;
        this.addServlet(name, mapping, servletClass, params, loadOnStartup);
        return this;
    }

    @Override
    public DeploymentBuilder addServlet(String name, String mapping, Class servletClass, Map params, boolean loadOnStartup) {
        this.servlets.add(new ServletDefinition(name, mapping, servletClass, params, loadOnStartup));
        this.addDirectoryOrJARContainingClass(servletClass);
        return this;
    }

    @Override
    public DeploymentBuilder addFilter(String name, String mapping, Class filterClass, Map params) {
        return this.addFilter(name, mapping, filterClass, params, null);
    }

    @Override
    public DeploymentBuilder addFilter(String name, String mapping, Class filterClass, Map params, Set<Dispatcher> dispatchers) {
        this.filters.add(new FilterDefinition(name, mapping, filterClass, params, dispatchers));
        return this;
    }

    @Override
    public DeploymentBuilder addTaglib(String uri, String location) {
        this.taglibs.put(uri, location);
        return this;
    }

    @Override
    public DeploymentBuilder addErrorPage(int status, String location) {
        this.errorPages.put(new Integer(status), location);
        return this;
    }

    private DeploymentBuilder addDirectoryOrJar(FileSystemPath path) {
        if (path.isDirectory()) {
            this.classDirectories.add(path);
        } else {
            this.libs.add(path);
        }
        return this;
    }

    public static FileSystemPath calculatePathToClass(Class type) {
        URL url = type.getResource("/" + WARBuilder.classToPath(type));
        Assert.assertNotNull((String)("Not found: " + type), (Object)url);
        FileSystemPath filepath = WARBuilder.calculateDirectory(url, "/" + WARBuilder.classToPath(type));
        return filepath;
    }

    @Override
    public DeploymentBuilder setNeededWebXml(boolean flag) {
        this.neededWebXml = flag;
        return this;
    }

    public static FileSystemPath calculatePathToClass(Class type, String pathString) {
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(pathString, pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("/")) {
                token = "/" + token;
            }
            URL u = null;
            try {
                u = token.endsWith(".jar") ? new URL("jar", "", "file:/" + token + "!/") : new URL("file", "", token + "/");
                urls[i] = u;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++i;
        }
        URL url = new URLClassLoader(urls, null).getResource(WARBuilder.classToPath(type));
        Assert.assertNotNull((String)("Not found: " + type), (Object)url);
        FileSystemPath filepath = WARBuilder.calculateDirectory(url, "/" + WARBuilder.classToPath(type));
        return filepath;
    }

    public static FileSystemPath calculateDirectory(URL url, String classNameAsPath) {
        String urlAsString = null;
        try {
            urlAsString = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Assert.assertTrue((String)("URL should end with: " + classNameAsPath), (boolean)urlAsString.endsWith(classNameAsPath));
        if (urlAsString.startsWith("file:")) {
            return FileSystemPath.existingDir(urlAsString.substring("file:".length(), urlAsString.length() - classNameAsPath.length()));
        }
        if (urlAsString.startsWith("jar:file:")) {
            int n = urlAsString.indexOf(33);
            return FileSystemPath.makeExistingFile(urlAsString.substring("jar:file:".length(), n));
        }
        throw new RuntimeException("unsupported protocol: " + url);
    }

    private static String classToPath(Class type) {
        return type.getName().replace('.', '/') + ".class";
    }

    private FileSystemPath calculatePathToResource(String resource) {
        URL url = this.getClass().getResource(resource);
        Assert.assertNotNull((String)("Not found: " + resource), (Object)url);
        return WARBuilder.calculateDirectory(url, resource);
    }

    public static enum Dispatcher {
        ERROR,
        INCLUDE,
        FORWARD,
        REQUEST;

    }

    private static class FilterDefinition {
        public final String name;
        public final String mapping;
        public final Class filterClass;
        public final Map initParameters;
        public final Set<Dispatcher> dispatchers;

        public FilterDefinition(String name, String mapping, Class filterClass, Map initParameters, Set<Dispatcher> dispatchers) {
            this.name = name;
            this.mapping = mapping;
            this.filterClass = filterClass;
            this.initParameters = initParameters;
            this.dispatchers = dispatchers == null ? Collections.EMPTY_SET : dispatchers;
        }
    }

    private static class ServletDefinition {
        public final String name;
        public final String mapping;
        public final Class servletClass;
        public final Map initParameters;
        public final boolean loadOnStartup;

        public ServletDefinition(String name, String mapping, Class servletClass, Map initParameters, boolean loadOnStartup) {
            this.name = name;
            this.mapping = mapping;
            this.servletClass = servletClass;
            this.initParameters = initParameters;
            this.loadOnStartup = loadOnStartup;
        }
    }

    private static class ResourceDefinition {
        public final File location;
        public final String prefix;
        public final String includes;
        public final String fullpath;

        public ResourceDefinition(File location, String includes, String prefix, String fullpath) {
            this.location = location;
            this.includes = includes;
            this.prefix = prefix;
            this.fullpath = fullpath;
        }
    }
}

