/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.AppServerInfo;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.deployment.AbstractDeploymentTestCase;
import com.tc.test.server.appserver.deployment.DeploymentBuilder;
import com.tc.test.server.appserver.deployment.GenericServer;
import com.tc.test.server.appserver.deployment.ServerManager;
import com.tc.test.server.appserver.deployment.ServerManagerUtil;
import com.tc.test.server.appserver.load.LowMemWorkaround;
import com.tc.text.Banner;
import com.tc.util.TcConfigBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ServerTestSetup
extends TestSetup {
    private final Class testClass;
    private final TcConfigBuilder tcConfigBuilder;
    private ServerManager sm;

    public ServerTestSetup(Class<? extends AbstractDeploymentTestCase> testClass) {
        this(testClass, null);
    }

    public ServerTestSetup(Class<? extends AbstractDeploymentTestCase> testClass, TcConfigBuilder configBuilder) {
        super((Test)new TestSuite(testClass));
        this.testClass = testClass;
        this.tcConfigBuilder = configBuilder == null ? new TcConfigBuilder() : configBuilder;
    }

    protected Class getTestClass() {
        return this.testClass;
    }

    protected TcConfigBuilder getTcConfigBuilder() {
        return this.tcConfigBuilder;
    }

    protected void setUp() throws Exception {
        if (this.shouldDisable()) {
            return;
        }
        super.setUp();
        if (TestConfigObject.getInstance().isExpressModeForAppserver()) {
            Banner.infoBanner((String)"Running appserver in express mode. DSO is disabled");
            GenericServer.setDsoEnabled(false);
        }
        this.getServerManager();
    }

    protected void tearDown() throws Exception {
        if (this.sm != null) {
            ServerManagerUtil.stopAndRelease(this.sm);
        }
    }

    protected ServerManager getServerManager() {
        if (this.sm == null) {
            try {
                this.sm = ServerManagerUtil.startAndBind(this.testClass, this.isWithPersistentStore(), this.getSessionLocking(), this.getSynchronousWrite(), Collections.EMPTY_LIST);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create server manager", e);
            }
        }
        return this.sm;
    }

    public AppServerInfo appServerInfo() {
        return TestConfigObject.getInstance().appServerInfo();
    }

    public DeploymentBuilder makeDeploymentBuilder(String warFileName) {
        return this.getServerManager().makeDeploymentBuilder(warFileName);
    }

    public DeploymentBuilder makeDeploymentBuilder(String warFileName, boolean addExpressConfig) {
        return this.getServerManager().makeDeploymentBuilder(warFileName, addExpressConfig);
    }

    protected boolean isWithPersistentStore() {
        return false;
    }

    public boolean shouldDisable() {
        if (LowMemWorkaround.lessThan2Gb()) {
            Banner.warnBanner((String)"NOT RUNNNING TEST SINCE THIS MACHINE DOES NOT HAVE AT LEAST 2GB MEMORY");
            return true;
        }
        if (!TestConfigObject.getInstance().transparentTestsMode().equals("normal")) {
            Banner.warnBanner((String)"NOT RUNNNING TEST BECAUSE TEST MODE IS NOT 'normal'");
            return true;
        }
        Enumeration e = ((TestSuite)this.fTest).tests();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof AbstractDeploymentTestCase) || !((AbstractDeploymentTestCase)((Object)o)).shouldDisable()) continue;
            return true;
        }
        return false;
    }

    private AbstractDeploymentTestCase[] getTestCases() {
        TestSuite suite = (TestSuite)this.getTest();
        int count = suite.testCount();
        ArrayList<AbstractDeploymentTestCase> rv = new ArrayList<AbstractDeploymentTestCase>();
        for (int i = 0; i < count; ++i) {
            rv.add((AbstractDeploymentTestCase)suite.testAt(i));
        }
        return rv.toArray(new AbstractDeploymentTestCase[0]);
    }

    public final boolean isSessionLockingTrue() {
        return this.queryTestCases(Query.IS_SESSION_LOCKING_TRUE);
    }

    private final Boolean getSessionLocking() {
        return this.queryTestCases(Query.SESSION_LOCKING);
    }

    private final Boolean getSynchronousWrite() {
        return this.queryTestCases(Query.SYNCHRONOUS_WRITE);
    }

    private Boolean queryTestCases(Query query) {
        AbstractDeploymentTestCase[] testCases = this.getTestCases();
        Boolean first = this.queryTestCase(query, testCases[0]);
        for (int i = 1; i < testCases.length; ++i) {
            Boolean next = this.queryTestCase(query, testCases[i]);
            if (first == null && next != null || first != next) {
                throw new AssertionError((Object)("inconsistent results: " + first + " != " + next + " at index " + i));
            }
        }
        return first;
    }

    private Boolean queryTestCase(Query query, AbstractDeploymentTestCase testCase) {
        switch (query) {
            case SYNCHRONOUS_WRITE: {
                return testCase.getSynchronousWrite();
            }
            case SESSION_LOCKING: {
                return testCase.getSessionLocking();
            }
            case IS_SESSION_LOCKING_TRUE: {
                return testCase.isSessionLockingTrue();
            }
        }
        throw new AssertionError((Object)("query: " + (Object)((Object)query)));
    }

    private static enum Query {
        SYNCHRONOUS_WRITE,
        SESSION_LOCKING,
        IS_SESSION_LOCKING_TRUE;

    }
}

