/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.server.appserver.deployment.ServerManager;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerManagerUtil {
    protected static final Log logger = LogFactory.getLog(ServerManagerUtil.class);
    private static ServerManager theServerManager;

    private static synchronized ServerManager start(Class testClass, boolean withPersistentStore, Boolean isSessionLocking, Boolean isSynchronousWrite, Collection extraJvmArgs) throws Exception {
        ServerManager existingServerManager = ServerManagerUtil.getExistingServerManager();
        if (existingServerManager != null) {
            logger.debug((Object)"Using existing ServerManager");
            return existingServerManager;
        }
        logger.debug((Object)"Creating server manager");
        ServerManager serverManager = new ServerManager(testClass, extraJvmArgs, isSessionLocking, isSynchronousWrite);
        serverManager.start(withPersistentStore);
        return serverManager;
    }

    private static synchronized void stop(ServerManager serverManager) {
        ServerManager existingServerManager = ServerManagerUtil.getExistingServerManager();
        if (existingServerManager != null) {
            logger.debug((Object)"Not stopping existing ServerManager");
            return;
        }
        logger.debug((Object)"Stopping ServerManager");
        serverManager.stop();
    }

    private static synchronized ServerManager getExistingServerManager() {
        return theServerManager;
    }

    public static synchronized ServerManager startAndBind(Class testClass, boolean withPersistentStore, Boolean isSessionLocking, Boolean isSynchronousWrite, Collection extraJvmArgs) throws Exception {
        ServerManager sm;
        theServerManager = sm = ServerManagerUtil.start(testClass, withPersistentStore, isSessionLocking, isSynchronousWrite, extraJvmArgs);
        return sm;
    }

    public static synchronized void stopAndRelease(ServerManager sm) {
        theServerManager = null;
        ServerManagerUtil.stop(sm);
    }

    public static synchronized void stopAllWebServers(ServerManager serverManager) {
        ServerManagerUtil.getExistingServerManager().stopAllWebServers();
    }
}

