/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.test.AppServerInfo;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.AppServerFactory;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.ValveDefinition;
import com.tc.test.server.appserver.deployment.DSOServer;
import com.tc.test.server.appserver.deployment.DeploymentBuilder;
import com.tc.test.server.appserver.deployment.FileSystemPath;
import com.tc.test.server.appserver.deployment.GenericServer;
import com.tc.test.server.appserver.deployment.Stoppable;
import com.tc.test.server.appserver.deployment.TempDirectoryUtil;
import com.tc.test.server.appserver.deployment.WARBuilder;
import com.tc.test.server.appserver.deployment.WebApplicationServer;
import com.tc.test.server.util.AppServerUtil;
import com.tc.test.server.util.TimUtil;
import com.tc.test.server.util.Util;
import com.tc.text.Banner;
import com.tc.util.PortChooser;
import com.tc.util.ProductInfo;
import com.tc.util.TcConfigBuilder;
import com.tc.util.runtime.Os;
import com.tc.util.runtime.Vm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.terracotta.modules.tool.exception.ModuleNotFoundException;
import org.terracotta.modules.tool.exception.RemoteIndexIOException;
import org.terracotta.tools.cli.TIMGetTool;

public class ServerManager {
    private static final String EXPRESS_MODE_LOAD_CLASS = "org.terracotta.session.BootStrap";
    private static final String EXPRESS_RUNTIME_LOAD_CLASS = "org.terracotta.express.Client";
    private static final String SESSION_TIM_TESTS_PROPERTIES = "/com/tctest/session-tim/tests.properties";
    private static final TimGetUrls[] TIM_GET_URLS = new TimGetUrls[]{new TimGetUrls("http://nexus.terracotta.lan:8080/content/repositories/terracotta-snapshots/tim-get/3/index.xml.gz", "http://nexus.terracotta.lan:8080/content/repositories/terracotta-snapshots"), new TimGetUrls("http://nexus.terracotta.lan:8080/content/repositories/terracotta-releases/tim-get/3/index.xml.gz", "http://nexus.terracotta.lan:8080/content/repositories/terracotta-releases"), new TimGetUrls("http://nexus.terracotta.lan:8080/content/repositories/terracotta-staging/tim-get/3/index.xml.gz", "http://nexus.terracotta.lan:8080/content/groups/public"), new TimGetUrls("http://www.terracotta.org/download/reflector/snapshots/tim-get/3/index.xml.gz", "http://www.terracotta.org/download/reflector/snapshots"), new TimGetUrls("http://www.terracotta.org/download/reflector/releases/tim-get/3/index.xml.gz", "http://www.terracotta.org/download/reflector/releases")};
    protected static final TCLogger logger = TCLogging.getLogger(ServerManager.class);
    private static int appServerIndex = 0;
    private final boolean DEBUG_MODE = false;
    private List serversToStop = new ArrayList();
    private DSOServer dsoServer;
    private final TestConfigObject config;
    private final AppServerFactory factory;
    private final AppServerInstallation installation;
    private final File sandbox;
    private final File tempDir;
    private final File installDir;
    private final File warDir;
    private final File tcConfigFile;
    private final TcConfigBuilder serverTcConfig = new TcConfigBuilder();
    private final Collection jvmArgs;
    private final boolean useTimGet;
    private final Map<String, String> resolved = Collections.synchronizedMap(new HashMap());
    private static int serverCounter = 0;
    private final Boolean isSynchronousWrite;
    private final Boolean isSessionLocking;

    public ServerManager(Class testClass, Collection extraJvmArgs, Boolean isSessionLocking, Boolean isSynchronousWrite) throws Exception {
        this.isSessionLocking = isSessionLocking;
        this.isSynchronousWrite = isSynchronousWrite;
        this.config = TestConfigObject.getInstance();
        this.factory = AppServerFactory.createFactoryFromProperties();
        this.installDir = this.config.appserverServerInstallDir();
        this.tempDir = TempDirectoryUtil.getTempDirectory(testClass);
        this.tcConfigFile = new File(this.tempDir, "tc-config.xml");
        this.sandbox = AppServerUtil.createSandbox(this.tempDir);
        this.warDir = new File(this.sandbox, "war");
        this.jvmArgs = extraJvmArgs;
        this.installation = AppServerUtil.createAppServerInstallation(this.factory, this.installDir, this.sandbox);
        this.useTimGet = this.config.isExpressModeForAppserver() ? false : this.determineSessionMethod();
        PortChooser pc = new PortChooser();
        this.serverTcConfig.setDsoPort(pc.chooseRandomPort());
        this.serverTcConfig.setJmxPort(pc.chooseRandomPort());
        this.serverTcConfig.setGroupPort(pc.chooseRandomPort());
    }

    private boolean determineSessionMethod() {
        InputStream in = TimUtil.class.getResourceAsStream(SESSION_TIM_TESTS_PROPERTIES);
        if (in == null) {
            Banner.infoBanner((String)"/com/tctest/session-tim/tests.properties not found -- tim.get will be used to resolve container TIM(s)");
            return true;
        }
        return false;
    }

    public void addServerToStop(Stoppable stoppable) {
        this.getServersToStop().add(0, stoppable);
    }

    void stop() {
        logger.info((Object)"Stopping all servers");
        for (Stoppable stoppable : this.getServersToStop()) {
            try {
                if (stoppable.isStopped()) continue;
                logger.debug((Object)("About to stop server: " + stoppable.toString()));
                stoppable.stop();
            }
            catch (Exception e) {
                logger.error((Object)stoppable, (Throwable)e);
            }
        }
        AppServerUtil.shutdownAndArchive(this.sandbox, new File(this.tempDir, "sandbox"));
    }

    void timeout() {
        System.err.println("Test has timed out. Force shutdown and archive...");
        AppServerUtil.forceShutdownAndArchive(this.sandbox, new File(this.tempDir, "sandbox"));
    }

    protected boolean cleanTempDir() {
        return false;
    }

    void start(boolean withPersistentStore) throws Exception {
        this.startDSO(withPersistentStore);
    }

    private void startDSO(boolean withPersistentStore) throws Exception {
        File workDir = new File(this.tempDir, "dso-server-" + serverCounter++);
        workDir.mkdirs();
        this.dsoServer = new DSOServer(withPersistentStore, workDir, this.serverTcConfig);
        if (!(Vm.isIBM() || Os.isMac() && Vm.isJDK14())) {
            this.dsoServer.getJvmArgs().add("-XX:+HeapDumpOnOutOfMemoryError");
        }
        if (!Vm.isIBM()) {
            this.dsoServer.getJvmArgs().add("-verbose:gc");
            if (!Vm.isJRockit()) {
                this.dsoServer.getJvmArgs().add("-XX:+PrintGCDetails");
                this.dsoServer.getJvmArgs().add("-XX:+PrintGCTimeStamps");
            }
            String gcLogSwitch = Vm.isJRockit() ? "verboselog" : "loggc";
            this.dsoServer.getJvmArgs().add("-X" + gcLogSwitch + ":" + new File(workDir, "dso-server-gc.log").getAbsolutePath());
        }
        this.dsoServer.getJvmArgs().add("-Xmx128m");
        Iterator iterator = this.jvmArgs.iterator();
        while (iterator.hasNext()) {
            this.dsoServer.getJvmArgs().add(iterator.next());
        }
        logger.debug((Object)("Starting DSO server with sandbox: " + this.sandbox.getAbsolutePath()));
        this.dsoServer.start();
        this.addServerToStop(this.dsoServer);
    }

    public void restartDSO(boolean withPersistentStore) throws Exception {
        logger.debug((Object)("Restarting DSO server : " + this.dsoServer));
        this.dsoServer.stop();
        this.startDSO(withPersistentStore);
    }

    public WebApplicationServer makeWebApplicationServer(TcConfigBuilder tcConfigBuilder) throws Exception {
        return this.makeWebApplicationServer(tcConfigBuilder, this.config.isExpressModeForAppserver());
    }

    public WebApplicationServer makeWebApplicationServer(TcConfigBuilder tcConfigBuilder, boolean addExpress) throws Exception {
        int i = appServerIndex++;
        GenericServer appServer = new GenericServer(this.config, this.factory, this.installation, this.prepareClientTcConfig(tcConfigBuilder).getTcConfigFile(), i, this.tempDir);
        if (addExpress) {
            this.addExpressModeParams(appServer.getServerParameters());
        }
        this.addServerToStop(appServer);
        return appServer;
    }

    public WebApplicationServer makeWebApplicationServerNoDso() throws Exception {
        GenericServer.setDsoEnabled(false);
        int i = appServerIndex++;
        GenericServer appServer = new GenericServer(this.config, this.factory, this.installation, null, i, this.tempDir);
        if (this.config.isExpressModeForAppserver()) {
            this.addExpressModeParams(appServer.getServerParameters());
        }
        this.addServerToStop(appServer);
        return appServer;
    }

    public FileSystemPath getTcConfigFile(String tcConfigPath) {
        URL url = this.getClass().getResource(tcConfigPath);
        Assert.assertNotNull((String)("could not find: " + tcConfigPath), (Object)url);
        Assert.assertTrue((String)("should be file:" + url.toString()), (boolean)url.toString().startsWith("file:"));
        FileSystemPath pathToTcConfigFile = FileSystemPath.makeExistingFile(url.toString().substring("file:".length()));
        return pathToTcConfigFile;
    }

    private TcConfigBuilder prepareClientTcConfig(TcConfigBuilder clientConfig) throws IOException {
        TcConfigBuilder aCopy = clientConfig.copy();
        aCopy.setTcConfigFile(this.tcConfigFile);
        aCopy.setDsoPort(this.getServerTcConfig().getDsoPort());
        aCopy.setJmxPort(this.getServerTcConfig().getJmxPort());
        if (!this.config.isExpressModeForAppserver()) {
            this.prepareCustomMode(aCopy);
        }
        aCopy.saveToFile();
        return aCopy;
    }

    private void prepareCustomMode(TcConfigBuilder aCopy) {
        if (this.useTimGet) {
            aCopy.addRepository(this.getTimGetModulesDir());
        } else {
            aCopy.addRepository("%(user.home)/.m2/repository");
        }
        int appId = this.config.appServerId();
        switch (appId) {
            case 4: {
                AppServerInfo info = this.config.appServerInfo();
                String major = info.getMajor();
                if (major.equals("v1")) {
                    aCopy.addModule(TimUtil.GLASSFISH_V1, this.resolveContainerTIM(TimUtil.GLASSFISH_V1));
                    break;
                }
                if (major.equals("v2")) {
                    aCopy.addModule(TimUtil.GLASSFISH_V2, this.resolveContainerTIM(TimUtil.GLASSFISH_V2));
                    break;
                }
                if (major.equals("v3")) {
                    aCopy.addModule(TimUtil.GLASSFISH_V3, this.resolveContainerTIM(TimUtil.GLASSFISH_V3));
                    break;
                }
                throw new RuntimeException("unexpected version: " + info);
            }
            case 5: {
                AppServerInfo info = this.config.appServerInfo();
                String major = info.getMajor();
                String minor = info.getMinor();
                if (major.equals("6") || minor.startsWith("1.")) {
                    aCopy.addModule(TimUtil.JETTY_6_1, this.resolveContainerTIM(TimUtil.JETTY_6_1));
                    break;
                }
                if (major.equals("7")) break;
                throw new RuntimeException("unexpected version: " + info);
            }
            case 3: {
                AppServerInfo info = this.config.appServerInfo();
                String major = info.getMajor();
                String minor = info.getMinor();
                if (major.equals("1") && minor.startsWith("0.")) {
                    aCopy.addModule(TimUtil.WASCE_1_0, this.resolveContainerTIM(TimUtil.WASCE_1_0));
                    break;
                }
                throw new RuntimeException("unexpected version: " + info);
            }
            case 0: {
                AppServerInfo info = this.config.appServerInfo();
                String major = info.getMajor();
                if (major.equals("9")) {
                    aCopy.addModule(TimUtil.WEBLOGIC_9, this.resolveContainerTIM(TimUtil.WEBLOGIC_9));
                    break;
                }
                if (major.equals("10")) {
                    aCopy.addModule(TimUtil.WEBLOGIC_10, this.resolveContainerTIM(TimUtil.WEBLOGIC_10));
                    break;
                }
                throw new RuntimeException("unexpected major version: " + info);
            }
            case 1: {
                AppServerInfo info = this.config.appServerInfo();
                String major = info.getMajor();
                String minor = info.getMinor();
                if (major.equals("7")) break;
                if (major.equals("6")) {
                    if (minor.startsWith("0.")) {
                        aCopy.addModule(TimUtil.JBOSS_6_0, this.resolveContainerTIM(TimUtil.JBOSS_6_0));
                        break;
                    }
                    throw new RuntimeException("unexpected version: " + info);
                }
                if (major.equals("5")) {
                    if (minor.startsWith("1.")) {
                        aCopy.addModule(TimUtil.JBOSS_5_1, this.resolveContainerTIM(TimUtil.JBOSS_5_1));
                        break;
                    }
                    throw new RuntimeException("unexpected version: " + info);
                }
                if (major.equals("4")) {
                    if (minor.startsWith("0.")) {
                        aCopy.addModule(TimUtil.JBOSS_4_0, this.resolveContainerTIM(TimUtil.JBOSS_4_0));
                        break;
                    }
                    if (minor.startsWith("2.")) {
                        aCopy.addModule(TimUtil.JBOSS_4_2, this.resolveContainerTIM(TimUtil.JBOSS_4_2));
                        break;
                    }
                    throw new RuntimeException("unexpected version: " + info);
                }
                if (major.equals("3")) {
                    if (minor.startsWith("2.")) {
                        aCopy.addModule(TimUtil.JBOSS_3_2, this.resolveContainerTIM(TimUtil.JBOSS_3_2));
                        break;
                    }
                    throw new RuntimeException("unexpected version: " + info);
                }
                throw new RuntimeException("unexpected major version: " + info);
            }
            case 2: {
                AppServerInfo info = this.config.appServerInfo();
                String major = info.getMajor();
                String minor = info.getMinor();
                if (major.equals("5")) {
                    if (minor.startsWith("0.")) {
                        aCopy.addModule(TimUtil.TOMCAT_5_0, this.resolveContainerTIM(TimUtil.TOMCAT_5_0));
                        break;
                    }
                    if (minor.startsWith("5.")) {
                        aCopy.addModule(TimUtil.TOMCAT_5_5, this.resolveContainerTIM(TimUtil.TOMCAT_5_5));
                        break;
                    }
                    throw new RuntimeException("unexpected 5.x version: " + info);
                }
                if (major.equals("6")) {
                    if (minor.startsWith("0.")) {
                        aCopy.addModule(TimUtil.TOMCAT_6_0, this.resolveContainerTIM(TimUtil.TOMCAT_6_0));
                        break;
                    }
                    throw new RuntimeException("unexpected 6.x version: " + info);
                }
                if (major.equals("7")) {
                    if (minor.startsWith("0.")) {
                        aCopy.addModule(TimUtil.TOMCAT_7_0, this.resolveContainerTIM(TimUtil.TOMCAT_7_0));
                        break;
                    }
                    throw new RuntimeException("unexpected 7.x version: " + info);
                }
                throw new RuntimeException("unexpected major version: " + info);
            }
            case 6: {
                AppServerInfo info = this.config.appServerInfo();
                String major = info.getMajor();
                String minor = info.getMinor();
                if (major.equals("3")) {
                    if (minor.startsWith("0.") || minor.startsWith("1.")) {
                        aCopy.addModule(TimUtil.RESIN_3_1, this.resolveContainerTIM(TimUtil.RESIN_3_1));
                        break;
                    }
                    throw new RuntimeException("unexpected minor version: " + info);
                }
                throw new RuntimeException("unexpected major version: " + info);
            }
        }
    }

    void setServersToStop(List serversToStop) {
        this.serversToStop = serversToStop;
    }

    List getServersToStop() {
        return this.serversToStop;
    }

    public DeploymentBuilder makeDeploymentBuilder(String warFileName) {
        return this.makeDeploymentBuilder(warFileName, this.config.isExpressModeForAppserver());
    }

    public DeploymentBuilder makeDeploymentBuilder(String warFileName, boolean addExpressConfig) {
        WARBuilder builder = new WARBuilder(warFileName, this.warDir, this.config, addExpressConfig);
        if (addExpressConfig) {
            this.addExpressModeWarConfig(builder);
        }
        if (this.isJboss7x()) {
            if (addExpressConfig) {
                builder.addFileAsResource(this.makeJboss7WebXml(this.config.appServerInfo()), "WEB-INF");
            } else {
                builder.addFileAsResource(this.makeEmptyJboss7WebXml(), "WEB-INF");
            }
        }
        return builder;
    }

    public void stopAllWebServers() {
        for (Stoppable stoppable : this.getServersToStop()) {
            try {
                if (stoppable instanceof DSOServer || stoppable.isStopped()) continue;
                stoppable.stop();
            }
            catch (Exception e) {
                logger.error((Object)("Unable to stop server: " + stoppable), (Throwable)e);
            }
        }
    }

    public TestConfigObject getTestConfig() {
        return this.config;
    }

    public File getSandbox() {
        return this.sandbox;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public TcConfigBuilder getServerTcConfig() {
        return this.serverTcConfig;
    }

    public File getTcConfigFile() {
        return this.tcConfigFile;
    }

    public String toString() {
        return "ServerManager{dsoServer=" + this.dsoServer.toString() + ", sandbox=" + this.sandbox.getAbsolutePath() + ", warDir=" + this.warDir.getAbsolutePath() + ", jvmArgs=" + this.jvmArgs + '}';
    }

    private String resolveContainerTIM(String name) {
        String ver = this.resolved.get(name);
        if (ver != null) {
            return ver;
        }
        ver = this.internalResolve(name);
        this.resolved.put(name, ver);
        return ver;
    }

    private String internalResolve(String name) {
        if (this.useTimGet) {
            try {
                return this.runTimGet(name);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        Properties props = new Properties();
        try {
            props.load(TimUtil.class.getResourceAsStream(SESSION_TIM_TESTS_PROPERTIES));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props.getProperty("version");
    }

    private String getTimGetModulesDir() {
        File sandoxModules = new File(this.sandbox, "modules");
        if (!sandoxModules.exists() && !sandoxModules.mkdirs()) {
            throw new RuntimeException("cannot create " + sandoxModules);
        }
        return sandoxModules.getAbsolutePath();
    }

    private String runTimGet(String name) throws Exception {
        String mavenArtifactsVersion = ProductInfo.getInstance().mavenArtifactsVersion();
        if (mavenArtifactsVersion.equals("[unknown]")) {
            throw new AssertionError((Object)("Refusing to run tim-get for artifactsVersion: " + mavenArtifactsVersion));
        }
        for (TimGetUrls urls : TIM_GET_URLS) {
            try {
                Properties timgetProps = new Properties();
                timgetProps.setProperty("org.terracotta.modules.tool.tcVersion", ProductInfo.getInstance().mavenArtifactsVersion());
                timgetProps.setProperty("org.terracotta.modules.tool.includeSnapshots", "true");
                timgetProps.setProperty("org.terracotta.modules.tool.modulesDir", this.getTimGetModulesDir());
                timgetProps.setProperty("org.terracotta.modules.tool.cache", this.sandbox.getAbsolutePath());
                timgetProps.setProperty("org.terracotta.modules.tool.dataFileUrl", urls.getUrl());
                timgetProps.setProperty("org.terracotta.modules.tool.relativeUrlBase", urls.getRelativeUrlBase());
                timgetProps.setProperty("org.terracotta.modules.tool.dataCacheExpirationInSeconds", "0");
                new TIMGetTool("install " + name + " -u --no-verify", timgetProps);
                File src = new File(this.getTimGetModulesDir() + "/org/terracotta/modules/" + name);
                if (!src.isDirectory()) {
                    throw new RuntimeException(src + " is not a directory");
                }
                String[] entries = src.list();
                if (entries.length != 1) {
                    throw new RuntimeException("unexpected directory contents [" + Arrays.asList(entries) + "] in " + src);
                }
                return entries[0];
            }
            catch (RemoteIndexIOException e) {
                Banner.infoBanner((String)("Repository location not available [" + urls.getUrl() + "] for tim-get, moving on to the next one"));
            }
            catch (ModuleNotFoundException e) {
                Banner.infoBanner((String)("Module " + name + " couldn't be found on this repo " + urls.getUrl() + ", trying the next one"));
            }
            catch (Exception e) {
                Banner.errorBanner((String)("Unexpected error using url [" + urls.getUrl() + "] for tim-get, trying the next one"));
                e.printStackTrace();
            }
        }
        throw new RuntimeException("Unable to resolve TIM with name " + name + " from any repository using artifactVersion " + mavenArtifactsVersion);
    }

    private ValveDefinition makeValveDef() {
        ValveDefinition valve = new ValveDefinition(Mappings.getClassForAppServer(this.config.appServerInfo()));
        valve.setExpressVal(true);
        for (Map.Entry<String, String> attr : this.getConfigAttributes().entrySet()) {
            valve.setAttribute(attr.getKey(), attr.getValue());
        }
        return valve;
    }

    private String getTcConfigUrl() {
        return "localhost:" + this.serverTcConfig.getDsoPort();
    }

    private boolean useFilter() {
        int appId = this.config.appServerId();
        return appId == 0 || appId == 5 || appId == 7;
    }

    private boolean isJboss7x() {
        return this.config.appServerId() == 1 && this.config.appServerInfo().getMajor().equals("7");
    }

    private Map<String, String> getConfigAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("tcConfigUrl", this.getTcConfigUrl());
        System.out.println("XXX: sessionLocking: " + this.isSessionLocking);
        System.out.println("XXX: synchronousWrite: " + this.isSynchronousWrite);
        if (this.isSessionLocking != null) {
            attrs.put("sessionLocking", this.isSessionLocking.toString());
        }
        if (this.isSynchronousWrite != null) {
            attrs.put("synchronousWrite", this.isSynchronousWrite.toString());
        }
        return attrs;
    }

    private void addExpressModeParams(StandardAppServerParameters params) {
        this.setupExpressJarContaining(params, EXPRESS_MODE_LOAD_CLASS);
        this.setupExpressJarContaining(params, EXPRESS_RUNTIME_LOAD_CLASS);
        if (this.config.appServerId() == 2) {
            params.addValve(this.makeValveDef());
        }
    }

    private void setupExpressJarContaining(StandardAppServerParameters params, String className) {
        File expressJar;
        try {
            expressJar = new File(Util.jarFor(Class.forName(className)));
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException("Couldn't load class " + className + " to look up the jar file", e1);
        }
        File sandBoxArtifact = new File(this.tempDir, expressJar.getName());
        if (!sandBoxArtifact.exists()) {
            try {
                FileUtils.copyFile((File)expressJar, (File)sandBoxArtifact);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        params.addTomcatServerJar(sandBoxArtifact.getAbsolutePath());
    }

    private void addExpressModeWarConfig(DeploymentBuilder builder) {
        if (this.useFilter()) {
            Class<?> filter;
            try {
                builder.addDirectoryOrJARContainingClass(Class.forName(EXPRESS_MODE_LOAD_CLASS));
                builder.addDirectoryOrJARContainingClass(Class.forName(EXPRESS_RUNTIME_LOAD_CLASS));
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
            Map<String, String> filterConfig = this.getConfigAttributes();
            try {
                filter = Class.forName(Mappings.getClassForAppServer(this.config.appServerInfo()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            builder.addFilter("terracotta-filter", "/*", filter, filterConfig, EnumSet.allOf(WARBuilder.Dispatcher.class));
        }
        builder.addFileAsResource(this.makeJbossContextXml(this.config.appServerInfo()), "WEB-INF");
        if (this.isJboss7x()) {
            try {
                builder.addDirectoryOrJARContainingClass(Class.forName(EXPRESS_MODE_LOAD_CLASS));
                builder.addDirectoryOrJARContainingClass(Class.forName(EXPRESS_RUNTIME_LOAD_CLASS));
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private File makeJbossContextXml(AppServerInfo appServerInfo) {
        File tmp = new File(this.sandbox, "context.xml");
        String xml = "";
        xml = xml + "<Context>\n";
        xml = xml + "  " + this.makeValveDef().toXml() + "\n";
        xml = xml + "</Context>\n";
        return this.writeJbossXml(xml, tmp);
    }

    private File makeJboss7WebXml(AppServerInfo appServerInfo) {
        File tmp = new File(this.sandbox, "jboss-web.xml");
        String xml = "";
        xml = xml + "<jboss-web>\n";
        xml = xml + "  <valve>\n";
        xml = xml + "    <class-name>org.terracotta.session.TerracottaJboss7xSessionValve</class-name>\n";
        for (Map.Entry<String, String> attr : this.getConfigAttributes().entrySet()) {
            xml = xml + "    <param>\n";
            xml = xml + "      <param-name>" + attr.getKey() + "</param-name>\n";
            xml = xml + "      <param-value>" + attr.getValue() + "</param-value>\n";
            xml = xml + "    </param>\n";
        }
        xml = xml + "  </valve>\n";
        xml = xml + "</jboss-web>\n";
        return this.writeJbossXml(xml, tmp);
    }

    private File makeEmptyJboss7WebXml() {
        File tmp = new File(this.sandbox, "jboss-web.xml");
        String xml = "";
        xml = xml + "<jboss-web>\n";
        xml = xml + "</jboss-web>\n";
        return this.writeJbossXml(xml, tmp);
    }

    private File writeJbossXml(String xml, File target) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target);
            out.write(xml.getBytes());
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return target;
    }

    private static class Mappings {
        private static final Map<String, String> mappings = new HashMap<String, String>();

        private Mappings() {
        }

        static String getClassForAppServer(AppServerInfo info) {
            for (String key : mappings.keySet()) {
                if (!info.toString().startsWith(key)) continue;
                return "org.terracotta.session." + mappings.get(key);
            }
            throw new AssertionError((Object)("no mapping for " + info));
        }

        static {
            mappings.put("jboss-4.0.", "TerracottaJboss40xSessionValve");
            mappings.put("jboss-4.2.", "TerracottaJboss42xSessionValve");
            mappings.put("jboss-5.1.", "TerracottaJboss51xSessionValve");
            mappings.put("jboss-6.0.", "TerracottaJboss60xSessionValve");
            mappings.put("jboss-7.1.", "TerracottaJboss7xSessionValve");
            mappings.put("weblogic-9.", "TerracottaWeblogic9xSessionFilter");
            mappings.put("weblogic-10.", "TerracottaWeblogic10xSessionFilter");
            mappings.put("jetty-6.1.", "TerracottaJetty61xSessionFilter");
            mappings.put("jetty-7.4.", "TerracottaJetty74xSessionFilter");
            mappings.put("tomcat-5.0.", "TerracottaTomcat50xSessionValve");
            mappings.put("tomcat-5.5.", "TerracottaTomcat55xSessionValve");
            mappings.put("tomcat-6.0.", "TerracottaTomcat60xSessionValve");
            mappings.put("tomcat-7.0.", "TerracottaTomcat70xSessionValve");
            mappings.put("websphere-6.1.", "TerracottaWebsphere61xSessionFilter");
            mappings.put("websphere-7.0.", "TerracottaWebsphere70xSessionFilter");
        }
    }

    private static class TimGetUrls {
        private final String url;
        private final String relativeUrlBase;

        public TimGetUrls(String url, String relativeUrlBase) {
            this.url = url;
            this.relativeUrlBase = relativeUrlBase;
        }

        public String getUrl() {
            return this.url;
        }

        public String getRelativeUrlBase() {
            return this.relativeUrlBase;
        }
    }
}

