/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.server.appserver.deployment.FileSystemPath;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.codehaus.cargo.util.AntUtils;

public class JARBuilder {
    private static final Log logger = LogFactory.getLog(JARBuilder.class);
    private FileSystemPath jarDirectoryPath;
    private String jarFileName;
    private Set classDirectories = new HashSet();
    private Set libs = new HashSet();
    private List resources = new ArrayList();
    private final FileSystemPath tempDirPath;

    public JARBuilder(String warFileName, File tempDir) {
        this.jarFileName = warFileName;
        this.tempDirPath = new FileSystemPath(tempDir);
    }

    public JARBuilder addClassesDirectory(FileSystemPath path) {
        this.classDirectories.add(path);
        return this;
    }

    public void finish() throws Exception {
        FileSystemPath jarFile = this.makejarFileName();
        logger.debug((Object)("Creating jar file: " + jarFile));
        jarFile.delete();
        Jar jarTask = (Jar)new AntUtils().createAntTask("jar");
        jarTask.setUpdate(false);
        Zip.Duplicate df = new Zip.Duplicate();
        df.setValue("preserve");
        jarTask.setDuplicate(df);
        jarTask.setDestFile(jarFile.getFile());
        this.addClassesDirectories(jarTask);
        this.addLibs(jarTask);
        this.addResources(jarTask);
        jarTask.execute();
    }

    private FileSystemPath makejarFileName() {
        File f = new File(this.jarFileName);
        if (f.isAbsolute()) {
            return FileSystemPath.makeNewFile(this.jarFileName);
        }
        return this.tempDirPath.file(this.jarFileName);
    }

    private void addLibs(Jar jarTask) {
        for (FileSystemPath lib : this.libs) {
            ZipFileSet zipFileSet = new ZipFileSet();
            zipFileSet.setFile(lib.getFile());
            jarTask.addZipfileset(zipFileSet);
        }
    }

    private void addClassesDirectories(Jar jarTask) {
        for (FileSystemPath path : this.classDirectories) {
            ZipFileSet zipFileSet = new ZipFileSet();
            zipFileSet.setDir(path.getFile());
            jarTask.addZipfileset(zipFileSet);
        }
    }

    private void addResources(Jar jarTask) {
        for (ResourceDefinition definition : this.resources) {
            ZipFileSet zipfileset = new ZipFileSet();
            zipfileset.setDir(definition.location);
            zipfileset.setIncludes(definition.includes);
            if (definition.prefix != null) {
                zipfileset.setPrefix(definition.prefix);
            }
            if (definition.fullpath != null) {
                zipfileset.setFullpath(definition.fullpath);
            }
            jarTask.addZipfileset(zipfileset);
        }
    }

    public JARBuilder addClassesDirectory(String directory) {
        return this.addClassesDirectory(FileSystemPath.existingDir(directory));
    }

    void createJarDirectory() {
        this.jarDirectoryPath = this.tempDirPath.mkdir("tempjar");
        this.jarDirectoryPath.mkdir("META-INF");
    }

    public JARBuilder addDirectoryOrJARContainingClass(Class type) {
        return this.addDirectoryOrJar(JARBuilder.calculatePathToClass(type));
    }

    public JARBuilder addDirectoryContainingResource(String resource) {
        return this.addDirectoryOrJar(this.calculatePathToResource(resource));
    }

    public JARBuilder addResource(String location, String includes, String prefix) {
        FileSystemPath path = this.getResourceDirPath(location, includes);
        this.resources.add(new ResourceDefinition(path.getFile(), includes, prefix, null));
        return this;
    }

    public JARBuilder addResourceFullpath(String location, String includes, String fullpath) {
        FileSystemPath path = this.getResourceDirPath(location, includes);
        this.resources.add(new ResourceDefinition(path.getFile(), includes, null, fullpath));
        return this;
    }

    private FileSystemPath getResourceDirPath(String location, String includes) {
        String resource = location + "/" + includes;
        URL url = this.getClass().getResource(resource);
        Assert.assertNotNull((String)("Not found: " + resource), (Object)url);
        FileSystemPath path = JARBuilder.calculateDirectory(url, includes);
        return path;
    }

    private JARBuilder addDirectoryOrJar(FileSystemPath path) {
        if (path.isDirectory()) {
            this.classDirectories.add(path);
        } else {
            this.libs.add(path);
        }
        return this;
    }

    public static FileSystemPath calculatePathToClass(Class type) {
        URL url = type.getResource("/" + JARBuilder.classToPath(type));
        Assert.assertNotNull((String)("Not found: " + type), (Object)url);
        FileSystemPath filepath = JARBuilder.calculateDirectory(url, "/" + JARBuilder.classToPath(type));
        return filepath;
    }

    public static FileSystemPath calculatePathToClass(Class type, String pathString) {
        String pathSeparator = System.getProperty("path.separator");
        String[] tokens = pathString.split(pathSeparator);
        URL[] urls = new URL[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.startsWith("/")) {
                token = "/" + token;
            }
            URL u = null;
            try {
                u = token.endsWith(".jar") ? new URL("jar", "", "file:/" + token + "!/") : new URL("file", "", token + "/");
                urls[i] = u;
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        URL url = new URLClassLoader(urls, null).getResource(JARBuilder.classToPath(type));
        Assert.assertNotNull((String)("Not found: " + type), (Object)url);
        FileSystemPath filepath = JARBuilder.calculateDirectory(url, "/" + JARBuilder.classToPath(type));
        return filepath;
    }

    public static FileSystemPath calculateDirectory(URL url, String classNameAsPath) {
        String urlAsString = null;
        try {
            urlAsString = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Assert.assertTrue((String)("URL should end with: " + classNameAsPath), (boolean)urlAsString.endsWith(classNameAsPath));
        if (urlAsString.startsWith("file:")) {
            return FileSystemPath.existingDir(urlAsString.substring("file:".length(), urlAsString.length() - classNameAsPath.length()));
        }
        if (urlAsString.startsWith("jar:file:")) {
            int n = urlAsString.indexOf(33);
            return FileSystemPath.makeExistingFile(urlAsString.substring("jar:file:".length(), n));
        }
        throw new RuntimeException("unsupported protocol: " + url);
    }

    private static String classToPath(Class type) {
        return type.getName().replace('.', '/') + ".class";
    }

    private FileSystemPath calculatePathToResource(String resource) {
        URL url = this.getClass().getResource(resource);
        Assert.assertNotNull((String)("Not found: " + resource), (Object)url);
        return JARBuilder.calculateDirectory(url, resource);
    }

    private static class ResourceDefinition {
        public final File location;
        public final String prefix;
        public final String includes;
        public final String fullpath;

        public ResourceDefinition(File location, String includes, String prefix, String fullpath) {
            this.location = location;
            this.includes = includes;
            this.prefix = prefix;
            this.fullpath = fullpath;
        }
    }
}

