/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import com.tc.test.JMXUtils;
import com.tc.test.TestConfigObject;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AppServer;
import com.tc.test.server.appserver.AppServerFactory;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.deployment.AbstractStoppable;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.test.server.appserver.deployment.ProxyBuilder;
import com.tc.test.server.appserver.deployment.Server;
import com.tc.test.server.appserver.deployment.WebApplicationServer;
import com.tc.test.server.util.AppServerUtil;
import com.tc.text.Banner;
import com.tc.util.StringUtil;
import com.tc.util.runtime.Os;
import com.tc.util.runtime.ThreadDump;
import com.tc.util.runtime.Vm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;
import org.springframework.remoting.rmi.RmiServiceExporter;
import org.xml.sax.SAXException;

public class GenericServer
extends AbstractStoppable
implements WebApplicationServer {
    private static final String ENABLED_DSO_PROPERTY = "tc.tests.info.appserver.dso.enabled";
    private static final Log LOG = LogFactory.getLog(GenericServer.class);
    private static final String SERVER = "server_";
    private static final boolean GC_LOGGING = true;
    private static final boolean ENABLE_DEBUGGER = Boolean.getBoolean(GenericServer.class.getName() + ".ENABLE_DEBUGGER");
    private static final ThreadLocal dsoEnabled = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.valueOf(TestConfigObject.getInstance().getProperty(GenericServer.ENABLED_DSO_PROPERTY, "true"));
        }
    };
    public static boolean USE_DEFAULT_LICENSE_KEY = true;
    private final int jmxRemotePort;
    private final int rmiRegistryPort;
    private final AppServerFactory factory;
    private AppServer server;
    private final StandardAppServerParameters parameters;
    private ServerResult result;
    private final AppServerInstallation installation;
    private final Map proxyBuilderMap = new HashMap();
    private ProxyBuilder proxyBuilder = null;
    private final File workingDir;
    private final String serverInstanceName;
    private final File tcConfigFile;
    private final int appId;

    public GenericServer(TestConfigObject config, AppServerFactory factory, AppServerInstallation installation, File tcConfigFile, int serverId, File tempDir) throws Exception {
        String productKey;
        String[] params;
        this.factory = factory;
        this.installation = installation;
        this.rmiRegistryPort = AppServerUtil.getPort();
        this.jmxRemotePort = AppServerUtil.getPort();
        this.serverInstanceName = SERVER + serverId;
        this.parameters = (StandardAppServerParameters)factory.createParameters(this.serverInstanceName);
        this.workingDir = new File(installation.sandboxDirectory(), this.serverInstanceName);
        this.tcConfigFile = tcConfigFile;
        File bootJarFile = new File(config.normalBootJar());
        if (GenericServer.dsoEnabled()) {
            this.parameters.appendSysProp("tc.base-dir", System.getProperty("tc.base-dir"));
            this.parameters.appendSysProp("com.tc.l1.modules.repositories", System.getProperty("com.tc.l1.modules.repositories"));
            this.parameters.appendSysProp("tc.config", this.tcConfigFile.getAbsolutePath());
            this.parameters.appendJvmArgs("-Xbootclasspath/p:" + bootJarFile.getAbsolutePath());
            this.parameters.appendSysProp("tc.classpath", this.writeTerracottaClassPathFile());
        } else {
            System.out.println("XXX: DSO is disabled, not adding bootjar");
        }
        if (!(Vm.isIBM() || Os.isMac() && Vm.isJDK14())) {
            this.parameters.appendJvmArgs("-XX:+HeapDumpOnOutOfMemoryError");
        }
        this.appId = config.appServerId();
        if (this.appId != 4 && this.appId != 1) {
            this.parameters.appendSysProp("com.sun.management.jmxremote");
            this.parameters.appendSysProp("com.sun.management.jmxremote.authenticate", false);
            this.parameters.appendSysProp("com.sun.management.jmxremote.ssl", false);
            this.parameters.appendSysProp("com.sun.management.jmxremote.port", this.jmxRemotePort);
        }
        this.parameters.appendSysProp("com.tc.session.debug.sessions", true);
        this.parameters.appendSysProp("rmi.registry.port", this.rmiRegistryPort);
        for (String param : params = new String[]{"tc.classloader.writeToDisk", "tc.objectmanager.dumpHierarchy", "aspectwerkz.deployment.info", "aspectwerkz.details", "aspectwerkz.gen.closures", "aspectwerkz.dump.pattern", "aspectwerkz.dump.closures", "aspectwerkz.dump.factories", "aspectwerkz.aspectmodules"}) {
            if (!Boolean.getBoolean(param)) continue;
            this.parameters.appendSysProp(param, true);
        }
        this.enableDebug(serverId);
        switch (this.appId) {
            case 1: 
            case 2: {
                this.parameters.appendJvmArgs("-Djvmroute=" + this.serverInstanceName);
                break;
            }
            case 7: {
                this.parameters.appendSysProp("javax.management.builder.initial", "");
            }
        }
        if (!Vm.isJRockit()) {
            this.parameters.appendJvmArgs("-XX:MaxPermSize=192m");
        }
        this.parameters.appendJvmArgs("-Xms128m -Xmx256m");
        if (Os.isUnix() && new File("/dev/urandom").exists()) {
            this.parameters.appendSysProp("java.security.egd", "file:/dev/./urandom");
        }
        if (TestConfigObject.getInstance().isSpringTest()) {
            LOG.debug((Object)"Creating proxy for Spring test...");
            this.proxyBuilderMap.put(RmiServiceExporter.class, new RMIProxyBuilder());
            this.proxyBuilderMap.put(HttpInvokerServiceExporter.class, new HttpInvokerProxyBuilder());
        }
        if (USE_DEFAULT_LICENSE_KEY && (productKey = config.getProperty("com.tc.productkey.path")) != null) {
            System.out.println("XXX: adding license key to appserver: " + productKey);
            this.parameters.appendSysProp("com.tc.productkey.path", productKey);
        }
    }

    public static boolean dsoEnabled() {
        return (Boolean)dsoEnabled.get();
    }

    public static void setDsoEnabled(boolean b) {
        dsoEnabled.set(b);
    }

    @Override
    public StandardAppServerParameters getServerParameters() {
        return this.parameters;
    }

    @Override
    public int getPort() {
        if (this.result == null) {
            throw new IllegalStateException("Server has not started.");
        }
        return this.result.serverPort();
    }

    private void enableDebug(int serverId) {
        if (!Vm.isIBM() && this.appId != 7) {
            this.parameters.appendJvmArgs("-verbose:gc");
            if (!Vm.isJRockit()) {
                this.parameters.appendJvmArgs("-XX:+PrintGCDetails");
                this.parameters.appendJvmArgs("-XX:+PrintGCTimeStamps");
            }
            String gcLogSwitch = Vm.isJRockit() ? "verboselog" : "loggc";
            this.parameters.appendJvmArgs("-X" + gcLogSwitch + ":" + new File(this.installation.sandboxDirectory(), this.serverInstanceName + "-gc.log").getAbsolutePath());
        }
        if (ENABLE_DEBUGGER) {
            int debugPort = 8000 + serverId;
            if (this.appId == 7) {
                this.parameters.appendJvmArgs("-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort + " -Djava.compiler=NONE");
            } else {
                this.parameters.appendJvmArgs("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort);
            }
            this.parameters.appendSysProp("aspectwerkz.transform.verbose", true);
            this.parameters.appendSysProp("aspectwerkz.transform.details", true);
            Banner.warnBanner((String)("Waiting for debugger to connect on port " + debugPort));
        }
    }

    @Override
    public Object getProxy(Class serviceType, String url) throws Exception {
        if (this.proxyBuilder != null) {
            return this.proxyBuilder.createProxy(serviceType, url, null);
        }
        HashMap<String, Class<RmiServiceExporter>> initCtx = new HashMap<String, Class<RmiServiceExporter>>();
        initCtx.put("exporter-type", RmiServiceExporter.class);
        return this.getProxy(serviceType, url, initCtx);
    }

    @Override
    public Object getProxy(Class serviceType, String url, Map initialContext) throws Exception {
        Class exporterClass = (Class)initialContext.get("exporter-type");
        this.proxyBuilder = (ProxyBuilder)this.proxyBuilderMap.get(exporterClass);
        return this.proxyBuilder.createProxy(serviceType, url, initialContext);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws Exception {
        JMXConnector jmxConnectorProxy = JMXUtils.getJMXConnector((String)"localhost", (int)this.jmxRemotePort);
        return jmxConnectorProxy.getMBeanServerConnection();
    }

    @Override
    public WebApplicationServer addWarDeployment(Deployment warDeployment, String context) {
        this.parameters.addDeployment(context, warDeployment);
        return this;
    }

    @Override
    public WebApplicationServer addEarDeployment(Deployment earDeployment) {
        this.parameters.addDeployment("", earDeployment);
        return this;
    }

    @Override
    protected void doStart() throws Exception {
        try {
            this.result = this.getAppServer().start(this.parameters);
        }
        catch (Exception e) {
            this.dumpThreadsAndRethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpThreadsAndRethrow(Exception e) throws Exception {
        try {
            ThreadDump.dumpAllJavaProcesses((int)3, (long)1000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            throw e;
        }
    }

    @Override
    protected void doStop() throws Exception {
        try {
            this.server.stop(this.parameters);
        }
        catch (Exception e) {
            this.dumpThreadsAndRethrow(e);
        }
    }

    @Override
    public WebResponse ping(String url) throws MalformedURLException, IOException, SAXException {
        return this.ping(url, new WebConversation());
    }

    @Override
    public WebResponse ping(String url, WebConversation wc) throws MalformedURLException, IOException, SAXException {
        String fullURL = "http://localhost:" + this.result.serverPort() + url;
        LOG.debug((Object)("Getting page: " + fullURL));
        wc.setExceptionsThrownOnErrorStatus(false);
        WebResponse response = wc.getResponse(fullURL);
        if (response.getResponseCode() != 200) {
            throw new RuntimeException(this.htmlToText(response.getText()));
        }
        LOG.debug((Object)("Got page: " + fullURL));
        return response;
    }

    private String htmlToText(String html) {
        String text = html.replaceAll("\\</?br/?>", StringUtil.LINE_SEPARATOR);
        text = text.replaceAll("\\</?p/?>", StringUtil.LINE_SEPARATOR);
        text = text.replaceAll("\\</h\\d+>", StringUtil.LINE_SEPARATOR);
        text = text.replaceAll("\\<[^>]*>", "");
        return text;
    }

    private String writeTerracottaClassPathFile() {
        String string;
        FileOutputStream fos = null;
        try {
            File tempFile = new File(this.installation.sandboxDirectory(), "tc-classpath." + this.parameters.instanceName());
            fos = new FileOutputStream(tempFile);
            String[] paths = System.getProperty("java.class.path").split(File.pathSeparator);
            StringBuffer cp = new StringBuffer();
            for (String path : paths) {
                if (path.endsWith("jboss-jmx-4.0.5.jar")) continue;
                cp.append(path).append(File.pathSeparatorChar);
            }
            fos.write(cp.toString().getBytes());
            string = tempFile.toURI().toString();
        }
        catch (IOException ioe) {
            try {
                throw new AssertionError((Object)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return string;
    }

    @Override
    public Server restart() throws Exception {
        this.stop();
        this.start();
        return this;
    }

    public String toString() {
        return "Generic Server" + (this.result != null ? "; port:" + this.result.serverPort() : "");
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public AppServer getAppServer() {
        if (this.server == null) {
            this.server = this.factory.createAppServer(this.installation);
        }
        return this.server;
    }

    @Override
    public File getTcConfigFile() {
        return this.tcConfigFile;
    }

    public class HttpInvokerProxyBuilder
    implements ProxyBuilder {
        private HttpClient client;

        @Override
        public Object createProxy(Class serviceType, String url, Map initialContext) throws Exception {
            CommonsHttpInvokerRequestExecutor executor;
            String serviceURL = "http://localhost:" + GenericServer.this.result.serverPort() + "/" + url;
            LOG.debug((Object)("Getting proxy for: " + serviceURL));
            HttpInvokerProxyFactoryBean prfb = new HttpInvokerProxyFactoryBean();
            prfb.setServiceUrl(serviceURL);
            prfb.setServiceInterface(serviceType);
            if (initialContext != null) {
                this.client = (HttpClient)initialContext.get("http-client");
            }
            if (this.client == null) {
                executor = new CommonsHttpInvokerRequestExecutor();
                this.client = executor.getHttpClient();
                if (initialContext != null) {
                    initialContext.put("http-client", this.client);
                }
            } else {
                executor = new CommonsHttpInvokerRequestExecutor(this.client);
            }
            prfb.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)executor);
            prfb.afterPropertiesSet();
            return prfb.getObject();
        }

        public HttpClient getClient() {
            return this.client;
        }

        public void setClient(HttpClient client) {
            this.client = client;
        }
    }

    private class RMIProxyBuilder
    implements ProxyBuilder {
        private RMIProxyBuilder() {
        }

        @Override
        public Object createProxy(Class serviceType, String url, Map initialContext) throws Exception {
            String rmiURL = "rmi://localhost:" + GenericServer.this.rmiRegistryPort + "/" + url;
            LOG.debug((Object)("Getting proxy for: " + GenericServer.this.rmiRegistryPort + " on " + GenericServer.this.result.serverPort()));
            RemoteLookupFailureException e = null;
            for (int i = 5; i > 0; --i) {
                try {
                    RmiProxyFactoryBean prfb = new RmiProxyFactoryBean();
                    prfb.setServiceUrl(rmiURL);
                    prfb.setServiceInterface(serviceType);
                    prfb.afterPropertiesSet();
                    return prfb.getObject();
                }
                catch (RemoteLookupFailureException lookupException) {
                    e = lookupException;
                    Thread.sleep(30000L);
                    continue;
                }
            }
            throw e;
        }
    }
}

