/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileSystemPath {
    private final File path;

    public boolean equals(Object obj) {
        if (!(obj instanceof FileSystemPath)) {
            return false;
        }
        FileSystemPath other = (FileSystemPath)obj;
        return this.path.equals(other.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private FileSystemPath(String path) {
        this.path = new File(path);
    }

    public FileSystemPath(File dir) {
        this.path = dir;
    }

    public static FileSystemPath existingDir(String path) {
        FileSystemPath f = new FileSystemPath(path);
        if (!f.isDirectory()) {
            throw new RuntimeException("Non-existent directory: " + path);
        }
        return f;
    }

    boolean isDirectory() {
        return this.path.isDirectory();
    }

    public static FileSystemPath makeExistingFile(String path) {
        FileSystemPath f = new FileSystemPath(path);
        if (!f.isFile()) {
            throw new RuntimeException("Non-existent file: " + path);
        }
        return f;
    }

    private boolean isFile() {
        return this.path.isFile();
    }

    public String toString() {
        try {
            return this.path.getCanonicalPath();
        }
        catch (IOException e) {
            return this.path.getAbsolutePath();
        }
    }

    public FileSystemPath existingSubdir(String subdirectoryPath) {
        return FileSystemPath.existingDir(this.path + "/" + subdirectoryPath);
    }

    public FileSystemPath existingFile(String fileName) {
        return FileSystemPath.makeExistingFile(this.path + "/" + fileName);
    }

    public File getFile() {
        return this.path;
    }

    public FileSystemPath subdir(String subdirectoryPath) {
        return new FileSystemPath(this.path + "/" + subdirectoryPath);
    }

    public void delete() throws IOException {
        if (this.path.exists()) {
            FileUtils.forceDelete((File)this.path);
        }
    }

    public FileSystemPath file(String fileName) {
        return new FileSystemPath(this.path + "/" + fileName);
    }

    public FileSystemPath mkdir(String subdir) {
        return this.subdir(subdir).mkdir();
    }

    private FileSystemPath mkdir() {
        this.path.mkdirs();
        return this;
    }

    public static FileSystemPath makeNewFile(String fileName) {
        return new FileSystemPath(fileName);
    }
}

