/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.config.schema.test.L2ConfigBuilder;
import com.tc.config.schema.test.TerracottaConfigBuilder;
import com.tc.objectserver.control.ExtraProcessServerControl;
import com.tc.test.server.appserver.deployment.AbstractStoppable;
import com.tc.util.TcConfigBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DSOServer
extends AbstractStoppable {
    private static final String SERVER_TEST_CONFIG = "server-config.xml";
    private ExtraProcessServerControl serverProc = null;
    private final boolean withPersistentStore;
    private int serverPort = 9510;
    private int adminPort = 9520;
    private int groupPort = 9530;
    private final List jvmArgs = new ArrayList();
    private final File workingDir;
    private TcConfigBuilder configBuilder;

    public DSOServer(boolean withPersistentStore, File workingDir) {
        this.withPersistentStore = withPersistentStore;
        this.workingDir = workingDir;
    }

    public DSOServer(boolean withPersistentStore, File workingDir, TcConfigBuilder configBuilder) {
        this.withPersistentStore = withPersistentStore;
        this.workingDir = workingDir;
        this.configBuilder = configBuilder;
        this.serverPort = configBuilder.getDsoPort();
        this.adminPort = configBuilder.getJmxPort();
        this.groupPort = configBuilder.getGroupPort();
    }

    @Override
    protected void doStart() throws Exception {
        File configFile = this.writeConfig();
        this.serverProc = new ExtraProcessServerControl("localhost", this.serverPort, this.adminPort, configFile.getAbsolutePath(), false);
        this.serverProc.writeOutputTo((OutputStream)new FileOutputStream(new File(this.workingDir, "dso-server.log")));
        this.serverProc.getJvmArgs().addAll(this.jvmArgs);
        this.serverProc.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.logger.debug((Object)"Stopping...");
        this.serverProc.shutdown();
        this.logger.debug((Object)"...stopped");
    }

    private File writeConfig() throws IOException {
        File configFile = new File(this.workingDir, SERVER_TEST_CONFIG);
        if (this.configBuilder != null) {
            this.configBuilder.setTcConfigFile(configFile);
            this.configBuilder.saveToFile();
        } else {
            TerracottaConfigBuilder builder = TerracottaConfigBuilder.newMinimalInstance();
            builder.getSystem().setConfigurationModel("development");
            L2ConfigBuilder l2 = builder.getServers().getL2s()[0];
            l2.setDSOPort(this.serverPort);
            l2.setJMXPort(this.adminPort);
            l2.setL2GroupPort(this.groupPort);
            l2.setData(this.workingDir + File.separator + "data");
            l2.setLogs(this.workingDir + File.separator + "logs");
            if (this.withPersistentStore) {
                l2.setPersistenceMode("permanent-store");
            }
            String configAsString = builder.toString();
            FileOutputStream fileOutputStream = new FileOutputStream(configFile);
            PrintWriter out = new PrintWriter(fileOutputStream);
            out.println(configAsString);
            out.flush();
            out.close();
        }
        return configFile;
    }

    public String toString() {
        return "DSO server; serverport:" + this.serverPort + "; adminPort:" + this.adminPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public List getJvmArgs() {
        return this.jvmArgs;
    }
}

