/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.server.appserver.deployment.Stoppable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStoppable
implements Stoppable {
    protected boolean stopped = true;
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void start() throws Exception {
        this.logger.info((Object)("### Starting " + this));
        long l1 = System.currentTimeMillis();
        this.doStart();
        this.stopped = false;
        long l2 = System.currentTimeMillis();
        this.logger.info((Object)("### Started " + this + "; " + (float)(l2 - l1) / 1000.0f));
    }

    @Override
    public void stop() throws Exception {
        this.logger.info((Object)("### Stopping " + this));
        long l1 = System.currentTimeMillis();
        this.stopped = true;
        this.doStop();
        long l2 = System.currentTimeMillis();
        this.logger.info((Object)("### Stopped " + this + "; " + (float)(l2 - l1) / 1000.0f));
    }

    protected abstract void doStop() throws Exception;

    protected abstract void doStart() throws Exception;

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void stopIgnoringExceptions() {
        try {
            this.stop();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }
}

