/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.deployment.AbstractDeploymentTestCase;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.test.server.appserver.deployment.DeploymentBuilder;
import com.tc.test.server.appserver.deployment.ServerManager;
import com.tc.test.server.appserver.deployment.ServerTestSetup;
import com.tc.test.server.appserver.deployment.WebApplicationServer;
import com.tc.util.TcConfigBuilder;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStandaloneTwoServerDeploymentTest
extends AbstractDeploymentTestCase {
    public WebApplicationServer server0;
    public WebApplicationServer server1;

    public AbstractStandaloneTwoServerDeploymentTest() {
        if (AbstractStandaloneTwoServerDeploymentTest.commitTimeoutTaskAdded((boolean)false, (boolean)true)) {
            this.scheduleTimeoutTask();
        }
    }

    public void setServer0(WebApplicationServer server0) {
        this.server0 = server0;
    }

    public void setServer1(WebApplicationServer server1) {
        this.server1 = server1;
    }

    @Override
    protected boolean shouldKillAppServersEachRun() {
        return false;
    }

    public static abstract class StandaloneTwoContextTestSetup
    extends StandaloneTwoServerTestSetupBase {
        protected StandaloneTwoContextTestSetup(Class testClass, String tcConfigFile, String context0, String context1) {
            super(testClass, new TcConfigBuilder(tcConfigFile), context0, context1);
        }
    }

    public static abstract class StandaloneTwoServerTestSetup
    extends StandaloneTwoServerTestSetupBase {
        protected StandaloneTwoServerTestSetup(Class testClass, String context) {
            super(testClass, context, null);
        }

        @Override
        protected final void configureWar(int server, DeploymentBuilder builder) {
            this.configureWar(builder);
        }

        protected abstract void configureWar(DeploymentBuilder var1);
    }

    private static abstract class StandaloneTwoServerTestSetupBase
    extends ServerTestSetup {
        private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        private final String context0;
        private final String context1;
        protected WebApplicationServer server0;
        protected WebApplicationServer server1;

        protected StandaloneTwoServerTestSetupBase(Class testClass, String context0, String context1) {
            this(testClass, null, context0, context1);
        }

        public StandaloneTwoServerTestSetupBase(Class testClass, TcConfigBuilder tcConfigBuilder, String context0, String context1) {
            super(testClass, tcConfigBuilder);
            this.context0 = context0;
            this.context1 = context1;
        }

        @Override
        protected void setUp() throws Exception {
            if (this.shouldDisable()) {
                return;
            }
            super.setUp();
            try {
                this.getServerManager();
                long l1 = System.currentTimeMillis();
                Deployment deployment0 = this.makeWAR(0);
                long l2 = System.currentTimeMillis();
                this.logger.info((Object)("### WAR build 0 " + (float)(l2 - l1) / 1000.0f + " at " + deployment0.getFileSystemPath()));
                Deployment deployment1 = null;
                if (null != this.context1) {
                    deployment1 = this.makeWAR(1);
                    long l3 = System.currentTimeMillis();
                    this.logger.info((Object)("### WAR build 1 " + (float)(l3 - l2) / 1000.0f + " at " + deployment1.getFileSystemPath()));
                }
                this.configureTcConfig(this.getTcConfigBuilder());
                this.server0 = this.createServer(deployment0, this.context0);
                this.server1 = null != deployment1 ? this.createServer(deployment1, this.context1) : this.createServer(deployment0, this.context0);
                TestSuite suite = (TestSuite)this.getTest();
                for (int i = 0; i < suite.testCount(); ++i) {
                    Test t = suite.testAt(i);
                    if (!(t instanceof AbstractStandaloneTwoServerDeploymentTest)) continue;
                    AbstractStandaloneTwoServerDeploymentTest test = (AbstractStandaloneTwoServerDeploymentTest)t;
                    test.setServer0(this.server0);
                    test.setServer1(this.server1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ServerManager sm = this.getServerManager();
                if (sm != null) {
                    sm.stop();
                }
                throw e;
            }
        }

        private WebApplicationServer createServer(Deployment deployment, String context) throws Exception {
            WebApplicationServer server = this.getServerManager().makeWebApplicationServerNoDso();
            this.configureServerParamers(server.getServerParameters());
            server.addWarDeployment(deployment, context);
            server.start();
            return server;
        }

        private Deployment makeWAR(int server) throws Exception {
            String context = server == 0 ? this.context0 : this.context1;
            DeploymentBuilder builder = this.makeDeploymentBuilder(context + ".war");
            builder.addDirectoryOrJARContainingClass(this.getTestClass());
            this.configureWar(server, builder);
            return builder.makeDeployment();
        }

        protected abstract void configureWar(int var1, DeploymentBuilder var2);

        protected void configureTcConfig(TcConfigBuilder clientConfig) {
        }

        protected void configureServerParamers(StandardAppServerParameters params) {
        }
    }
}

