/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.deployment.AbstractDeploymentTestCase;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.test.server.appserver.deployment.DeploymentBuilder;
import com.tc.test.server.appserver.deployment.ServerManager;
import com.tc.test.server.appserver.deployment.ServerTestSetup;
import com.tc.test.server.appserver.deployment.WebApplicationServer;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStandaloneOneServerDeploymentTest
extends AbstractDeploymentTestCase {
    public WebApplicationServer server0;

    public AbstractStandaloneOneServerDeploymentTest() {
        if (AbstractStandaloneOneServerDeploymentTest.commitTimeoutTaskAdded((boolean)false, (boolean)true)) {
            this.scheduleTimeoutTask();
        }
    }

    public void setServer0(WebApplicationServer server0) {
        this.server0 = server0;
    }

    @Override
    protected boolean shouldKillAppServersEachRun() {
        return false;
    }

    public static abstract class StandaloneOneServerTestSetup
    extends ServerTestSetup {
        private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        private final String context;
        private boolean start = true;
        protected WebApplicationServer server0;

        protected StandaloneOneServerTestSetup(Class testClass, String context) {
            super(testClass);
            this.context = context;
        }

        protected void setStart(boolean start) {
            this.start = start;
        }

        @Override
        protected void setUp() throws Exception {
            if (this.shouldDisable()) {
                return;
            }
            super.setUp();
            try {
                this.getServerManager();
                long l1 = System.currentTimeMillis();
                Deployment deployment = this.makeWAR();
                long l2 = System.currentTimeMillis();
                this.logger.info((Object)("### WAR build " + (float)(l2 - l1) / 1000.0f + " at " + deployment.getFileSystemPath()));
                this.server0 = this.createServer(deployment);
                TestSuite suite = (TestSuite)this.getTest();
                for (int i = 0; i < suite.testCount(); ++i) {
                    Test t = suite.testAt(i);
                    if (!(t instanceof AbstractStandaloneOneServerDeploymentTest)) continue;
                    AbstractStandaloneOneServerDeploymentTest test = (AbstractStandaloneOneServerDeploymentTest)t;
                    test.setServer0(this.server0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ServerManager sm = this.getServerManager();
                if (sm != null) {
                    sm.stop();
                }
                throw e;
            }
        }

        private WebApplicationServer createServer(Deployment deployment) throws Exception {
            WebApplicationServer server = this.getServerManager().makeWebApplicationServerNoDso();
            server.addWarDeployment(deployment, this.context);
            this.configureServerParamers(server.getServerParameters());
            if (this.start) {
                server.start();
            }
            return server;
        }

        private Deployment makeWAR() throws Exception {
            DeploymentBuilder builder = this.makeDeploymentBuilder(this.context + ".war");
            builder.addDirectoryOrJARContainingClass(this.getTestClass());
            this.configureWar(builder);
            return builder.makeDeployment();
        }

        protected abstract void configureWar(DeploymentBuilder var1);

        protected void configureServerParamers(StandardAppServerParameters params) {
        }
    }
}

