/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.deployment.AbstractDeploymentTestCase;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.test.server.appserver.deployment.DeploymentBuilder;
import com.tc.test.server.appserver.deployment.ServerManager;
import com.tc.test.server.appserver.deployment.ServerTestSetup;
import com.tc.test.server.appserver.deployment.WebApplicationServer;
import com.tc.util.TcConfigBuilder;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOneServerDeploymentTest
extends AbstractDeploymentTestCase {
    public WebApplicationServer server0;

    public AbstractOneServerDeploymentTest() {
        if (AbstractOneServerDeploymentTest.commitTimeoutTaskAdded((boolean)false, (boolean)true)) {
            this.scheduleTimeoutTask();
        }
    }

    public void setServer0(WebApplicationServer server0) {
        this.server0 = server0;
    }

    @Override
    protected boolean shouldKillAppServersEachRun() {
        return false;
    }

    public static abstract class OneServerTestSetup
    extends ServerTestSetup {
        private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        private final String context;
        protected WebApplicationServer server0;

        protected OneServerTestSetup(Class testClass, String context) {
            super(testClass);
            this.context = context;
        }

        protected OneServerTestSetup(Class testClass, String tcConfigFromResource, String context) {
            super(testClass, new TcConfigBuilder(tcConfigFromResource));
            this.context = context;
        }

        protected boolean autostart() {
            return true;
        }

        @Override
        protected void setUp() throws Exception {
            if (this.shouldDisable()) {
                return;
            }
            super.setUp();
            try {
                this.getServerManager();
                long l1 = System.currentTimeMillis();
                Deployment deployment = this.makeWAR();
                long l2 = System.currentTimeMillis();
                this.logger.info((Object)("### WAR build " + (float)(l2 - l1) / 1000.0f + " at " + deployment.getFileSystemPath()));
                this.configureTcConfig(this.getTcConfigBuilder());
                this.server0 = this.createServer(deployment);
                TestSuite suite = (TestSuite)this.getTest();
                for (int i = 0; i < suite.testCount(); ++i) {
                    Test t = suite.testAt(i);
                    if (!(t instanceof AbstractOneServerDeploymentTest)) continue;
                    AbstractOneServerDeploymentTest test = (AbstractOneServerDeploymentTest)t;
                    test.setServer0(this.server0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ServerManager sm = this.getServerManager();
                if (sm != null) {
                    sm.stop();
                }
                throw e;
            }
        }

        private WebApplicationServer createServer(Deployment deployment) throws Exception {
            WebApplicationServer server = this.getServerManager().makeWebApplicationServer(this.getTcConfigBuilder());
            server.addWarDeployment(deployment, this.context);
            this.configureServer(server);
            this.configureServerParamers(server.getServerParameters());
            if (this.autostart()) {
                server.start();
            }
            return server;
        }

        private Deployment makeWAR() throws Exception {
            DeploymentBuilder builder = this.makeDeploymentBuilder(this.context + ".war");
            builder.addDirectoryOrJARContainingClass(this.getTestClass());
            this.configureWar(builder);
            return builder.makeDeployment();
        }

        protected abstract void configureWar(DeploymentBuilder var1);

        protected void configureTcConfig(TcConfigBuilder clientConfig) {
        }

        protected void configureServerParamers(StandardAppServerParameters params) {
        }

        protected void configureServer(WebApplicationServer server) {
        }
    }
}

