/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.deployment;

import com.tc.test.AppServerInfo;
import com.tc.test.TCTestCase;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.deployment.DeploymentBuilder;
import com.tc.test.server.appserver.deployment.ErrorTestSetup;
import com.tc.test.server.appserver.deployment.ServerManager;
import com.tc.test.server.appserver.deployment.ServerManagerUtil;
import com.tc.test.server.appserver.deployment.TestCallback;
import com.tc.test.server.appserver.deployment.WebApplicationServer;
import com.tc.test.server.appserver.load.LowMemWorkaround;
import com.tc.text.Banner;
import com.tc.util.TcConfigBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDeploymentTestCase
extends TCTestCase {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServerManager serverManager;
    private final Map disabledVariants = new HashMap();
    private final List disabledJavaVersion = new ArrayList();
    private final boolean isExpressMode = TestConfigObject.getInstance().isExpressModeForAppserver();

    public static Test suite() {
        return new ErrorTestSetup((Test)new TestSuite(AbstractDeploymentTestCase.class));
    }

    protected boolean isContainerTest() {
        return true;
    }

    public boolean shouldDisable() {
        if (LowMemWorkaround.lessThan2Gb()) {
            return true;
        }
        if (!TestConfigObject.getInstance().transparentTestsMode().equals("normal")) {
            Banner.warnBanner((String)"NOT RUNNNING TEST BECAUSE TEST MODE IS NOT 'normal'");
            return true;
        }
        return this.shouldBeSkipped() || this.isAllDisabled() || this.shouldDisableForJavaVersion() || this.shouldDisableForVariants() || this.isExpressMode() && !this.canRunExpressMode();
    }

    protected void beforeTimeout() throws Throwable {
        this.getServerManager().timeout();
    }

    protected boolean shouldKillAppServersEachRun() {
        return true;
    }

    protected AppServerInfo appServerInfo() {
        return TestConfigObject.getInstance().appServerInfo();
    }

    protected Collection getExtraJvmArgsForL2() {
        return Collections.EMPTY_LIST;
    }

    public void runBare() throws Throwable {
        if (this.shouldBeSkipped()) {
            Banner.warnBanner((String)("Test " + ((Object)((Object)this)).getClass().getName() + " is skipped because it's not configured to run with an appserver"));
        }
        if (this.shouldDisable()) {
            return;
        }
        super.runBare();
    }

    protected ServerManager getServerManager() {
        if (this.serverManager == null) {
            try {
                this.serverManager = ServerManagerUtil.startAndBind(((Object)((Object)this)).getClass(), this.isWithPersistentStore(), this.getSessionLocking(), this.getSynchronousWrite(), this.getExtraJvmArgsForL2());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create server manager; " + e.toString(), e);
            }
        }
        return this.serverManager;
    }

    protected void tearDown() throws Exception {
        if (this.shouldKillAppServersEachRun()) {
            ServerManagerUtil.stopAllWebServers(this.serverManager);
        }
        super.tearDown();
    }

    protected WebApplicationServer makeWebApplicationServer(TcConfigBuilder configBuilder) throws Exception {
        return this.getServerManager().makeWebApplicationServer(configBuilder);
    }

    protected WebApplicationServer makeWebApplicationServer(TcConfigBuilder configBuilder, boolean addExpress) throws Exception {
        return this.getServerManager().makeWebApplicationServer(configBuilder, addExpress);
    }

    protected void restartDSO() throws Exception {
        this.getServerManager().restartDSO(this.isWithPersistentStore());
    }

    protected DeploymentBuilder makeDeploymentBuilder(String warFileName) {
        return this.getServerManager().makeDeploymentBuilder(warFileName);
    }

    protected DeploymentBuilder makeDeploymentBuilder(String warFileName, boolean enableExpress) {
        return this.getServerManager().makeDeploymentBuilder(warFileName, enableExpress);
    }

    protected void waitForSuccess(int timeoutInSeconds, TestCallback callback) throws Throwable {
        long startingTime = System.currentTimeMillis();
        long timeout = timeoutInSeconds * 1000;
        while (true) {
            try {
                this.logger.debug((Object)"checking");
                callback.check();
                this.logger.debug((Object)"check passed");
                return;
            }
            catch (Throwable e) {
                this.logger.debug((Object)"check failed");
                if (System.currentTimeMillis() - startingTime >= timeout) {
                    this.logger.debug((Object)"check timed out", e);
                    throw e;
                }
                this.logger.debug((Object)"check sleeping");
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }

    protected void stopAllWebServers() {
        ServerManagerUtil.stopAllWebServers(this.getServerManager());
    }

    protected boolean isWithPersistentStore() {
        return false;
    }

    protected final boolean cleanTempDir() {
        return false;
    }

    protected void disableVariant(String variantName, String variantValue) {
        ArrayList<String> variantList = (ArrayList<String>)this.disabledVariants.get(variantName);
        if (variantList == null) {
            variantList = new ArrayList<String>();
            this.disabledVariants.put(variantName, variantList);
        }
        variantList.add(variantValue);
    }

    protected void disableForJavaVersion(String version) {
        this.disabledJavaVersion.add(version);
    }

    void disableAllTests() {
        this.disableTest();
    }

    private boolean shouldDisableForVariants() {
        for (Map.Entry entry : this.disabledVariants.entrySet()) {
            String selected;
            String variantName = (String)entry.getKey();
            List variants = (List)entry.getValue();
            if (!variants.contains(selected = this.getServerManager().getTestConfig().selectedVariantFor(variantName))) continue;
            this.logger.warn((Object)("Test " + this.getName() + " is disabled for " + variantName + " = " + selected));
            return true;
        }
        return false;
    }

    private boolean shouldDisableForJavaVersion() {
        String currentVersion = System.getProperties().getProperty("java.version");
        for (String version : this.disabledJavaVersion) {
            if (!currentVersion.matches(version)) continue;
            this.logger.warn((Object)("Test " + this.getName() + " is disabled for " + version));
            return true;
        }
        return false;
    }

    public final boolean isSessionLockingTrue() {
        Boolean sessionLocking = this.getSessionLocking();
        if (sessionLocking == null) {
            return !this.isExpressMode();
        }
        return sessionLocking;
    }

    protected Boolean getSessionLocking() {
        return null;
    }

    protected Boolean getSynchronousWrite() {
        return null;
    }

    public boolean isExpressMode() {
        return this.isExpressMode;
    }

    protected boolean canRunExpressMode() {
        return true;
    }
}

