/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.cargo;

import com.tc.lcp.CargoLinkedChildProcess;
import com.tc.test.TestConfigObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class CargoJava
extends Java {
    private static final boolean DEBUG = false;
    public static final Link LINK = new Link();
    private final Java java;
    private Path classpath;
    private String className;
    private final List args;
    private boolean dirSet = false;

    public CargoJava(Java java) {
        this.java = java;
        this.args = new ArrayList();
    }

    private void wrapProcess() {
        Args linkArgs;
        try {
            linkArgs = Link.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        File dir = linkArgs.instancePath;
        String logFile = new File(dir.getParent(), dir.getName() + ".log").getAbsolutePath();
        if (!this.dirSet) {
            this.setDir(dir);
        }
        this.java.setOutput(new File(logFile));
        this.java.setAppend(true);
        this.java.setFailonerror(true);
        this.assignWrappedArgs(linkArgs);
        TestConfigObject config = TestConfigObject.getInstance();
        this.classpath.setPath(this.classpath.toString() + File.pathSeparatorChar + config.extraClassPathForAppServer());
        this.java.setClassname(CargoLinkedChildProcess.class.getName());
        Environment.Variable envVar = new Environment.Variable();
        envVar.setKey("JAVA_HOME");
        envVar.setValue(System.getProperty("java.home"));
        this.java.addEnv(envVar);
        this.java.createJvmarg().setValue("-DNODE=" + dir.getName());
        this.java.execute();
    }

    private static CommandlineJava getCommandLine(Java j) {
        try {
            Field f = j.getClass().getDeclaredField("cmdl");
            f.setAccessible(true);
            return (CommandlineJava)f.get(j);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assignWrappedArgs(Args linkArgs) {
        this.java.clearArgs();
        this.java.createArg().setValue(this.className);
        this.java.createArg().setValue(Integer.toString(linkArgs.port));
        this.java.createArg().setValue(linkArgs.instancePath.getAbsolutePath());
        Iterator iter = this.args.iterator();
        while (iter.hasNext()) {
            String[] parts = ((Commandline.Argument)iter.next()).getParts();
            for (int i = 0; i < parts.length; ++i) {
                this.java.createArg().setValue(parts[i]);
            }
        }
    }

    public void addEnv(Environment.Variable arg0) {
        this.java.addEnv(arg0);
    }

    public void addSysproperty(Environment.Variable arg0) {
        this.java.addSysproperty(arg0);
    }

    public void clearArgs() {
        this.java.clearArgs();
    }

    public Commandline.Argument createArg() {
        Commandline.Argument out = this.java.createArg();
        this.args.add(out);
        return out;
    }

    public Path createClasspath() {
        Path path;
        this.classpath = path = this.java.createClasspath();
        return path;
    }

    public Commandline.Argument createJvmarg() {
        return this.java.createJvmarg();
    }

    public boolean equals(Object obj) {
        return this.java.equals(obj);
    }

    public void execute() throws BuildException {
        this.wrapProcess();
    }

    public int executeJava() throws BuildException {
        return this.java.executeJava();
    }

    public String getDescription() {
        return this.java.getDescription();
    }

    public Location getLocation() {
        return this.java.getLocation();
    }

    public Target getOwningTarget() {
        return this.java.getOwningTarget();
    }

    public Project getProject() {
        return this.java.getProject();
    }

    public RuntimeConfigurable getRuntimeConfigurableWrapper() {
        return this.java.getRuntimeConfigurableWrapper();
    }

    public String getTaskName() {
        return this.java.getTaskName();
    }

    public int hashCode() {
        return this.java.hashCode();
    }

    public void init() throws BuildException {
        this.java.init();
    }

    public void log(String arg0, int arg1) {
        this.java.log(arg0, arg1);
    }

    public void log(String arg0) {
        this.java.log(arg0);
    }

    public void maybeConfigure() throws BuildException {
        this.java.maybeConfigure();
    }

    public void setAppend(boolean arg0) {
        this.java.setAppend(arg0);
    }

    public void setArgs(String arg0) {
        this.java.setArgs(arg0);
    }

    public void setClassname(String arg0) throws BuildException {
        this.className = arg0;
        this.java.setClassname(arg0);
    }

    public void setClasspath(Path arg0) {
        this.java.setClasspath(arg0);
    }

    public void setClasspathRef(Reference arg0) {
        this.java.setClasspathRef(arg0);
    }

    public void setDescription(String arg0) {
        this.java.setDescription(arg0);
    }

    public void setDir(File arg0) {
        this.java.setDir(arg0);
        this.dirSet = true;
    }

    public void setFailonerror(boolean arg0) {
        this.java.setFailonerror(arg0);
    }

    public void setFork(boolean arg0) {
        this.java.setFork(arg0);
    }

    public void setJar(File arg0) throws BuildException {
        try {
            String absPath = arg0.getCanonicalFile().getParentFile().getParent();
            JarFile jar = new JarFile(arg0);
            Manifest manifest = jar.getManifest();
            Attributes attrib = manifest.getMainAttributes();
            String classPathAttrib = attrib.getValue("Class-Path");
            String absClassPath = classPathAttrib.replaceAll("^\\.\\.", absPath).replaceAll("\\s\\.\\.", File.pathSeparatorChar + absPath);
            this.classpath.setPath(this.classpath.toString() + File.pathSeparatorChar + absClassPath);
            this.classpath.setPath(this.classpath.toString() + File.pathSeparator + arg0);
            this.setClassname(attrib.getValue("Main-Class"));
        }
        catch (IOException ioe) {
            throw new BuildException("problem reading manifest");
        }
    }

    public void setJvm(String arg0) {
        this.java.setJvm(arg0);
    }

    public void setJvmargs(String arg0) {
        this.java.setJvmargs(arg0);
    }

    public void setJVMVersion(String arg0) {
        this.java.setJVMVersion(arg0);
    }

    public void setLocation(Location arg0) {
        this.java.setLocation(arg0);
    }

    public void setMaxmemory(String arg0) {
        this.java.setMaxmemory(arg0);
    }

    public void setNewenvironment(boolean arg0) {
        this.java.setNewenvironment(arg0);
    }

    public void setOutput(File arg0) {
        this.java.setOutput(arg0);
    }

    public void setOwningTarget(Target arg0) {
        this.java.setOwningTarget(arg0);
    }

    public void setProject(Project arg0) {
        this.java.setProject(arg0);
    }

    public void setRuntimeConfigurableWrapper(RuntimeConfigurable arg0) {
        this.java.setRuntimeConfigurableWrapper(arg0);
    }

    public void setTaskName(String arg0) {
        this.java.setTaskName(arg0);
    }

    public void setTimeout(Long arg0) {
        this.java.setTimeout(arg0);
    }

    public String toString() {
        return this.java.toString();
    }

    public static class Link {
        private static Args args = null;
        private static final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Args take() throws InterruptedException {
            Object object = lock;
            synchronized (object) {
                while (args == null) {
                    lock.wait();
                }
                Args rv = args;
                args = null;
                lock.notifyAll();
                return rv;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void put(Args putArgs) throws InterruptedException {
            Object object = lock;
            synchronized (object) {
                while (args != null) {
                    lock.wait();
                }
                args = putArgs;
                lock.notifyAll();
            }
        }
    }

    public static class Args {
        final File instancePath;
        final int port;

        public Args(int port, File instancePath) {
            this.port = port;
            this.instancePath = instancePath;
        }
    }
}

