/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver.cargo;

import com.tc.lcp.HeartBeatService;
import com.tc.test.server.ServerParameters;
import com.tc.test.server.ServerResult;
import com.tc.test.server.appserver.AbstractAppServer;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerResult;
import com.tc.test.server.appserver.StandardAppServerParameters;
import com.tc.test.server.appserver.cargo.CargoJava;
import com.tc.test.server.util.AppServerUtil;
import java.io.File;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.util.log.Logger;

public abstract class CargoAppServer
extends AbstractAppServer {
    private static final int DEFAULT_START_TIMEOUT = 480000;
    private InstalledLocalContainer container;
    private int port;
    private int linkedPort;
    public static final String CARGO_JAVA = "cargo_java";
    public static final String CARGO_JAVA_CLASS = CargoJava.class.getName();

    public CargoAppServer(AppServerInstallation installation) {
        super(installation);
    }

    @Override
    public final ServerResult start(ServerParameters rawParams) throws Exception {
        StandardAppServerParameters params = (StandardAppServerParameters)rawParams;
        this.adjustParams(params);
        this.port = AppServerUtil.getPort();
        File instance = this.createInstance(params);
        this.setProperties(params, this.port, instance);
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        LocalConfiguration config = (LocalConfiguration)factory.createConfiguration(this.cargoServerKey(), ContainerType.INSTALLED, ConfigurationType.STANDALONE, instance.getAbsolutePath());
        this.setConfigProperties(config);
        config.setProperty("cargo.servlet.port", Integer.toString(this.port));
        config.setProperty("cargo.jvmargs", params.jvmArgs());
        config.setProperty("cargo.logging", "low");
        this.addDeployables(config, params.deployables(), params.instanceName());
        this.container = this.container(config, params);
        this.container.setTimeout((long)Integer.valueOf(params.properties().getProperty("START_TIMEOUT", "480000")).intValue());
        this.container.setHome(this.serverInstallDirectory().getAbsolutePath());
        this.container.setLogger((Logger)new AbstractAppServer.ConsoleLogger(params.instanceName()));
        this.setExtraClasspath(params);
        this.linkJavaProcess(instance);
        this.container.start();
        return new AppServerResult(this.port, this);
    }

    protected void adjustParams(StandardAppServerParameters params) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(ServerParameters rawParams) {
        if (this.container != null && (this.container.getState().equals(State.STARTED) || this.container.getState().equals(State.STARTING) || this.container.getState().equals(State.UNKNOWN))) {
            try {
                String jvmArgs = this.container.getConfiguration().getPropertyValue("cargo.jvmargs");
                try {
                    this.container.getConfiguration().setProperty("cargo.jvmargs", null);
                    this.container.stop();
                }
                finally {
                    this.container.getConfiguration().setProperty("cargo.jvmargs", jvmArgs);
                }
            }
            catch (ContainerException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addDeployables(LocalConfiguration config, Map wars, String instanceName) {
        for (Map.Entry entry : wars.entrySet()) {
            WAR deployable;
            String context = (String)entry.getKey();
            File deployableFile = (File)entry.getValue();
            System.out.println("Deployable: " + deployableFile);
            if (deployableFile.getName().endsWith("war")) {
                deployable = new WAR(deployableFile.getPath());
                deployable.setContext(context);
                deployable.setLogger((Logger)new AbstractAppServer.ConsoleLogger(instanceName));
                config.addDeployable((Deployable)deployable);
                continue;
            }
            if (deployableFile.getName().endsWith("ear")) {
                deployable = new EAR(deployableFile.getPath());
                deployable.setLogger((Logger)new AbstractAppServer.ConsoleLogger(instanceName));
                config.addDeployable((Deployable)deployable);
                continue;
            }
            throw new RuntimeException("Unknown deployable: " + deployableFile);
        }
    }

    private void linkJavaProcess(File instance) throws InterruptedException {
        this.linkedPort = HeartBeatService.listenPort();
        CargoJava.Link.put(new CargoJava.Args(this.linkedPort, instance));
    }

    protected final InstalledLocalContainer container() {
        return this.container;
    }

    protected abstract String cargoServerKey();

    protected abstract InstalledLocalContainer container(LocalConfiguration var1, AppServerParameters var2);

    protected void setConfigProperties(LocalConfiguration config) throws Exception {
    }

    protected void setExtraClasspath(AppServerParameters params) {
        if (params.extraClasspath().size() > 0) {
            String[] extraClasspath = params.extraClasspath().toArray(new String[0]);
            this.container().setExtraClasspath(extraClasspath);
            System.out.println("XXX adding extra classpath for " + params.instanceName() + ": " + params.extraClasspath());
        }
    }

    static {
        System.setProperty(CARGO_JAVA, CARGO_JAVA_CLASS);
    }
}

