/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver;

import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.ValveDefinition;
import com.tc.test.server.appserver.deployment.Deployment;
import com.tc.util.runtime.Os;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class StandardAppServerParameters
implements AppServerParameters {
    public static final String START_TIMEOUT = "START_TIMEOUT";
    private final Map<String, Deployment> deployments = new HashMap<String, Deployment>();
    private final Collection sars = new ArrayList();
    private final Collection<ValveDefinition> valves = new ArrayList<ValveDefinition>();
    private final Collection<String> tomcatServerJars = new ArrayList<String>();
    private final String instanceName;
    private final Properties props;
    private String jvmArgs = "";
    private final List<String> extraClassPath = new ArrayList<String>();

    public StandardAppServerParameters(String instanceName, Properties props) {
        this.instanceName = instanceName;
        this.props = props;
    }

    public void addDeployment(String context, Deployment deployment) {
        this.deployments.put(context, deployment);
    }

    public final void addSar(File sar) {
        this.sars.add(sar);
    }

    public final void addValve(ValveDefinition def) {
        this.valves.add(def);
    }

    public final void addTomcatServerJar(String jar) {
        this.tomcatServerJars.add(jar);
    }

    @Override
    public final String jvmArgs() {
        return this.jvmArgs;
    }

    public final void appendJvmArgs(String jvmArgsVar) {
        this.jvmArgs = this.jvmArgs + jvmArgsVar + " ";
    }

    @Override
    public final List<String> extraClasspath() {
        return this.extraClassPath;
    }

    public final void appendClasspath(String classpathVar) {
        this.extraClassPath.add(classpathVar);
    }

    @Override
    public final Map<String, File> deployables() {
        HashMap<String, File> deployables = new HashMap<String, File>();
        for (Map.Entry<String, Deployment> e : this.deployments.entrySet()) {
            deployables.put(e.getKey(), e.getValue().getFileSystemPath().getFile());
        }
        return deployables;
    }

    @Override
    public Map<String, Deployment> deployments() {
        return this.deployments;
    }

    @Override
    public final String instanceName() {
        return this.instanceName;
    }

    @Override
    public final Properties properties() {
        return this.props;
    }

    public String writeTerracottaClassPathFile() {
        String string;
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile("tc-classpath", this.instanceName);
            tempFile.deleteOnExit();
            fos = new FileOutputStream(tempFile);
            fos.write(System.getProperty("java.class.path").getBytes());
            String rv = tempFile.getAbsolutePath();
            if (Os.isWindows()) {
                rv = "/" + rv;
            }
            string = rv;
        }
        catch (IOException ioe) {
            try {
                throw new AssertionError((Object)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return string;
    }

    public void appendSysProp(String name, int value) {
        this.appendSysProp(name, Integer.toString(value));
    }

    public void appendSysProp(String name, String value) {
        if (!name.startsWith("-")) {
            name = "-D" + name;
        }
        if (value == null) {
            this.appendJvmArgs(name);
        } else {
            this.appendJvmArgs(name + "=" + value);
        }
    }

    public void appendSysProp(String name) {
        this.appendSysProp(name, null);
    }

    public void appendSysProp(String name, boolean b) {
        this.appendSysProp(name, Boolean.toString(b));
    }

    @Override
    public Collection sars() {
        return this.sars;
    }

    @Override
    public Collection<ValveDefinition> valves() {
        return this.valves;
    }

    @Override
    public Collection<String> tomcatServerJars() {
        return this.tomcatServerJars;
    }
}

