/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver;

import com.tc.exception.ImplementMe;
import com.tc.test.AppServerInfo;
import com.tc.test.TestConfigObject;
import com.tc.test.server.appserver.AppServer;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.glassfishv1.GlassfishV1AppServerFactory;
import com.tc.test.server.appserver.glassfishv2.GlassfishV2AppServerFactory;
import com.tc.test.server.appserver.glassfishv3.GlassfishV3AppServerFactory;
import com.tc.test.server.appserver.jboss3x.JBoss3xAppServerFactory;
import com.tc.test.server.appserver.jboss42x.JBoss42xAppServerFactory;
import com.tc.test.server.appserver.jboss4x.JBoss4xAppServerFactory;
import com.tc.test.server.appserver.jboss51x.JBoss51xAppServerFactory;
import com.tc.test.server.appserver.jboss6x.JBoss6xAppServerFactory;
import com.tc.test.server.appserver.jboss7x.JBoss7xAppServerFactory;
import com.tc.test.server.appserver.jetty6x.Jetty6xAppServerFactory;
import com.tc.test.server.appserver.jetty7x.Jetty7xAppServerFactory;
import com.tc.test.server.appserver.resin31x.Resin31xAppServerFactory;
import com.tc.test.server.appserver.tomcat5x.Tomcat5xAppServerFactory;
import com.tc.test.server.appserver.tomcat6x.Tomcat6xAppServerFactory;
import com.tc.test.server.appserver.tomcat7x.Tomcat7xAppServerFactory;
import com.tc.test.server.appserver.was6x.Was6xAppServerFactory;
import com.tc.test.server.appserver.was7x.Was7xAppServerFactory;
import com.tc.test.server.appserver.wasce1x.Wasce1xAppServerFactory;
import com.tc.test.server.appserver.weblogic10x.Weblogic10xAppServerFactory;
import com.tc.test.server.appserver.weblogic8x.Weblogic8xAppServerFactory;
import com.tc.test.server.appserver.weblogic9x.Weblogic9xAppServerFactory;
import com.tc.util.Assert;
import java.io.File;
import java.util.Properties;

public abstract class AppServerFactory {
    protected AppServerFactory(ProtectedKey protectedKey) {
        Assert.assertNotNull((Object)protectedKey);
    }

    public abstract AppServerParameters createParameters(String var1, Properties var2);

    public AppServerParameters createParameters(String instanceName) {
        return this.createParameters(instanceName, new Properties());
    }

    public abstract AppServer createAppServer(AppServerInstallation var1);

    public abstract AppServerInstallation createInstallation(File var1, File var2, AppServerInfo var3) throws Exception;

    public static final AppServerFactory createFactoryFromProperties() {
        AppServerInfo appServerInfo = TestConfigObject.getInstance().appServerInfo();
        String factoryName = appServerInfo.getName();
        String majorVersion = appServerInfo.getMajor();
        String minorVersion = appServerInfo.getMinor();
        System.out.println("APPSERVERINFO: " + appServerInfo);
        switch (appServerInfo.getId()) {
            case 2: {
                if ("5".equals(majorVersion)) {
                    return new Tomcat5xAppServerFactory(new ProtectedKey());
                }
                if ("6".equals(majorVersion)) {
                    return new Tomcat6xAppServerFactory(new ProtectedKey());
                }
                if (!"7".equals(majorVersion)) break;
                return new Tomcat7xAppServerFactory(new ProtectedKey());
            }
            case 0: {
                if ("8".equals(majorVersion)) {
                    return new Weblogic8xAppServerFactory(new ProtectedKey());
                }
                if ("9".equals(majorVersion)) {
                    return new Weblogic9xAppServerFactory(new ProtectedKey());
                }
                if (!"10".equals(majorVersion)) break;
                return new Weblogic10xAppServerFactory(new ProtectedKey());
            }
            case 3: {
                if (!"1".equals(majorVersion)) break;
                return new Wasce1xAppServerFactory(new ProtectedKey());
            }
            case 1: {
                if ("3".equals(majorVersion)) {
                    return new JBoss3xAppServerFactory(new ProtectedKey());
                }
                if ("4".equals(majorVersion)) {
                    if (minorVersion.startsWith("0")) {
                        return new JBoss4xAppServerFactory(new ProtectedKey());
                    }
                    if (minorVersion.startsWith("2")) {
                        return new JBoss42xAppServerFactory(new ProtectedKey());
                    }
                }
                if ("5".equals(majorVersion) && minorVersion.startsWith("1")) {
                    return new JBoss51xAppServerFactory(new ProtectedKey());
                }
                if ("6".equals(majorVersion) && minorVersion.startsWith("0")) {
                    return new JBoss6xAppServerFactory(new ProtectedKey());
                }
                if (!"7".equals(majorVersion) || !minorVersion.startsWith("1")) break;
                return new JBoss7xAppServerFactory(new ProtectedKey());
            }
            case 4: {
                if ("v1".equals(majorVersion)) {
                    return new GlassfishV1AppServerFactory(new ProtectedKey());
                }
                if ("v2".equals(majorVersion)) {
                    return new GlassfishV2AppServerFactory(new ProtectedKey());
                }
                if (!"v3".equals(majorVersion)) break;
                return new GlassfishV3AppServerFactory(new ProtectedKey());
            }
            case 5: {
                if ("6".equals(majorVersion)) {
                    return new Jetty6xAppServerFactory(new ProtectedKey());
                }
                if (!"7".equals(majorVersion)) break;
                return new Jetty7xAppServerFactory(new ProtectedKey());
            }
            case 6: {
                if (!"3".equals(majorVersion)) break;
                return new Resin31xAppServerFactory(new ProtectedKey());
            }
            case 7: {
                if ("6".equals(majorVersion)) {
                    return new Was6xAppServerFactory(new ProtectedKey());
                }
                if (!"7".equals(majorVersion)) break;
                return new Was7xAppServerFactory(new ProtectedKey());
            }
        }
        throw new ImplementMe("App server named '" + factoryName + "' with major version " + majorVersion + " is not yet supported.");
    }

    protected static class ProtectedKey {
        protected ProtectedKey() {
        }
    }
}

