/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver;

import com.tc.test.AppServerInfo;
import com.tc.test.server.appserver.AppServerStartupEnvironment;
import com.tc.util.Assert;
import java.io.File;
import org.apache.commons.io.FileUtils;

public abstract class AbstractAppServerInstallation
implements AppServerStartupEnvironment {
    private final AppServerInfo appServerInfo;
    private final File workingDirectory;
    private final File serverInstall;
    private final File dataDirectory;
    private final File sandboxDirectory;
    private final boolean isRepoInstall;

    public AbstractAppServerInstallation(File home, File workingDir, AppServerInfo appServerInfo) throws Exception {
        Assert.assertTrue((boolean)home.isDirectory());
        Assert.assertTrue((boolean)workingDir.isDirectory());
        this.appServerInfo = appServerInfo;
        this.serverInstall = home;
        this.isRepoInstall = false;
        this.workingDirectory = workingDir;
        this.dataDirectory = new File(this.workingDirectory + File.separator + "data");
        this.dataDirectory.mkdir();
        this.sandboxDirectory = this.workingDirectory;
        new File(workingDir + File.separator + appServerInfo.toString()).createNewFile();
    }

    @Override
    public final File dataDirectory() {
        return this.dataDirectory;
    }

    public abstract String serverType();

    @Override
    public final void uninstall() throws Exception {
        FileUtils.deleteDirectory((File)this.workingDirectory.getParentFile());
    }

    @Override
    public final File workingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public final File serverInstallDirectory() {
        return this.serverInstall;
    }

    @Override
    public File sandboxDirectory() {
        return this.sandboxDirectory;
    }

    @Override
    public boolean isRepoInstall() {
        return this.isRepoInstall;
    }

    @Override
    public AppServerInfo appServerInfo() {
        return this.appServerInfo;
    }
}

