/*
 * Decompiled with CFR 0.152.
 */
package com.tc.test.server.appserver;

import com.tc.test.AppServerInfo;
import com.tc.test.Handle;
import com.tc.test.server.appserver.AppServer;
import com.tc.test.server.appserver.AppServerInstallation;
import com.tc.test.server.appserver.AppServerParameters;
import com.tc.test.server.appserver.AppServerStartupEnvironment;
import com.tc.text.Banner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.codehaus.cargo.util.internal.log.AbstractLogger;
import org.codehaus.cargo.util.log.LogLevel;

public abstract class AbstractAppServer
implements AppServer {
    private final AppServerStartupEnvironment installation;
    private File instance;

    public AbstractAppServer(AppServerInstallation installation) {
        this.installation = (AppServerStartupEnvironment)installation;
    }

    protected final synchronized File createInstance(AppServerParameters params) throws Exception {
        this.instance = new File(this.installation.sandboxDirectory() + File.separator + params.instanceName());
        if (this.instance.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.instance);
            }
            catch (IOException e) {
                Banner.warnBanner((String)(this.instance + " exists.\n" + Handle.getJavaProcessFileHandles((File)this.instance)));
                this.instance = new File(this.instance.getAbsolutePath() + "_" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()));
            }
        }
        this.instance.mkdir();
        return this.instance;
    }

    protected final File serverInstallDirectory() {
        if (!this.installation.isRepoInstall()) {
            return this.installation.serverInstallDirectory();
        }
        return new File(this.installation.serverInstallDirectory() + File.separator + this.installation.appServerInfo().toString());
    }

    protected final File sandboxDirectory() {
        return this.installation.sandboxDirectory();
    }

    protected AppServerInfo appServerInfo() {
        return this.installation.appServerInfo();
    }

    protected final void setProperties(AppServerParameters params, int port, File instance) {
        Properties props = params.properties();
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("app_instance", params.instanceName());
        props.setProperty("app_port", Integer.toString(port));
        File propsFile = new File(instance + ".properties");
        FileOutputStream fos = null;
        try {
            propsFile.createNewFile();
            fos = new FileOutputStream(propsFile, false);
            props.store(fos, "Available Application System Properties");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write properties file to: " + propsFile, ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to write properties file to: " + propsFile, ioe);
                }
            }
        }
    }

    public static final class ConsoleLogger
    extends AbstractLogger {
        private final String instance;

        public ConsoleLogger(String instance) {
            this.instance = instance;
        }

        protected void doLog(LogLevel level, String message, String category) {
            SimpleDateFormat FORMAT = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss.SSS");
            String msg = "[" + FORMAT.format(new Date()) + "]" + "[" + level.getLevel() + "][" + this.instance + "] " + message;
            System.out.println(msg);
        }
    }
}

