/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.express;

import com.terracotta.toolkit.express.AppClassLoader;
import com.terracotta.toolkit.express.ClientCreatorCallable;
import com.terracotta.toolkit.express.ClientHandle;
import com.terracotta.toolkit.express.ClientHandleImpl;
import com.terracotta.toolkit.express.ClusteredStateLoader;
import com.terracotta.toolkit.express.ClusteredStateLoaderImpl;
import com.terracotta.toolkit.express.CreateClient;
import com.terracotta.toolkit.express.DevmodeClusteredStateLoader;
import com.terracotta.toolkit.express.TerracottaInternalClient;
import com.terracotta.toolkit.express.loader.Util;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.terracotta.toolkit.ToolkitRuntimeException;

class TerracottaInternalClientImpl
implements TerracottaInternalClient {
    public static final String TERRACOTTA_CUSTOM_SECRET_PROVIDER_PROP = "com.terracotta.SecretProvider";
    private static final String CLIENT_HANDLE_IMPL = "com.terracotta.toolkit.express.ClientHandleImpl";
    public static final String SECRET_PROVIDER = "com.terracotta.express.SecretProvider";
    private static final String EE_SECRET_DELEGATE = "com.terracotta.toolkit.DelegatingSecretProvider";
    private static final String SECRET_PROVIDER_CLASS = "org.terracotta.toolkit.SecretProvider";
    private static final String EHCACHE_EXPRESS_ENTERPRISE_TERRACOTTA_CLUSTERED_INSTANCE_FACTORY = "net.sf.ehcache.terracotta.ExpressEnterpriseTerracottaClusteredInstanceFactory";
    private static final String EHCACHE_EXPRESS_TERRACOTTA_CLUSTERED_INSTANCE_FACTORY = "net.sf.ehcache.terracotta.StandaloneTerracottaClusteredInstanceFactory";
    private final ClusteredStateLoader clusteredStateLoader;
    private final AppClassLoader appClassLoader;
    private final ClientCreatorCallable clientCreator;
    private final Set<String> tunneledMBeanDomains = new HashSet<String>();
    private volatile ClientHandle clientHandle;
    private volatile boolean shutdown = false;
    private volatile boolean isInitialized = false;

    TerracottaInternalClientImpl(String tcConfig, boolean isUrlConfig, ClassLoader appLoader, boolean rejoinEnabled, Set<String> tunneledMBeanDomains, String productId, Map<String, Object> env) {
        if (tunneledMBeanDomains != null) {
            this.tunneledMBeanDomains.addAll(tunneledMBeanDomains);
        }
        try {
            this.appClassLoader = new AppClassLoader(appLoader);
            this.clusteredStateLoader = this.createClusteredStateLoader(appLoader);
            Class<?> bootClass = this.clusteredStateLoader.loadClass(CreateClient.class.getName());
            Constructor<?> cstr = bootClass.getConstructor(String.class, Boolean.TYPE, ClassLoader.class, Boolean.TYPE, String.class, Map.class);
            if (isUrlConfig && TerracottaInternalClientImpl.isRequestingSecuredEnv(tcConfig) && env != null) {
                env.put(TERRACOTTA_CUSTOM_SECRET_PROVIDER_PROP, TerracottaInternalClientImpl.newSecretProviderDelegate(this.clusteredStateLoader, env.get(SECRET_PROVIDER)));
            }
            Callable boot = (Callable)cstr.newInstance(tcConfig, isUrlConfig, this.clusteredStateLoader, rejoinEnabled, productId, env);
            this.clientCreator = (ClientCreatorCallable)boot.call();
        }
        catch (Exception e) {
            throw new ToolkitRuntimeException(e);
        }
    }

    @Override
    public synchronized void init() {
        if (this.isInitialized) {
            return;
        }
        try {
            Class<?> clientHandleImpl = this.clusteredStateLoader.loadClass(CLIENT_HANDLE_IMPL);
            this.clientHandle = (ClientHandle)clientHandleImpl.getConstructor(Object.class).newInstance(this.clientCreator.call());
            this.isInitialized = true;
            this.join(this.tunneledMBeanDomains);
            this.setSecretHackOMFG();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setSecretHackOMFG() {
        try {
            this.appClassLoader.loadClass("com.terracotta.management.keychain.KeyChain");
            Class<?> omfg = this.appClassLoader.loadClass("net.sf.ehcache.thrift.server.tc.TkSecurityManager");
            Field secret = omfg.getDeclaredField("SECRET");
            if (secret.getType() == byte[].class) {
                secret.setAccessible(true);
                Class<?> secretProviderClass = this.clusteredStateLoader.loadClass("com.terracotta.management.security.SecretProvider");
                Method method = secretProviderClass.getMethod("getSecret", new Class[0]);
                secret.set(null, method.invoke(null, new Object[0]));
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Object getPlatformService() {
        return this.clientHandle.getPlatformService();
    }

    @Override
    public Object getAbortableOperationManager() {
        return this.clientCreator.getAbortableOperationManager();
    }

    @Override
    public String getUuid() {
        return this.clientCreator.getUuid();
    }

    private synchronized void join(Set<String> tunnelledMBeanDomainsParam) throws ClientShutdownException {
        if (this.shutdown) {
            throw new ClientShutdownException();
        }
        if (this.isInitialized) {
            this.clientHandle.activateTunnelledMBeanDomains(tunnelledMBeanDomainsParam);
        } else if (tunnelledMBeanDomainsParam != null) {
            this.tunneledMBeanDomains.addAll(tunnelledMBeanDomainsParam);
        }
    }

    @Override
    public <T> T instantiate(String className, Class[] cstrArgTypes, Object[] cstrArgs) throws Exception {
        try {
            Class<?> clazz = this.clusteredStateLoader.loadClass(className);
            Constructor<?> cstr = clazz.getConstructor(cstrArgTypes);
            return (T)cstr.newInstance(cstrArgs);
        }
        catch (InvocationTargetException e) {
            Throwable targetEx = e.getTargetException();
            throw targetEx instanceof ToolkitRuntimeException ? (ToolkitRuntimeException)targetEx : new ToolkitRuntimeException(targetEx);
        }
    }

    @Override
    public Class loadClass(String className) throws ClassNotFoundException {
        return this.clusteredStateLoader.loadClass(className);
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        try {
            if (this.clientHandle != null) {
                this.clientHandle.shutdown();
            }
        }
        finally {
            this.clientHandle = null;
            this.appClassLoader.clear();
        }
    }

    private byte[] getClassBytes(Class klass) {
        ClassLoader loader = this.getClass().getClassLoader();
        String res = klass.getName().replace('.', '/').concat(".class");
        try {
            return Util.extract(loader.getResourceAsStream(res));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isEmbeddedEhcacheRequired() {
        try {
            Class.forName("net.sf.ehcache.CacheManager");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        try {
            Class.forName(EHCACHE_EXPRESS_TERRACOTTA_CLUSTERED_INSTANCE_FACTORY);
            return false;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName(EHCACHE_EXPRESS_ENTERPRISE_TERRACOTTA_CLUSTERED_INSTANCE_FACTORY);
                return false;
            }
            catch (ClassNotFoundException e2) {
                return true;
            }
        }
    }

    private ClusteredStateLoader createClusteredStateLoader(ClassLoader appLoader) {
        ClusteredStateLoader loader = null;
        URL devmodeUrl = DevmodeClusteredStateLoader.devModeResource();
        loader = devmodeUrl != null ? new DevmodeClusteredStateLoader(devmodeUrl, this.appClassLoader, TerracottaInternalClientImpl.isEmbeddedEhcacheRequired()) : new ClusteredStateLoaderImpl(this.appClassLoader, TerracottaInternalClientImpl.isEmbeddedEhcacheRequired());
        loader.addExtraClass(ClientHandleImpl.class.getName(), this.getClassBytes(ClientHandleImpl.class));
        loader.addExtraClass(CreateClient.class.getName(), this.getClassBytes(CreateClient.class));
        loader.addExtraClass(CreateClient.ClientCreatorCallableImpl.class.getName(), this.getClassBytes(CreateClient.ClientCreatorCallableImpl.class));
        return loader;
    }

    private static boolean isRequestingSecuredEnv(String tcConfig) {
        return tcConfig.contains("@");
    }

    private static Object newSecretProviderDelegate(ClassLoader loader, Object backEnd) {
        try {
            Class<?> customClass = Class.forName(SECRET_PROVIDER_CLASS);
            Class<?> tkClass = loader.loadClass(EE_SECRET_DELEGATE);
            return tkClass.getConstructor(customClass).newInstance(backEnd);
        }
        catch (Exception e) {
            String message = backEnd != null ? "Couldn't wrap the custom impl. " + backEnd.getClass().getName() + " in an instance of " + EE_SECRET_DELEGATE : "Couldn't fetch keychain password from the console";
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public boolean isOnline() {
        ClientHandle handle = this.clientHandle;
        return handle == null ? false : handle.isOnline();
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    static class ClientShutdownException
    extends Exception {
        ClientShutdownException() {
        }
    }
}

