/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.express;

import com.terracotta.toolkit.client.TerracottaClientConfig;
import com.terracotta.toolkit.express.TerracottaInternalClient;
import com.terracotta.toolkit.express.TerracottaInternalClientFactory;
import com.terracotta.toolkit.express.TerracottaInternalClientImpl;
import com.terracotta.toolkit.express.URLConfigUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TerracottaInternalClientFactoryImpl
implements TerracottaInternalClientFactory {
    private final ConcurrentMap<String, Map<String, Object>> envByUrl = new ConcurrentHashMap<String, Map<String, Object>>();

    public TerracottaInternalClientFactoryImpl() {
        TerracottaInternalClientFactoryImpl.testForWrongTcconfig();
        System.setProperty("tc.active", "true");
        System.setProperty("tc.dso.globalmode", "false");
    }

    @Override
    public TerracottaInternalClient createL1Client(TerracottaClientConfig config) {
        String tcConfig = config.getTcConfigSnippetOrUrl();
        if (config.isUrl()) {
            tcConfig = URLConfigUtil.translateSystemProperties(tcConfig);
        }
        return this.createClient(tcConfig, config.isUrl(), config.isRejoin(), config.getTunnelledMBeanDomains(), config.getProductId());
    }

    private TerracottaInternalClient createClient(String tcConfig, boolean isUrlConfig, boolean rejoinClient, Set<String> tunneledMBeanDomains, String productId) {
        Map<String, Object> env = this.createEnvIfAbsent(tcConfig);
        TerracottaInternalClientImpl client = new TerracottaInternalClientImpl(tcConfig, isUrlConfig, this.getClass().getClassLoader(), rejoinClient, tunneledMBeanDomains, productId, new ConcurrentHashMap<String, Object>(env));
        return client;
    }

    private static void testForWrongTcconfig() {
        String tcConfigValue = System.getProperty("tc.config");
        if (tcConfigValue != null) {
            throw new RuntimeException("The Terracotta config file should not be set through -Dtc.config in this usage.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> createEnvIfAbsent(String tcConfig) {
        Map<String, Object> env = (Map<String, Object>)this.envByUrl.get(tcConfig);
        if (env == null) {
            ConcurrentMap<String, Map<String, Object>> concurrentMap = this.envByUrl;
            synchronized (concurrentMap) {
                env = (Map)this.envByUrl.get(tcConfig);
                if (env != null) {
                    return env;
                }
                env = this.createNewEnv();
                Map<String, Object> previous = this.envByUrl.putIfAbsent(tcConfig, env);
                if (previous != null) {
                    throw new IllegalStateException("Some environment map was already present for config " + tcConfig);
                }
            }
        }
        return env;
    }

    private Map<String, Object> createNewEnv() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        String secretProviderClass = System.getProperty("com.terracotta.express.SecretProvider");
        if (secretProviderClass != null) {
            Object instance = TerracottaInternalClientFactoryImpl.newInstance(secretProviderClass);
            try {
                instance.getClass().getMethod("fetchSecret", new Class[0]).invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking fetchSecret on " + secretProviderClass, e);
            }
            env.put("com.terracotta.express.SecretProvider", instance);
        }
        return env;
    }

    private static <T> T newInstance(String secretProviderClass) {
        try {
            return (T)Class.forName(secretProviderClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate a new instance of " + secretProviderClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't load or instantiate a new instance of " + secretProviderClass, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't load Class " + secretProviderClass, e);
        }
    }
}

