/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.express;

import com.terracotta.toolkit.express.ClusteredStateLoader;
import com.terracotta.toolkit.express.ClusteredStateLoaderImpl;
import com.terracotta.toolkit.express.loader.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;

class DevmodeClusteredStateLoader
extends ClusteredStateLoader {
    private static final boolean USE_APP_JTA_CLASSES;
    private static final String DEVMODE_OS_DEPENDENCIES_RESOURCE = "/META-INF/devmode/org.terracotta/terracotta-toolkit-runtime/embedded-dependencies.txt";
    private static final String DEVMODE_EE_DEPENDENCIES_RESOURCE = "/META-INF/devmode/org.terracotta/terracotta-toolkit-runtime-ee/embedded-dependencies.txt";
    private final URLClassLoader urlClassLoader;
    private final ClassLoader appLoader;

    public DevmodeClusteredStateLoader(URL depsReource, ClassLoader appLoader, boolean useEmbeddedEhcache) {
        super(null);
        this.appLoader = appLoader;
        this.urlClassLoader = this.initUrlClassLoader(depsReource, useEmbeddedEhcache);
    }

    public static URL devModeResource() {
        URL url = DevmodeClusteredStateLoader.class.getResource(DEVMODE_EE_DEPENDENCIES_RESOURCE);
        if (url != null) {
            return url;
        }
        url = DevmodeClusteredStateLoader.class.getResource(DEVMODE_OS_DEPENDENCIES_RESOURCE);
        if (url != null) {
            return url;
        }
        return null;
    }

    private URLClassLoader initUrlClassLoader(URL depsReource, boolean useEmbeddedEhcache) {
        URLClassLoader uRLClassLoader;
        ArrayList<URL> urlList = new ArrayList<URL>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(depsReource.openStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("#ehcache") && !useEmbeddedEhcache) break;
                if (line.startsWith("#")) continue;
                URL url = new URL(line);
                urlList.add(url);
            }
            uRLClassLoader = new URLClassLoader(urlList.toArray(new URL[0]), null);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(reader);
                throw throwable;
            }
        }
        Util.closeQuietly(reader);
        return uRLClassLoader;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> rv = this.loadClass(name);
        if (resolve) {
            this.resolveClass(rv);
        }
        return rv;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        URL url;
        Class<?> rv = this.findLoadedClass(name);
        if (rv != null) {
            return rv;
        }
        byte[] extra = (byte[])this.extraClasses.remove(name);
        if (extra != null) {
            return this.returnAndLog(this.defineClass(name, extra), "extra");
        }
        if (USE_APP_JTA_CLASSES && name.startsWith("javax.transaction.")) {
            return this.returnAndLog(this.appLoader.loadClass(name), "appLoader");
        }
        if (name.startsWith("org.slf4j")) {
            try {
                return this.returnAndLog(this.appLoader.loadClass(name), "appLoader");
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if ((url = this.urlClassLoader.findResource(name.replace('.', '/') + ".class")) != null) {
            return this.returnAndLog(this.loadClassFromUrl(name, url, this.appLoader.getClass().getProtectionDomain().getCodeSource()), "embedded jars");
        }
        try {
            return this.returnAndLog(this.appLoader.loadClass(name), "appLoader");
        }
        catch (ClassNotFoundException cnfe) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != this && contextClassLoader != this.appLoader && contextClassLoader != this.getParent()) {
                return this.returnAndLog(contextClassLoader.loadClass(name), contextClassLoader.toString());
            }
            throw cnfe;
        }
    }

    private Class<?> defineClass(String name, byte[] bytes) throws ClassFormatError {
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.urlClassLoader.getResource(name);
        if (resource != null) {
            return resource;
        }
        resource = super.getResource(name);
        if (resource != null) {
            return resource;
        }
        return this.appLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = this.urlClassLoader.getResources(name);
        if (resources != null && resources.hasMoreElements()) {
            return resources;
        }
        resources = super.getResources(name);
        if (resources != null && resources.hasMoreElements()) {
            return resources;
        }
        return this.appLoader.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream in;
        URL resource = this.urlClassLoader.getResource(name);
        if (resource != null) {
            try {
                return resource.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((in = super.getResourceAsStream(name)) != null) {
            return in;
        }
        return this.appLoader.getResourceAsStream(name);
    }

    static {
        String prop = System.getProperty(ClusteredStateLoaderImpl.class.getName() + ".USE_APP_JTA_CLASSES", "true");
        prop = prop.trim();
        USE_APP_JTA_CLASSES = Boolean.valueOf(prop);
    }
}

