/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.express;

import com.terracotta.toolkit.express.AppClassLoader;
import com.terracotta.toolkit.express.ClusteredStateLoader;
import com.terracotta.toolkit.express.loader.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

class ClusteredStateLoaderImpl
extends ClusteredStateLoader {
    private static final boolean USE_APP_JTA_CLASSES;
    private static final String TOOLKIT_CONTENT_RESOURCE = "/toolkit-content.txt";
    private static final String PRIVATE_CLASS_SUFFIX = ".class_terracotta";
    private final ClassLoader appLoader;
    private final Map<String, HashSet<String>> internalResource;

    ClusteredStateLoaderImpl(AppClassLoader appLoader, boolean useEmbeddedEhcache) {
        super(null);
        this.appLoader = appLoader;
        this.internalResource = this.loadResourceIndex(useEmbeddedEhcache);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, HashSet<String>> loadResourceIndex(boolean useEmbeddedEhcache) {
        InputStream in = ClusteredStateLoaderImpl.class.getResourceAsStream(TOOLKIT_CONTENT_RESOURCE);
        if (in == null) {
            throw new RuntimeException("Couldn't load resource entries file at: /toolkit-content.txt");
        }
        BufferedReader reader = null;
        try {
            String line;
            HashMap content = new HashMap();
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                void var9_11;
                if ((line = line.trim()).length() == 0) continue;
                int secondSlash = line.indexOf("/", line.indexOf("/") + 1);
                String prefix = line.substring(0, secondSlash + 1);
                String resource = line.substring(secondSlash + 1);
                HashSet hashSet = (HashSet)content.get(prefix);
                if (hashSet == null) {
                    HashSet hashSet2 = new HashSet();
                    content.put(prefix, hashSet2);
                }
                var9_11.add(resource);
            }
            ArrayList<Object> filteredPrefix = null;
            if (useEmbeddedEhcache) {
                filteredPrefix = new ArrayList(content.keySet());
            } else {
                filteredPrefix = new ArrayList();
                for (String prefix : content.keySet()) {
                    if (prefix.startsWith("ehcache/")) continue;
                    filteredPrefix.add(prefix);
                }
            }
            Collections.sort(filteredPrefix);
            LinkedHashMap<String, HashSet<String>> sortedContent = new LinkedHashMap<String, HashSet<String>>();
            for (String string : filteredPrefix) {
                sortedContent.put(string, (HashSet<String>)content.get(string));
            }
            LinkedHashMap<String, HashSet<String>> linkedHashMap = sortedContent;
            return linkedHashMap;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            Util.closeQuietly(in);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream in;
        URL resource = this.findResourceWithPrefix(name);
        if (resource != null) {
            try {
                return resource.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((in = super.getResourceAsStream(name)) != null) {
            return in;
        }
        return this.appLoader.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = this.findResourcesWithPrefix(name);
        if (resources != null && resources.hasMoreElements()) {
            return resources;
        }
        resources = super.getResources(name);
        if (resources != null && resources.hasMoreElements()) {
            return resources;
        }
        return this.appLoader.getResources(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResourceWithPrefix(name);
        if (resource != null) {
            return resource;
        }
        resource = super.getResource(name);
        if (resource != null) {
            return resource;
        }
        return this.appLoader.getResource(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> rv = this.loadClass(name);
        if (resolve) {
            this.resolveClass(rv);
        }
        return rv;
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        URL url;
        Class<?> rv = this.findLoadedClass(name);
        if (rv != null) {
            return rv;
        }
        byte[] extra = (byte[])this.extraClasses.remove(name);
        if (extra != null) {
            return this.returnAndLog(this.defineClass(name, extra, 0, extra.length), "extra");
        }
        if (USE_APP_JTA_CLASSES && name.startsWith("javax.transaction.")) {
            return this.returnAndLog(this.appLoader.loadClass(name), "appLoader");
        }
        if (name.startsWith("org.slf4j")) {
            try {
                return this.returnAndLog(this.appLoader.loadClass(name), "appLoader");
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if ((url = this.findClassWithPrefix(name)) != null) {
            return this.returnAndLog(this.loadClassFromUrl(name, url, this.appLoader.getClass().getProtectionDomain().getCodeSource()), "embedded resource");
        }
        try {
            return this.returnAndLog(this.appLoader.loadClass(name), "appLoader");
        }
        catch (ClassNotFoundException cnfe) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != this && contextClassLoader != this.appLoader && contextClassLoader != this.getParent()) {
                return this.returnAndLog(contextClassLoader.loadClass(name), contextClassLoader.toString());
            }
            throw cnfe;
        }
    }

    private String findInternalPrefix(String resource) {
        for (Map.Entry<String, HashSet<String>> entry : this.internalResource.entrySet()) {
            String prefix = entry.getKey();
            HashSet<String> resources = entry.getValue();
            if (!resources.contains(resource)) continue;
            return prefix;
        }
        return null;
    }

    private URL findClassWithPrefix(String name) {
        String resource = name.replace('.', '/').concat(PRIVATE_CLASS_SUFFIX);
        String prefix = this.findInternalPrefix(resource);
        return prefix != null ? this.appLoader.getResource(prefix + resource) : null;
    }

    private URL findResourceWithPrefix(String name) {
        String resource = name.endsWith(".class") ? name.substring(0, name.lastIndexOf(".class")) + PRIVATE_CLASS_SUFFIX : name;
        String prefix = this.findInternalPrefix(resource);
        return prefix != null ? this.appLoader.getResource(prefix + resource) : null;
    }

    private Enumeration<URL> findResourcesWithPrefix(String name) throws IOException {
        Enumeration<URL> e;
        String resource = name.endsWith(".class") ? name.substring(0, name.lastIndexOf(".class")) + PRIVATE_CLASS_SUFFIX : name;
        Vector<URL> urls = new Vector<URL>();
        String prefix = this.findInternalPrefix(resource);
        if (prefix != null && (e = this.appLoader.getResources(prefix + resource)) != null) {
            while (e.hasMoreElements()) {
                urls.add(e.nextElement());
            }
        }
        if (urls.size() > 0) {
            return urls.elements();
        }
        return null;
    }

    static {
        String prop = System.getProperty(ClusteredStateLoaderImpl.class.getName() + ".USE_APP_JTA_CLASSES", "true");
        prop = prop.trim();
        USE_APP_JTA_CLASSES = Boolean.valueOf(prop);
    }
}

